/*
 * Decompiled with CFR 0.152.
 */
package gw.gosudoc.com.sun.tools.doclets.internal.toolkit;

import com.sun.tools.javac.util.StringUtils;
import gw.gosudoc.com.sun.javadoc.ClassDoc;
import gw.gosudoc.com.sun.javadoc.DocErrorReporter;
import gw.gosudoc.com.sun.javadoc.PackageDoc;
import gw.gosudoc.com.sun.javadoc.ProgramElementDoc;
import gw.gosudoc.com.sun.javadoc.RootDoc;
import gw.gosudoc.com.sun.javadoc.SourcePosition;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.Content;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.WriterFactory;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.builders.BuilderFactory;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.taglets.TagletManager;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.ClassDocCatalog;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocFile;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.Extern;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.Group;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.MessageRetriever;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.MetaKeywords;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.JavaFileManager;

@Deprecated
public abstract class Configuration {
    protected BuilderFactory builderFactory;
    public TagletManager tagletManager;
    public String builderXMLPath;
    private static final String DEFAULT_BUILDER_XML = "resources/doclet.xml";
    public String tagletpath = "";
    public boolean serialwarn = false;
    public int sourcetab;
    public String tabSpaces;
    public boolean linksource = false;
    public boolean nosince = false;
    public boolean copydocfilesubdirs = false;
    public String charset = "";
    public boolean keywords = false;
    public final MetaKeywords metakeywords;
    protected Set<String> excludedDocFileDirs;
    protected Set<String> excludedQualifiers;
    public RootDoc root;
    public Utils utils;
    public String destDirName = "";
    public String docFileDestDirName = "";
    public String docencoding = null;
    public boolean nocomment = false;
    public String encoding = null;
    public boolean showauthor = false;
    public boolean javafx = false;
    public boolean showversion = false;
    public boolean nodeprecated = false;
    public ClassDocCatalog classDocCatalog;
    public MessageRetriever message = null;
    public boolean notimestamp = false;
    public final Group group = new Group(this);
    public final Extern extern = new Extern(this);
    public SortedSet<PackageDoc> packages;
    public boolean exportInternalAPI;

    public abstract String getDocletSpecificBuildDate();

    public abstract void setSpecificDocletOptions(String[][] var1) throws Fault;

    public abstract MessageRetriever getDocletSpecificMsg();

    public Configuration() {
        this.message = new MessageRetriever(this, "gw.gosudoc.com.sun.tools.doclets.internal.toolkit.resources.doclets");
        this.excludedDocFileDirs = new HashSet<String>();
        this.excludedQualifiers = new HashSet<String>();
        this.setTabWidth(8);
        this.utils = new Utils();
        this.metakeywords = new MetaKeywords(this);
    }

    public BuilderFactory getBuilderFactory() {
        if (this.builderFactory == null) {
            this.builderFactory = new BuilderFactory(this);
        }
        return this.builderFactory;
    }

    public int optionLength(String option) {
        switch (option = StringUtils.toLowerCase(option)) {
            case "-author": 
            case "-docfilessubdirs": 
            case "-javafx": 
            case "-keywords": 
            case "-linksource": 
            case "-nocomment": 
            case "-nodeprecated": 
            case "-nosince": 
            case "-notimestamp": 
            case "-quiet": 
            case "-xnodate": 
            case "-version": 
            case "-xdaccessinternalapi": {
                return 1;
            }
            case "-d": 
            case "-docencoding": 
            case "-encoding": 
            case "-excludedocfilessubdir": 
            case "-link": 
            case "-sourcetab": 
            case "-noqualifier": 
            case "-output": 
            case "-sourcepath": 
            case "-tag": 
            case "-taglet": 
            case "-tagletpath": {
                return 2;
            }
            case "-group": 
            case "-linkoffline": {
                return 3;
            }
        }
        return -1;
    }

    public abstract boolean validOptions(String[][] var1, DocErrorReporter var2);

    private void initPackages() {
        this.packages = new TreeSet<PackageDoc>(Arrays.asList(this.root.specifiedPackages()));
        for (ClassDoc aClass : this.root.specifiedClasses()) {
            this.packages.add(aClass.containingPackage());
        }
    }

    public void setOptions(String[][] options) throws Fault {
        String opt;
        LinkedHashSet<String[]> customTagStrs = new LinkedHashSet<String[]>();
        for (String[] os : options) {
            opt = StringUtils.toLowerCase(os[0]);
            if (!opt.equals("-d")) continue;
            this.docFileDestDirName = this.destDirName = Configuration.addTrailingFileSep(os[1]);
            this.ensureOutputDirExists();
            break;
        }
        for (String[] os : options) {
            String url;
            opt = StringUtils.toLowerCase(os[0]);
            if (opt.equals("-docfilessubdirs")) {
                this.copydocfilesubdirs = true;
                continue;
            }
            if (opt.equals("-docencoding")) {
                this.docencoding = os[1];
                continue;
            }
            if (opt.equals("-encoding")) {
                this.encoding = os[1];
                continue;
            }
            if (opt.equals("-author")) {
                this.showauthor = true;
                continue;
            }
            if (opt.equals("-javafx")) {
                this.javafx = true;
                continue;
            }
            if (opt.equals("-nosince")) {
                this.nosince = true;
                continue;
            }
            if (opt.equals("-version")) {
                this.showversion = true;
                continue;
            }
            if (opt.equals("-nodeprecated")) {
                this.nodeprecated = true;
                continue;
            }
            if (opt.equals("-excludedocfilessubdir")) {
                this.addToSet(this.excludedDocFileDirs, os[1]);
                continue;
            }
            if (opt.equals("-noqualifier")) {
                this.addToSet(this.excludedQualifiers, os[1]);
                continue;
            }
            if (opt.equals("-linksource")) {
                this.linksource = true;
                continue;
            }
            if (opt.equals("-sourcetab")) {
                this.linksource = true;
                try {
                    this.setTabWidth(Integer.parseInt(os[1]));
                }
                catch (NumberFormatException e) {
                    this.sourcetab = -1;
                }
                if (this.sourcetab > 0) continue;
                this.message.warning("doclet.sourcetab_warning", new Object[0]);
                this.setTabWidth(8);
                continue;
            }
            if (opt.equals("-notimestamp")) {
                this.notimestamp = true;
                continue;
            }
            if (opt.equals("-nocomment")) {
                this.nocomment = true;
                continue;
            }
            if (opt.equals("-tag") || opt.equals("-taglet")) {
                customTagStrs.add(os);
                continue;
            }
            if (opt.equals("-tagletpath")) {
                this.tagletpath = os[1];
                continue;
            }
            if (opt.equals("-keywords")) {
                this.keywords = true;
                continue;
            }
            if (opt.equals("-serialwarn")) {
                this.serialwarn = true;
                continue;
            }
            if (opt.equals("-group")) {
                this.group.checkPackageGroups(os[1], os[2]);
                continue;
            }
            if (opt.equals("-link")) {
                url = os[1];
                this.extern.link(url, url, this.root, false);
                continue;
            }
            if (opt.equals("-linkoffline")) {
                url = os[1];
                String pkglisturl = os[2];
                this.extern.link(url, pkglisturl, this.root, true);
                continue;
            }
            if (!opt.equals("-xdaccessinternalapi")) continue;
            this.exportInternalAPI = true;
        }
        if (this.docencoding == null) {
            this.docencoding = this.encoding;
        }
        this.classDocCatalog = new ClassDocCatalog(this.root.specifiedClasses(), this);
        this.initTagletManager(customTagStrs);
    }

    public void setOptions() throws Fault {
        this.initPackages();
        this.setOptions(this.root.options());
        this.setSpecificDocletOptions(this.root.options());
    }

    private void ensureOutputDirExists() throws Fault {
        DocFile destDir = DocFile.createFileForDirectory(this, this.destDirName);
        if (!destDir.exists()) {
            this.root.printNotice(this.getText("doclet.dest_dir_create", this.destDirName));
            destDir.mkdirs();
        } else {
            if (!destDir.isDirectory()) {
                throw new Fault(this.getText("doclet.destination_directory_not_directory_0", destDir.getPath()));
            }
            if (!destDir.canWrite()) {
                throw new Fault(this.getText("doclet.destination_directory_not_writable_0", destDir.getPath()));
            }
        }
    }

    private void initTagletManager(Set<String[]> customTagStrs) {
        this.tagletManager = this.tagletManager == null ? new TagletManager(this.nosince, this.showversion, this.showauthor, this.javafx, this.exportInternalAPI, this.message) : this.tagletManager;
        for (String[] args : customTagStrs) {
            if (args[0].equals("-taglet")) {
                this.tagletManager.addCustomTag(args[1], this.getFileManager(), this.tagletpath);
                continue;
            }
            String[] tokens = this.tokenize(args[1], ':', 3);
            if (tokens.length == 1) {
                String tagName = args[1];
                if (this.tagletManager.isKnownCustomTag(tagName)) {
                    this.tagletManager.addNewSimpleCustomTag(tagName, null, "");
                    continue;
                }
                StringBuilder heading = new StringBuilder(tagName + ":");
                heading.setCharAt(0, Character.toUpperCase(tagName.charAt(0)));
                this.tagletManager.addNewSimpleCustomTag(tagName, heading.toString(), "a");
                continue;
            }
            if (tokens.length == 2) {
                this.tagletManager.addNewSimpleCustomTag(tokens[0], tokens[1], "");
                continue;
            }
            if (tokens.length >= 3) {
                this.tagletManager.addNewSimpleCustomTag(tokens[0], tokens[2], tokens[1]);
                continue;
            }
            this.message.error("doclet.Error_invalid_custom_tag_argument", args[1]);
        }
    }

    private String[] tokenize(String s, char separator, int maxTokens) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        boolean prevIsEscapeChar = false;
        for (int i = 0; i < s.length(); i += Character.charCount(i)) {
            int currentChar = s.codePointAt(i);
            if (prevIsEscapeChar) {
                token.appendCodePoint(currentChar);
                prevIsEscapeChar = false;
                continue;
            }
            if (currentChar == separator && tokens.size() < maxTokens - 1) {
                tokens.add(token.toString());
                token = new StringBuilder();
                continue;
            }
            if (currentChar == 92) {
                prevIsEscapeChar = true;
                continue;
            }
            token.appendCodePoint(currentChar);
        }
        if (token.length() > 0) {
            tokens.add(token.toString());
        }
        return tokens.toArray(new String[0]);
    }

    private void addToSet(Set<String> s, String str) {
        StringTokenizer st = new StringTokenizer(str, ":");
        while (st.hasMoreTokens()) {
            String current = st.nextToken();
            s.add(current);
        }
    }

    public static String addTrailingFileSep(String path) {
        int indexDblfs;
        String fs = System.getProperty("file.separator");
        String dblfs = fs + fs;
        while ((indexDblfs = ((String)path).indexOf(dblfs, 1)) >= 0) {
            path = ((String)path).substring(0, indexDblfs) + ((String)path).substring(indexDblfs + fs.length());
        }
        if (!((String)path).endsWith(fs)) {
            path = (String)path + fs;
        }
        return path;
    }

    public boolean generalValidOptions(String[][] options, DocErrorReporter reporter) {
        boolean docencodingfound = false;
        String encoding = "";
        for (int oi = 0; oi < options.length; ++oi) {
            String[] os = options[oi];
            String opt = StringUtils.toLowerCase(os[0]);
            if (opt.equals("-docencoding")) {
                docencodingfound = true;
                if (this.checkOutputFileEncoding(os[1], reporter)) continue;
                return false;
            }
            if (!opt.equals("-encoding")) continue;
            encoding = os[1];
        }
        return docencodingfound || encoding.length() <= 0 || this.checkOutputFileEncoding(encoding, reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkOutputFileEncoding(String docencoding, DocErrorReporter reporter) {
        ByteArrayOutputStream ost = new ByteArrayOutputStream();
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)ost, docencoding);
        }
        catch (UnsupportedEncodingException exc) {
            reporter.printError(this.getText("doclet.Encoding_not_supported", docencoding));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (osw != null) {
                    osw.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public boolean shouldExcludeDocFileDir(String docfilesubdir) {
        return this.excludedDocFileDirs.contains(docfilesubdir);
    }

    public boolean shouldExcludeQualifier(String qualifier) {
        if (this.excludedQualifiers.contains("all") || this.excludedQualifiers.contains(qualifier) || this.excludedQualifiers.contains(qualifier + ".*")) {
            return true;
        }
        int index = -1;
        while ((index = qualifier.indexOf(".", index + 1)) != -1) {
            if (!this.excludedQualifiers.contains(qualifier.substring(0, index + 1) + "*")) continue;
            return true;
        }
        return false;
    }

    public String getClassName(ClassDoc cd) {
        PackageDoc pd = cd.containingPackage();
        if (pd != null && this.shouldExcludeQualifier(cd.containingPackage().name())) {
            return cd.name();
        }
        return cd.qualifiedName();
    }

    public String getText(String key) {
        MessageRetriever docletMessage = this.getDocletSpecificMsg();
        if (docletMessage.containsKey(key)) {
            return docletMessage.getText(key, new Object[0]);
        }
        return this.message.getText(key, new Object[0]);
    }

    public String getText(String key, String a1) {
        MessageRetriever docletMessage = this.getDocletSpecificMsg();
        if (docletMessage.containsKey(key)) {
            return docletMessage.getText(key, a1);
        }
        return this.message.getText(key, a1);
    }

    public String getText(String key, String a1, String a2) {
        MessageRetriever docletMessage = this.getDocletSpecificMsg();
        if (docletMessage.containsKey(key)) {
            return docletMessage.getText(key, a1, a2);
        }
        return this.message.getText(key, a1, a2);
    }

    public String getText(String key, String a1, String a2, String a3) {
        MessageRetriever docletMessage = this.getDocletSpecificMsg();
        if (docletMessage.containsKey(key)) {
            return docletMessage.getText(key, a1, a2, a3);
        }
        return this.message.getText(key, a1, a2, a3);
    }

    public abstract Content newContent();

    public Content getResource(String key) {
        Content c = this.newContent();
        c.addContent(this.getText(key));
        return c;
    }

    public Content getResource(String key, Object o) {
        return this.getResource(key, o, null, null);
    }

    public Content getResource(String key, Object o1, Object o2) {
        return this.getResource(key, o1, o2, null);
    }

    public Content getResource(String key, Object o0, Object o1, Object o2) {
        Content c = this.newContent();
        Pattern p = Pattern.compile("\\{([012])\\}");
        String text = this.getText(key);
        Matcher m = p.matcher(text);
        int start = 0;
        while (m.find(start)) {
            c.addContent(text.substring(start, m.start()));
            Object o = null;
            switch (m.group(1).charAt(0)) {
                case '0': {
                    o = o0;
                    break;
                }
                case '1': {
                    o = o1;
                    break;
                }
                case '2': {
                    o = o2;
                }
            }
            if (o == null) {
                c.addContent("{" + m.group(1) + "}");
            } else if (o instanceof String) {
                c.addContent((String)o);
            } else if (o instanceof Content) {
                c.addContent((Content)o);
            }
            start = m.end();
        }
        c.addContent(text.substring(start));
        return c;
    }

    public boolean isGeneratedDoc(ClassDoc cd) {
        if (!this.nodeprecated) {
            return true;
        }
        return !this.utils.isDeprecated(cd) && !this.utils.isDeprecated(cd.containingPackage());
    }

    public abstract WriterFactory getWriterFactory();

    public InputStream getBuilderXML() throws IOException {
        return this.builderXMLPath == null ? Configuration.class.getResourceAsStream(DEFAULT_BUILDER_XML) : DocFile.createFileForInput(this, this.builderXMLPath).openInputStream();
    }

    public abstract Locale getLocale();

    public abstract JavaFileManager getFileManager();

    public abstract Comparator<ProgramElementDoc> getMemberComparator();

    private void setTabWidth(int n) {
        this.sourcetab = n;
        this.tabSpaces = String.format("%" + n + "s", "");
    }

    public abstract boolean showMessage(SourcePosition var1, String var2);

    public abstract JavaFileManager.Location getLocationForPackage(PackageDoc var1);

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = 0L;

        Fault(String msg) {
            super(msg);
        }

        Fault(String msg, Exception cause) {
            super(msg, cause);
        }
    }
}

