/*
 * This file is a shadowed version of the older javadoc codebase on which gosudoc is based; borrowed from jdk 9.
 */

package gw.gosudoc.com.sun.tools.doclets.formats.html;

import java.io.*;
import java.util.*;




import gw.gosudoc.com.sun.javadoc.Tag;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.HtmlTag;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.HtmlTree;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.Content;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocPath;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.MethodTypes;

/**
 * This abstract class exists to provide functionality needed in the
 * the formatting of member information.  Since AbstractSubWriter and its
 * subclasses control this, they would be the logical place to put this.
 * However, because each member type has its own subclass, subclassing
 * can not be used effectively to change formatting.  The concrete
 * class subclass of this class can be subclassed to change formatting.
 *
 *  <p><b>This is NOT part of any supported API.
 *  If you write code that depends on this, you do so at your own risk.
 *  This code and its internal interfaces are subject to change or
 *  deletion without notice.</b>
 *
 * @see AbstractMemberWriter
 * @see ClassWriterImpl
 *
 * @author Robert Field
 * @author Atul M Dambalkar
 * @author Bhavesh Patel (Modified)
 */
@Deprecated
public abstract class SubWriterHolderWriter extends HtmlDocletWriter {

    /**
     * The HTML tree for main tag.
     */
    protected HtmlTree mainTree = HtmlTree.MAIN();

    public SubWriterHolderWriter(ConfigurationImpl configuration, DocPath filename)
            throws IOException {
        super(configuration, filename);
    }

    /**
     * Add the summary header.
     *
     * @param mw the writer for the member being documented
     * @param cd the classdoc to be documented
     * @param memberTree the content tree to which the summary header will be added
     */
    public void addSummaryHeader(AbstractMemberWriter mw, gw.gosudoc.com.sun.javadoc.ClassDoc cd,
            Content memberTree) {
        mw.addSummaryAnchor(cd, memberTree);
        mw.addSummaryLabel(memberTree);
    }

    /**
     * Get the summary table.
     *
     * @param mw the writer for the member being documented
     * @param cd the classdoc to be documented
     * @param tableContents list of summary table contents
     * @param showTabs true if the table needs to show tabs
     * @return the content tree for the summary table
     */
    public Content getSummaryTableTree(AbstractMemberWriter mw, gw.gosudoc.com.sun.javadoc.ClassDoc cd,
            List<Content> tableContents, boolean showTabs) {
        Content caption;
        if (showTabs) {
            caption = getTableCaption(mw.methodTypes);
            generateMethodTypesScript(mw.typeMap, mw.methodTypes);
        }
        else {
            caption = getTableCaption(mw.getCaption());
        }
        Content table = (configuration.isOutputHtml5())
                ? HtmlTree.TABLE( HtmlStyle.memberSummary, caption)
                : HtmlTree.TABLE(HtmlStyle.memberSummary, mw.getTableSummary(), caption);
        table.addContent(getSummaryTableHeader(mw.getSummaryTableHeader(cd), "col"));
        for (Content tableContent : tableContents) {
            table.addContent(tableContent);
        }
        return table;
    }

    /**
     * Get the summary table caption.
     *
     * @param methodTypes set comprising of method types to show as table caption
     * @return the caption for the summary table
     */
    public Content getTableCaption(Set<MethodTypes> methodTypes) {
        Content tabbedCaption = new HtmlTree( HtmlTag.CAPTION);
        for (MethodTypes type : methodTypes) {
            Content captionSpan;
            Content span;
            if (type.isDefaultTab()) {
                captionSpan = HtmlTree.SPAN(configuration.getResource(type.resourceKey()));
                span = HtmlTree.SPAN(type.tabId(),
                        HtmlStyle.activeTableTab, captionSpan);
            } else {
                captionSpan = HtmlTree.SPAN(getMethodTypeLinks(type));
                span = HtmlTree.SPAN(type.tabId(),
                        HtmlStyle.tableTab, captionSpan);
            }
            Content tabSpan = HtmlTree.SPAN(HtmlStyle.tabEnd, getSpace());
            span.addContent(tabSpan);
            tabbedCaption.addContent(span);
        }
        return tabbedCaption;
    }

    /**
     * Get the method type links for the table caption.
     *
     * @param methodType the method type to be displayed as link
     * @return the content tree for the method type link
     */
    public Content getMethodTypeLinks(MethodTypes methodType) {
        String jsShow = "javascript:show(" + methodType.value() +");";
        HtmlTree link = HtmlTree.A(jsShow, configuration.getResource(methodType.resourceKey()));
        return link;
    }

    /**
     * Add the inherited summary header.
     *
     * @param mw the writer for the member being documented
     * @param cd the classdoc to be documented
     * @param inheritedTree the content tree to which the inherited summary header will be added
     */
    public void addInheritedSummaryHeader(AbstractMemberWriter mw, gw.gosudoc.com.sun.javadoc.ClassDoc cd,
            Content inheritedTree) {
        mw.addInheritedSummaryAnchor(cd, inheritedTree);
        mw.addInheritedSummaryLabel(cd, inheritedTree);
    }

    /**
     * Add the index comment.
     *
     * @param member the member being documented
     * @param contentTree the content tree to which the comment will be added
     */
    protected void addIndexComment( gw.gosudoc.com.sun.javadoc.Doc member, Content contentTree) {
        addIndexComment(member, member.firstSentenceTags(), contentTree);
    }

    /**
     * Add the index comment.
     *
     * @param member the member being documented
     * @param firstSentenceTags the first sentence tags for the member to be documented
     * @param tdSummary the content tree to which the comment will be added
     */
    protected void addIndexComment( gw.gosudoc.com.sun.javadoc.Doc member, gw.gosudoc.com.sun.javadoc.Tag[] firstSentenceTags,
                                    Content tdSummary) {
        gw.gosudoc.com.sun.javadoc.Tag[] deprs = member.tags("deprecated");
        Content div;
        if (utils.isDeprecated((gw.gosudoc.com.sun.javadoc.ProgramElementDoc) member)) {
            Content deprLabel = HtmlTree.SPAN(HtmlStyle.deprecatedLabel, deprecatedPhrase);
            div = HtmlTree.DIV(HtmlStyle.block, deprLabel);
            div.addContent(getSpace());
            if (deprs.length > 0) {
                addInlineDeprecatedComment(member, deprs[0], div);
            }
            tdSummary.addContent(div);
            return;
        } else {
            gw.gosudoc.com.sun.javadoc.ClassDoc cd = ((gw.gosudoc.com.sun.javadoc.ProgramElementDoc)member).containingClass();
            if (cd != null && utils.isDeprecated(cd)) {
                Content deprLabel = HtmlTree.SPAN(HtmlStyle.deprecatedLabel, deprecatedPhrase);
                div = HtmlTree.DIV(HtmlStyle.block, deprLabel);
                div.addContent(getSpace());
                tdSummary.addContent(div);
            }
        }
        addSummaryComment(member, firstSentenceTags, tdSummary);
    }

    /**
     * Add the summary type for the member.
     *
     * @param mw the writer for the member being documented
     * @param member the member to be documented
     * @param tdSummaryType the content tree to which the type will be added
     */
    public void addSummaryType(AbstractMemberWriter mw, gw.gosudoc.com.sun.javadoc.ProgramElementDoc member,
            Content tdSummaryType) {
        mw.addSummaryType(member, tdSummaryType);
    }

    /**
     * Add the summary link for the member.
     *
     * @param mw the writer for the member being documented
     * @param member the member to be documented
     * @param contentTree the content tree to which the link will be added
     */
    public void addSummaryLinkComment( AbstractMemberWriter mw,
                                       gw.gosudoc.com.sun.javadoc.ProgramElementDoc member, Content contentTree) {
        addSummaryLinkComment(mw, member, member.firstSentenceTags(), contentTree);
    }

    /**
     * Add the summary link comment.
     *
     * @param mw the writer for the member being documented
     * @param member the member being documented
     * @param firstSentenceTags the first sentence tags for the member to be documented
     * @param tdSummary the content tree to which the comment will be added
     */
    public void addSummaryLinkComment( AbstractMemberWriter mw,
                                       gw.gosudoc.com.sun.javadoc.ProgramElementDoc member, Tag[] firstSentenceTags, Content tdSummary) {
        addIndexComment(member, firstSentenceTags, tdSummary);
    }

    /**
     * Add the inherited member summary.
     *
     * @param mw the writer for the member being documented
     * @param cd the class being documented
     * @param member the member being documented
     * @param isFirst true if its the first link being documented
     * @param linksTree the content tree to which the summary will be added
     */
    public void addInheritedMemberSummary( AbstractMemberWriter mw, gw.gosudoc.com.sun.javadoc.ClassDoc cd,
                                           gw.gosudoc.com.sun.javadoc.ProgramElementDoc member, boolean isFirst, Content linksTree) {
        if (! isFirst) {
            linksTree.addContent(", ");
        }
        mw.addInheritedSummaryLink(cd, member, linksTree);
    }

    /**
     * Get the document content header tree
     *
     * @return a content tree the document content header
     */
    public Content getContentHeader() {
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.contentContainer);
        return div;
    }

    /**
     * Add the class content tree.
     *
     * @param contentTree content tree to which the class content will be added
     * @param classContentTree class content tree which will be added to the content tree
     */
    public void addClassContentTree(Content contentTree, Content classContentTree) {
        if (configuration.allowTag(HtmlTag.MAIN)) {
            mainTree.addContent(classContentTree);
            contentTree.addContent(mainTree);
        } else {
            contentTree.addContent(classContentTree);
        }
    }

    /**
     * Add the annotation content tree.
     *
     * @param contentTree content tree to which the annotation content will be added
     * @param annotationContentTree annotation content tree which will be added to the content tree
     */
    public void addAnnotationContentTree(Content contentTree, Content annotationContentTree) {
        addClassContentTree(contentTree, annotationContentTree);
    }

    /**
     * Get the member header tree
     *
     * @return a content tree the member header
     */
    public Content getMemberTreeHeader() {
        HtmlTree li = new HtmlTree(HtmlTag.LI);
        li.addStyle(HtmlStyle.blockList);
        return li;
    }

    /**
     * Add the member tree.
     *
     * @param memberSummaryTree the content tree representing the member summary
     * @param memberTree the content tree representing the member
     */
    public void addMemberTree(Content memberSummaryTree, Content memberTree) {
        if (configuration.allowTag(HtmlTag.SECTION)) {
            HtmlTree htmlTree = HtmlTree.SECTION(getMemberTree(memberTree));
            memberSummaryTree.addContent(htmlTree);
        } else {
            memberSummaryTree.addContent(getMemberTree(memberTree));
        }
    }

    /**
     * Get the member tree
     *
     * @param contentTree the tree used to generate the complete member tree
     * @return a content tree for the member
     */
    public Content getMemberTree(Content contentTree) {
        Content ul = HtmlTree.UL(HtmlStyle.blockList, contentTree);
        return ul;
    }

    /**
     * Get the member summary tree
     *
     * @param contentTree the tree used to generate the member summary tree
     * @return a content tree for the member summary
     */
    public Content getMemberSummaryTree(Content contentTree) {
        return getMemberTree(HtmlStyle.summary, contentTree);
    }

    /**
     * Get the member details tree
     *
     * @param contentTree the tree used to generate the member details tree
     * @return a content tree for the member details
     */
    public Content getMemberDetailsTree(Content contentTree) {
        return getMemberTree(HtmlStyle.details, contentTree);
    }

    /**
     * Get the member tree
     *
     * @param style the style class to be added to the content tree
     * @param contentTree the tree used to generate the complete member tree
     */
    public Content getMemberTree(HtmlStyle style, Content contentTree) {
        Content div = HtmlTree.DIV(style, getMemberTree(contentTree));
        return div;
    }
}
