/*
 * Decompiled with CFR 0.152.
 */
package gw.gosudoc.com.sun.tools.doclets.formats.html;

import gw.gosudoc.com.sun.javadoc.ClassDoc;
import gw.gosudoc.com.sun.javadoc.PackageDoc;
import gw.gosudoc.com.sun.tools.doclets.formats.html.ConfigurationImpl;
import gw.gosudoc.com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import gw.gosudoc.com.sun.tools.doclets.formats.html.LinkInfoImpl;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.HtmlTag;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.HtmlTree;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.StringContent;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.Content;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocPath;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@Deprecated
public class PackageFrameWriter
extends HtmlDocletWriter {
    private PackageDoc packageDoc;
    private Set<ClassDoc> documentedClasses;

    public PackageFrameWriter(ConfigurationImpl configuration, PackageDoc packageDoc) throws IOException {
        super(configuration, DocPath.forPackage(packageDoc).resolve(DocPaths.PACKAGE_FRAME));
        this.packageDoc = packageDoc;
        if (configuration.root.specifiedPackages().length == 0) {
            this.documentedClasses = new HashSet<ClassDoc>(Arrays.asList(configuration.root.classes()));
        }
    }

    public static void generate(ConfigurationImpl configuration, PackageDoc packageDoc) {
        try {
            PackageFrameWriter packgen = new PackageFrameWriter(configuration, packageDoc);
            String pkgName = configuration.utils.getPackageName(packageDoc);
            HtmlTree body = packgen.getBody(false, packgen.getWindowTitle(pkgName));
            StringContent pkgNameContent = new StringContent(pkgName);
            HtmlTree htmlTree = configuration.allowTag(HtmlTag.MAIN) ? HtmlTree.MAIN() : body;
            HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, HtmlStyle.bar, packgen.getTargetPackageLink(packageDoc, "classFrame", pkgNameContent));
            htmlTree.addContent(heading);
            HtmlTree div = new HtmlTree(HtmlTag.DIV);
            div.addStyle(HtmlStyle.indexContainer);
            packgen.addClassListing(div);
            htmlTree.addContent(div);
            if (configuration.allowTag(HtmlTag.MAIN)) {
                body.addContent(htmlTree);
            }
            packgen.printHtmlDocument(configuration.metakeywords.getMetaKeywords(packageDoc), false, body);
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), DocPaths.PACKAGE_FRAME.getPath());
            throw new DocletAbortException(exc);
        }
    }

    protected void addClassListing(HtmlTree contentTree) {
        ConfigurationImpl config = this.configuration;
        if (this.packageDoc.isIncluded()) {
            this.addClassKindListing(this.packageDoc.interfaces(), this.getResource("doclet.Interfaces"), contentTree);
            this.addClassKindListing(this.packageDoc.ordinaryClasses(), this.getResource("doclet.Classes"), contentTree);
            this.addClassKindListing(this.packageDoc.enums(), this.getResource("doclet.Enums"), contentTree);
            this.addClassKindListing(this.packageDoc.exceptions(), this.getResource("doclet.Exceptions"), contentTree);
            this.addClassKindListing(this.packageDoc.errors(), this.getResource("doclet.Errors"), contentTree);
            this.addClassKindListing(this.packageDoc.annotationTypes(), this.getResource("doclet.AnnotationTypes"), contentTree);
        } else {
            String name = this.utils.getPackageName(this.packageDoc);
            this.addClassKindListing(config.classDocCatalog.interfaces(name), this.getResource("doclet.Interfaces"), contentTree);
            this.addClassKindListing(config.classDocCatalog.ordinaryClasses(name), this.getResource("doclet.Classes"), contentTree);
            this.addClassKindListing(config.classDocCatalog.enums(name), this.getResource("doclet.Enums"), contentTree);
            this.addClassKindListing(config.classDocCatalog.exceptions(name), this.getResource("doclet.Exceptions"), contentTree);
            this.addClassKindListing(config.classDocCatalog.errors(name), this.getResource("doclet.Errors"), contentTree);
            this.addClassKindListing(config.classDocCatalog.annotationTypes(name), this.getResource("doclet.AnnotationTypes"), contentTree);
        }
    }

    protected void addClassKindListing(ClassDoc[] arr, Content labelContent, HtmlTree contentTree) {
        if ((arr = this.utils.filterOutPrivateClasses(arr, this.configuration.javafx)).length > 0) {
            Arrays.sort(arr);
            boolean printedHeader = false;
            HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.SECTION) ? HtmlTree.SECTION() : contentTree;
            HtmlTree ul = new HtmlTree(HtmlTag.UL);
            ul.setTitle(labelContent);
            for (ClassDoc classDoc : arr) {
                if (this.documentedClasses != null && !this.documentedClasses.contains(classDoc) || !this.utils.isCoreClass(classDoc) || !this.configuration.isGeneratedDoc(classDoc)) continue;
                if (!printedHeader) {
                    HtmlTree heading = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, true, labelContent);
                    htmlTree.addContent(heading);
                    printedHeader = true;
                }
                Content arr_i_name = new StringContent(classDoc.name());
                if (classDoc.isInterface()) {
                    arr_i_name = HtmlTree.SPAN(HtmlStyle.interfaceName, arr_i_name);
                }
                Content link = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.PACKAGE_FRAME, classDoc).label(arr_i_name).target("classFrame"));
                HtmlTree li = HtmlTree.LI(link);
                ul.addContent(li);
            }
            htmlTree.addContent(ul);
            if (this.configuration.allowTag(HtmlTag.SECTION)) {
                contentTree.addContent(htmlTree);
            }
        }
    }
}

