/*
 * Decompiled with CFR 0.152.
 */
package gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util;

import com.sun.tools.javac.util.StringUtils;
import gw.gosudoc.com.sun.javadoc.AnnotatedType;
import gw.gosudoc.com.sun.javadoc.AnnotationDesc;
import gw.gosudoc.com.sun.javadoc.AnnotationTypeDoc;
import gw.gosudoc.com.sun.javadoc.AnnotationValue;
import gw.gosudoc.com.sun.javadoc.ClassDoc;
import gw.gosudoc.com.sun.javadoc.Doc;
import gw.gosudoc.com.sun.javadoc.ExecutableMemberDoc;
import gw.gosudoc.com.sun.javadoc.FieldDoc;
import gw.gosudoc.com.sun.javadoc.MethodDoc;
import gw.gosudoc.com.sun.javadoc.PackageDoc;
import gw.gosudoc.com.sun.javadoc.Parameter;
import gw.gosudoc.com.sun.javadoc.ParameterizedType;
import gw.gosudoc.com.sun.javadoc.ProgramElementDoc;
import gw.gosudoc.com.sun.javadoc.SourcePosition;
import gw.gosudoc.com.sun.javadoc.Tag;
import gw.gosudoc.com.sun.javadoc.Type;
import gw.gosudoc.com.sun.javadoc.TypeVariable;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.Configuration;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocFile;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocPath;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocletConstants;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.text.Collator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.tools.JavaFileManager;

@Deprecated
public class Utils {
    public ProgramElementDoc[] excludeDeprecatedMembers(ProgramElementDoc[] members) {
        return this.toProgramElementDocArray(this.excludeDeprecatedMembersAsList(members));
    }

    public List<ProgramElementDoc> excludeDeprecatedMembersAsList(ProgramElementDoc[] members) {
        ArrayList<ProgramElementDoc> list = new ArrayList<ProgramElementDoc>();
        for (ProgramElementDoc member : members) {
            if (member.tags("deprecated").length != 0) continue;
            list.add(member);
        }
        Collections.sort(list);
        return list;
    }

    public ProgramElementDoc[] toProgramElementDocArray(List<ProgramElementDoc> list) {
        ProgramElementDoc[] pgmarr = new ProgramElementDoc[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            pgmarr[i] = list.get(i);
        }
        return pgmarr;
    }

    public boolean nonPublicMemberFound(ProgramElementDoc[] members) {
        for (ProgramElementDoc member : members) {
            if (member.isPublic()) continue;
            return true;
        }
        return false;
    }

    public MethodDoc findMethod(ClassDoc cd, MethodDoc method) {
        MethodDoc[] methods;
        for (MethodDoc m : methods = cd.methods()) {
            if (!this.executableMembersEqual(method, m)) continue;
            return m;
        }
        return null;
    }

    public boolean executableMembersEqual(ExecutableMemberDoc member1, ExecutableMemberDoc member2) {
        if (!(member1 instanceof MethodDoc) || !(member2 instanceof MethodDoc)) {
            return false;
        }
        MethodDoc method1 = (MethodDoc)member1;
        MethodDoc method2 = (MethodDoc)member2;
        if (method1.isStatic() && method2.isStatic()) {
            Parameter[] currentParams;
            Parameter[] targetParams = method1.parameters();
            if (method1.name().equals(method2.name()) && (currentParams = method2.parameters()).length == targetParams.length) {
                int j;
                for (j = 0; j < targetParams.length && (targetParams[j].typeName().equals(currentParams[j].typeName()) || currentParams[j].type() instanceof TypeVariable || targetParams[j].type() instanceof TypeVariable); ++j) {
                }
                if (j == targetParams.length) {
                    return true;
                }
            }
            return false;
        }
        return method1.overrides(method2) || method2.overrides(method1) || member1 == member2;
    }

    public boolean isCoreClass(ClassDoc cd) {
        return cd.containingClass() == null || cd.isStatic();
    }

    public boolean matches(ProgramElementDoc doc1, ProgramElementDoc doc2) {
        if (doc1 instanceof ExecutableMemberDoc && doc2 instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc ed1 = (ExecutableMemberDoc)doc1;
            ExecutableMemberDoc ed2 = (ExecutableMemberDoc)doc2;
            return this.executableMembersEqual(ed1, ed2);
        }
        return doc1.name().equals(doc2.name());
    }

    public void copyDocFiles(Configuration configuration, PackageDoc pd) {
        JavaFileManager.Location locn = configuration.getLocationForPackage(pd);
        this.copyDocFiles(configuration, locn, DocPath.forPackage(pd).resolve(DocPaths.DOC_FILES));
    }

    public void copyDocFiles(Configuration configuration, JavaFileManager.Location locn, DocPath dir) {
        try {
            boolean first = true;
            for (DocFile f : DocFile.list(configuration, locn, dir)) {
                DocFile destdir;
                DocFile srcdir;
                if (!f.isDirectory() || (srcdir = f).isSameFile(destdir = DocFile.createFileForOutput(configuration, dir))) continue;
                for (DocFile srcfile : srcdir.list()) {
                    DocFile destfile = destdir.resolve(srcfile.getName());
                    if (srcfile.isFile()) {
                        if (destfile.exists() && !first) {
                            configuration.message.warning((SourcePosition)null, "doclet.Copy_Overwrite_warning", srcfile.getPath(), destdir.getPath());
                            continue;
                        }
                        configuration.message.notice("doclet.Copying_File_0_To_Dir_1", srcfile.getPath(), destdir.getPath());
                        destfile.copyFile(srcfile);
                        continue;
                    }
                    if (!srcfile.isDirectory() || !configuration.copydocfilesubdirs || configuration.shouldExcludeDocFileDir(srcfile.getName())) continue;
                    this.copyDocFiles(configuration, locn, dir.resolve(srcfile.getName()));
                }
                first = false;
            }
        }
        catch (IOException | SecurityException exc) {
            throw new DocletAbortException(exc);
        }
    }

    public Comparator<Type> makeTypeComparator() {
        return new TypeComparator();
    }

    public List<Type> getAllInterfaces(Type type, Configuration configuration, boolean sort) {
        AbstractMap results = sort ? new TreeMap() : new LinkedHashMap();
        Type[] interfaceTypes = null;
        Type superType = null;
        if (type instanceof ParameterizedType) {
            interfaceTypes = ((ParameterizedType)type).interfaceTypes();
            superType = ((ParameterizedType)type).superclassType();
        } else if (type instanceof ClassDoc) {
            interfaceTypes = ((ClassDoc)type).interfaceTypes();
            superType = ((ClassDoc)type).superclassType();
        } else {
            interfaceTypes = type.asClassDoc().interfaceTypes();
            superType = type.asClassDoc().superclassType();
        }
        for (Type interfaceType : interfaceTypes) {
            ClassDoc interfaceClassDoc = interfaceType.asClassDoc();
            if (!interfaceClassDoc.isPublic() && configuration != null && !this.isLinkable(interfaceClassDoc, configuration)) continue;
            results.put(interfaceClassDoc, interfaceType);
            for (Type t : this.getAllInterfaces(interfaceType, configuration, sort)) {
                results.put(t.asClassDoc(), t);
            }
        }
        if (superType == null) {
            return new ArrayList<Type>(results.values());
        }
        this.addAllInterfaceTypes(results, superType, this.interfaceTypesOf(superType), false, configuration);
        ArrayList<Type> resultsList = new ArrayList<Type>(results.values());
        if (sort) {
            Collections.sort(resultsList, new TypeComparator());
        }
        return resultsList;
    }

    private Type[] interfaceTypesOf(Type type) {
        if (type instanceof AnnotatedType) {
            type = ((AnnotatedType)type).underlyingType();
        }
        return type instanceof ClassDoc ? ((ClassDoc)type).interfaceTypes() : ((ParameterizedType)type).interfaceTypes();
    }

    public List<Type> getAllInterfaces(Type type, Configuration configuration) {
        return this.getAllInterfaces(type, configuration, true);
    }

    private void findAllInterfaceTypes(Map<ClassDoc, Type> results, ClassDoc c, boolean raw, Configuration configuration) {
        Type superType = c.superclassType();
        if (superType == null) {
            return;
        }
        this.addAllInterfaceTypes(results, superType, this.interfaceTypesOf(superType), raw, configuration);
    }

    private void findAllInterfaceTypes(Map<ClassDoc, Type> results, ParameterizedType p, Configuration configuration) {
        Type superType = p.superclassType();
        if (superType == null) {
            return;
        }
        this.addAllInterfaceTypes(results, superType, this.interfaceTypesOf(superType), false, configuration);
    }

    private void addAllInterfaceTypes(Map<ClassDoc, Type> results, Type type, Type[] interfaceTypes, boolean raw, Configuration configuration) {
        for (Type interfaceType : interfaceTypes) {
            ClassDoc interfaceClassDoc = interfaceType.asClassDoc();
            if (!interfaceClassDoc.isPublic() && (configuration == null || !this.isLinkable(interfaceClassDoc, configuration))) continue;
            if (raw) {
                interfaceType = interfaceType.asClassDoc();
            }
            results.put(interfaceClassDoc, interfaceType);
            List<Type> superInterfaces = this.getAllInterfaces(interfaceType, configuration);
            for (Type superInterface : superInterfaces) {
                results.put(superInterface.asClassDoc(), superInterface);
            }
        }
        if (type instanceof AnnotatedType) {
            type = ((AnnotatedType)type).underlyingType();
        }
        if (type instanceof ParameterizedType) {
            this.findAllInterfaceTypes(results, (ParameterizedType)type, configuration);
        } else if (((ClassDoc)type).typeParameters().length == 0) {
            this.findAllInterfaceTypes(results, (ClassDoc)type, raw, configuration);
        } else {
            this.findAllInterfaceTypes(results, (ClassDoc)type, true, configuration);
        }
    }

    public String quote(String filepath) {
        return "\"" + filepath + "\"";
    }

    public String getPackageName(PackageDoc packageDoc) {
        return packageDoc == null || packageDoc.name().length() == 0 ? "<Unnamed>" : packageDoc.name();
    }

    public String getPackageFileHeadName(PackageDoc packageDoc) {
        return packageDoc == null || packageDoc.name().length() == 0 ? "default" : packageDoc.name();
    }

    public String replaceText(String originalStr, String oldStr, String newStr) {
        if (oldStr == null || newStr == null || oldStr.equals(newStr)) {
            return originalStr;
        }
        return originalStr.replace(oldStr, newStr);
    }

    public boolean isDocumentedAnnotation(AnnotationTypeDoc annotationDoc) {
        for (AnnotationDesc anno : annotationDoc.annotations()) {
            if (!anno.annotationType().qualifiedName().equals(Documented.class.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isDeclarationTarget(AnnotationDesc targetAnno) {
        AnnotationDesc.ElementValuePair[] elems = targetAnno.elementValues();
        if (elems == null || elems.length != 1 || !"value".equals(elems[0].element().name()) || !(elems[0].value().value() instanceof AnnotationValue[])) {
            return true;
        }
        for (AnnotationValue aValue : (AnnotationValue[])elems[0].value().value()) {
            Object value = aValue.value();
            if (!(value instanceof FieldDoc)) {
                return true;
            }
            FieldDoc eValue = (FieldDoc)value;
            if (!this.isJava5DeclarationElementType(eValue)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeclarationAnnotation(AnnotationTypeDoc annotationDoc, boolean isJava5DeclarationLocation) {
        if (!isJava5DeclarationLocation) {
            return false;
        }
        AnnotationDesc[] annotationDescList = annotationDoc.annotations();
        if (annotationDescList.length == 0) {
            return true;
        }
        for (AnnotationDesc anno : annotationDescList) {
            if (!anno.annotationType().qualifiedName().equals(Target.class.getName()) || !this.isDeclarationTarget(anno)) continue;
            return true;
        }
        return false;
    }

    public boolean isLinkable(ClassDoc classDoc, Configuration configuration) {
        return classDoc.isIncluded() && configuration.isGeneratedDoc(classDoc) || configuration.extern.isExternal(classDoc) && (classDoc.isPublic() || classDoc.isProtected());
    }

    public Type getFirstVisibleSuperClass(ClassDoc classDoc, Configuration configuration) {
        if (classDoc == null) {
            return null;
        }
        Type sup = classDoc.superclassType();
        ClassDoc supClassDoc = classDoc.superclass();
        while (!(sup == null || supClassDoc.isPublic() || this.isLinkable(supClassDoc, configuration) || supClassDoc.superclass().qualifiedName().equals(supClassDoc.qualifiedName()))) {
            sup = supClassDoc.superclassType();
            supClassDoc = supClassDoc.superclass();
        }
        if (classDoc.equals(supClassDoc)) {
            return null;
        }
        return sup;
    }

    public ClassDoc getFirstVisibleSuperClassCD(ClassDoc classDoc, Configuration configuration) {
        ClassDoc supClassDoc;
        if (classDoc == null) {
            return null;
        }
        for (supClassDoc = classDoc.superclass(); supClassDoc != null && !supClassDoc.isPublic() && !this.isLinkable(supClassDoc, configuration); supClassDoc = supClassDoc.superclass()) {
        }
        if (classDoc.equals(supClassDoc)) {
            return null;
        }
        return supClassDoc;
    }

    public String getTypeName(Configuration config, ClassDoc cd, boolean lowerCaseOnly) {
        String typeName = "";
        if (cd.isOrdinaryClass()) {
            typeName = "doclet.Class";
        } else if (cd.isInterface()) {
            typeName = "doclet.Interface";
        } else if (cd.isException()) {
            typeName = "doclet.Exception";
        } else if (cd.isError()) {
            typeName = "doclet.Error";
        } else if (cd.isAnnotationType()) {
            typeName = "doclet.AnnotationType";
        } else if (cd.isEnum()) {
            typeName = "doclet.Enum";
        }
        return config.getText(lowerCaseOnly ? StringUtils.toLowerCase(typeName) : typeName);
    }

    public String replaceTabs(Configuration configuration, String text) {
        if (!text.contains("\t")) {
            return text;
        }
        int tabLength = configuration.sourcetab;
        String whitespace = configuration.tabSpaces;
        int textLength = text.length();
        StringBuilder result = new StringBuilder(textLength);
        int pos = 0;
        int lineLength = 0;
        block4: for (int i = 0; i < textLength; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': {
                    lineLength = 0;
                    continue block4;
                }
                case '\t': {
                    result.append(text, pos, i);
                    int spaceCount = tabLength - lineLength % tabLength;
                    result.append(whitespace, 0, spaceCount);
                    lineLength += spaceCount;
                    pos = i + 1;
                    continue block4;
                }
                default: {
                    ++lineLength;
                }
            }
        }
        result.append(text, pos, textLength);
        return result.toString();
    }

    public String normalizeNewlines(String text) {
        StringBuilder sb = new StringBuilder();
        int textLength = text.length();
        String NL = DocletConstants.NL;
        int pos = 0;
        block4: for (int i = 0; i < textLength; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\n': {
                    sb.append(text, pos, i);
                    sb.append(NL);
                    pos = i + 1;
                    continue block4;
                }
                case '\r': {
                    sb.append(text, pos, i);
                    sb.append(NL);
                    if (i + 1 < textLength && text.charAt(i + 1) == '\n') {
                        ++i;
                    }
                    pos = i + 1;
                }
            }
        }
        sb.append(text, pos, textLength);
        return sb.toString();
    }

    public void setEnumDocumentation(Configuration configuration, ClassDoc classDoc) {
        for (MethodDoc currentMethod : classDoc.methods()) {
            Type paramType;
            if (currentMethod.name().equals("values") && currentMethod.parameters().length == 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(configuration.getText("doclet.enum_values_doc.main", classDoc.name()));
                sb.append("\n@return ");
                sb.append(configuration.getText("doclet.enum_values_doc.return"));
                currentMethod.setRawCommentText(sb.toString());
                continue;
            }
            if (!currentMethod.name().equals("valueOf") || currentMethod.parameters().length != 1 || (paramType = currentMethod.parameters()[0].type()) == null || !paramType.qualifiedTypeName().equals(String.class.getName())) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(configuration.getText("doclet.enum_valueof_doc.main", classDoc.name()));
            sb.append("\n@param name ");
            sb.append(configuration.getText("doclet.enum_valueof_doc.param_name"));
            sb.append("\n@return ");
            sb.append(configuration.getText("doclet.enum_valueof_doc.return"));
            sb.append("\n@throws IllegalArgumentException ");
            sb.append(configuration.getText("doclet.enum_valueof_doc.throws_ila"));
            sb.append("\n@throws NullPointerException ");
            sb.append(configuration.getText("doclet.enum_valueof_doc.throws_npe"));
            currentMethod.setRawCommentText(sb.toString());
        }
    }

    public boolean isDeprecated(Doc doc) {
        if (doc.tags("deprecated").length > 0) {
            return true;
        }
        AnnotationDesc[] annotationDescList = doc instanceof PackageDoc ? ((PackageDoc)doc).annotations() : ((ProgramElementDoc)doc).annotations();
        for (AnnotationDesc anno : annotationDescList) {
            if (!anno.annotationType().qualifiedName().equals(Deprecated.class.getName())) continue;
            return true;
        }
        return false;
    }

    public String propertyNameFromMethodName(Configuration configuration, String name) {
        String propertyName = null;
        if (name.startsWith("get") || name.startsWith("set")) {
            propertyName = name.substring(3);
        } else if (name.startsWith("is")) {
            propertyName = name.substring(2);
        }
        if (propertyName == null || propertyName.isEmpty()) {
            return "";
        }
        return propertyName.substring(0, 1).toLowerCase(configuration.getLocale()) + propertyName.substring(1);
    }

    public ClassDoc[] filterOutPrivateClasses(ClassDoc[] classes, boolean javafx) {
        if (!javafx) {
            return classes;
        }
        ArrayList<ClassDoc> filteredOutClasses = new ArrayList<ClassDoc>(classes.length);
        for (ClassDoc classDoc : classes) {
            Tag[] aspTags;
            if (classDoc.isPrivate() || classDoc.isPackagePrivate() || (aspTags = classDoc.tags("treatAsPrivate")) != null && aspTags.length > 0) continue;
            filteredOutClasses.add(classDoc);
        }
        return filteredOutClasses.toArray(new ClassDoc[0]);
    }

    public boolean isJava5DeclarationElementType(FieldDoc elt) {
        return elt.name().contentEquals(ElementType.ANNOTATION_TYPE.name()) || elt.name().contentEquals(ElementType.CONSTRUCTOR.name()) || elt.name().contentEquals(ElementType.FIELD.name()) || elt.name().contentEquals(ElementType.LOCAL_VARIABLE.name()) || elt.name().contentEquals(ElementType.METHOD.name()) || elt.name().contentEquals(ElementType.PACKAGE.name()) || elt.name().contentEquals(ElementType.PARAMETER.name()) || elt.name().contentEquals(ElementType.TYPE.name());
    }

    public static int compareStrings(String s1, String s2) {
        return Utils.compareStrings(true, s1, s2);
    }

    public static int compareCaseCompare(String s1, String s2) {
        return Utils.compareStrings(false, s1, s2);
    }

    private static int compareStrings(boolean caseSensitive, String s1, String s2) {
        Collator collator = Collator.getInstance();
        collator.setStrength(caseSensitive ? 2 : 1);
        return collator.compare(s1, s2);
    }

    public Comparator<Doc> makeGeneralPurposeComparator() {
        return this.makeComparatorForClassUse();
    }

    public Comparator<Doc> makeComparatorForIndexUse() {
        return new DocComparator<Doc>(){

            @Override
            public int compare(Doc d1, Doc d2) {
                int result = this.compareNames(d1, d2);
                if (result != 0) {
                    return result;
                }
                result = this.compareDocKinds(d1, d2);
                if (result != 0) {
                    return result;
                }
                if (this.hasParameters(d1)) {
                    Parameter[] param2;
                    Parameter[] param1 = ((ExecutableMemberDoc)d1).parameters();
                    result = this.compareParameters(false, param1, param2 = ((ExecutableMemberDoc)d2).parameters());
                    if (result != 0) {
                        return result;
                    }
                    result = this.compareParameters(true, param1, param2);
                    if (result != 0) {
                        return result;
                    }
                }
                return this.compareFullyQualifiedNames(d1, d2);
            }
        };
    }

    public Comparator<Doc> makeComparatorForClassUse() {
        return new DocComparator<Doc>(){

            @Override
            public int compare(Doc d1, Doc d2) {
                int result = this.compareNames(d1, d2);
                if (result != 0) {
                    return result;
                }
                result = this.compareFullyQualifiedNames(d1, d2);
                if (result != 0) {
                    return result;
                }
                if (this.hasParameters(d1) && this.hasParameters(d2)) {
                    Parameter[] param2;
                    Parameter[] param1 = ((ExecutableMemberDoc)d1).parameters();
                    result = this.compareParameters(false, param1, param2 = ((ExecutableMemberDoc)d2).parameters());
                    if (result != 0) {
                        return result;
                    }
                    return this.compareParameters(true, param1, param2);
                }
                return this.compareDocKinds(d1, d2);
            }
        };
    }

    static abstract class DocComparator<T extends Doc>
    implements Comparator<Doc> {
        DocComparator() {
        }

        boolean hasParameters(Doc d) {
            return d instanceof ExecutableMemberDoc;
        }

        DocKind getDocKind(Doc d) {
            if (d.isAnnotationType() || d.isAnnotationTypeElement()) {
                return DocKind.ANNOTATION;
            }
            if (d.isEnum() || d.isEnumConstant()) {
                return DocKind.ENUM;
            }
            if (d.isField()) {
                return DocKind.FIELD;
            }
            if (d.isInterface()) {
                return DocKind.INTERFACE;
            }
            if (d.isClass()) {
                return DocKind.CLASS;
            }
            if (d.isConstructor()) {
                return DocKind.CONSTRUCTOR;
            }
            if (d.isMethod()) {
                return DocKind.METHOD;
            }
            return DocKind.PACKAGE;
        }

        protected int compareDocKinds(Doc d1, Doc d2) {
            return this.getDocKind(d1).compareTo(this.getDocKind(d2));
        }

        protected int compareParameters(boolean caseSensitive, Parameter[] params1, Parameter[] params2) {
            String s1 = this.getParametersAsString(params1);
            String s2 = this.getParametersAsString(params2);
            return Utils.compareStrings(caseSensitive, s1, s2);
        }

        protected String getParametersAsString(Parameter[] params) {
            StringBuilder sb = new StringBuilder();
            for (Parameter param : params) {
                Type t = param.type();
                String tname = t.asParameterizedType() != null && t.getElementType() != null ? String.valueOf(t.getElementType()) + t.dimension() : t.toString();
                sb.append(t.isPrimitive() ? "P" : "R").append("-").append(tname).append("-");
            }
            return sb.toString();
        }

        protected int compareNames(Doc d1, Doc d2) {
            return Utils.compareStrings(d1.name(), d2.name());
        }

        protected int compareFullyQualifiedNames(Doc d1, Doc d2) {
            String name1 = d1 instanceof ProgramElementDoc ? ((ProgramElementDoc)d1).qualifiedName() : d1.name();
            String name2 = d2 instanceof ProgramElementDoc ? ((ProgramElementDoc)d2).qualifiedName() : d2.name();
            return Utils.compareStrings(name1, name2);
        }

        static enum DocKind {
            PACKAGE,
            CLASS,
            ENUM,
            INTERFACE,
            ANNOTATION,
            FIELD,
            CONSTRUCTOR,
            METHOD;

        }
    }

    private static class TypeComparator
    implements Comparator<Type> {
        private TypeComparator() {
        }

        @Override
        public int compare(Type type1, Type type2) {
            return Utils.compareStrings(type1.qualifiedTypeName(), type2.qualifiedTypeName());
        }
    }
}

