/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.BeanInfoPopup;
import editor.GosuEditor;
import editor.GosuEditorPane;
import editor.IParseExceptionResolver;
import editor.IValueCompletionHandler;
import editor.IValuePopup;
import editor.util.EditorUtilities;
import gw.lang.parser.IExpression;
import gw.lang.parser.IFunctionSymbol;
import gw.lang.parser.IHasArguments;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.expressions.IBeanMethodCallExpression;
import gw.lang.parser.expressions.ILiteralExpression;
import gw.lang.parser.expressions.IMemberAccessExpression;
import gw.lang.parser.expressions.IMethodCallExpression;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IType;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public abstract class AbstractParseExceptionResolver
implements IParseExceptionResolver,
IValueCompletionHandler {
    private GosuEditor _gsEditor;

    @Override
    public GosuEditor getGosuEditor() {
        return this._gsEditor;
    }

    @Override
    public void setGosuEditor(GosuEditor gsEditor) {
        this._gsEditor = gsEditor;
    }

    protected JTextComponent getEditor() {
        return this.getGosuEditor().getEditor();
    }

    @Override
    public boolean canResolve(ParseException pe) {
        if (pe == null) {
            return false;
        }
        IType typeExpected = this.getExpectedType(pe);
        if (typeExpected == null) {
            return false;
        }
        BeanInfoPopup beanInfoPopup = this.getGosuEditor().getBeanInfoPopup();
        if (beanInfoPopup != null) {
            if (beanInfoPopup.isVisible()) {
                return false;
            }
            this.getGosuEditor().setBeanInfoPopup(null);
        }
        int iPos = this.getGosuEditor().getCaretPositionForValueCompletion((IParseIssue)pe);
        GosuEditorPane editor = this.getGosuEditor().getEditor();
        int iCurrentPos = editor.getCaretPosition();
        try {
            Rectangle rcAdvice = editor.modelToView(iPos);
            Rectangle rcCurAdvice = editor.modelToView(iCurrentPos);
            if (rcAdvice == null || rcCurAdvice == null || rcAdvice.y != rcCurAdvice.y) {
                return false;
            }
        }
        catch (Exception e) {
            EditorUtilities.handleUncaughtException("ElementModel change listener error.", e);
        }
        return true;
    }

    public IType getExpectedType(ParseException pe) {
        IType typeExpected = pe.getExpectedType();
        if (typeExpected == null) {
            typeExpected = AbstractParseExceptionResolver.resolvePossibleContextTypesFromEmptyMethodCalls(this.getGosuEditor().getExpressionAtCaret(), this.getEditor());
        }
        return typeExpected;
    }

    protected IType getBaseType(ParseException pe) {
        IMemberAccessExpression ma = pe.getMemberAccessContext();
        IType baseType = null;
        if (ma != null) {
            baseType = ma.getRootType();
        }
        return baseType;
    }

    protected IParseTree getDeepestLocationToComplete() {
        IParseTree deepest = this.getGosuEditor().getDeepestLocationAtCaret();
        if (deepest == null) {
            return null;
        }
        return deepest;
    }

    protected IType getTypeExpected() {
        IParseTree deepest = this.getDeepestLocationToComplete();
        if (deepest == null || !(deepest.getParsedElement() instanceof IExpression)) {
            return null;
        }
        IExpression expression = (IExpression)deepest.getParsedElement();
        IType typeExpected = expression.getContextType();
        if (typeExpected == null) {
            if (expression instanceof ILiteralExpression) {
                return expression.getType();
            }
            return AbstractParseExceptionResolver.resolvePossibleContextTypesFromEmptyMethodCalls(expression, this.getEditor());
        }
        return typeExpected;
    }

    public static IType resolvePossibleContextTypesFromEmptyMethodCalls(IExpression expression, JTextComponent editor) {
        IFunctionType funType;
        IBeanMethodCallExpression bmce;
        FunctionType funType2;
        IFunctionSymbol symbol;
        IMethodCallExpression mce;
        IType[] paramTypes = null;
        if (expression instanceof IMethodCallExpression && ((mce = (IMethodCallExpression)expression).getArgs() == null || mce.getArgs().length == 0) && AbstractParseExceptionResolver.isEditorAtPossibleArgPosition((IParsedElement)mce, editor) && (symbol = mce.getFunctionSymbol()) != null && (funType2 = (FunctionType)symbol.getType()) != null && funType2.getParameterTypes() != null && funType2.getParameterTypes().length > 0) {
            paramTypes = funType2.getParameterTypes();
        }
        if (expression instanceof IBeanMethodCallExpression && ((bmce = (IBeanMethodCallExpression)expression).getArgs() == null || bmce.getArgs().length == 0) && AbstractParseExceptionResolver.isEditorAtPossibleArgPosition((IParsedElement)bmce, editor) && (funType = bmce.getFunctionType()) != null && funType.getParameterTypes() != null && funType.getParameterTypes().length > 0) {
            paramTypes = funType.getParameterTypes();
        }
        return paramTypes != null && paramTypes.length > 0 ? paramTypes[0] : null;
    }

    public static boolean isEditorAtPossibleArgPosition(IParsedElement e, JTextComponent editor) {
        int position;
        Point argPosition;
        boolean returnVal = false;
        if (e instanceof IHasArguments && (argPosition = AbstractParseExceptionResolver.findMethodArgPoint(e, editor)) != null && (position = editor.getCaretPosition()) > argPosition.x && position <= argPosition.y) {
            returnVal = true;
        }
        return returnVal;
    }

    private static Point findMethodArgPoint(IParsedElement mce, JTextComponent editor) {
        int end = mce.getLocation().getExtent();
        try {
            int start;
            for (start = mce.getLocation().getOffset(); !"(".equals(editor.getText(start, 1)) && start < end; ++start) {
            }
            while (!")".equals(editor.getText(end, 1)) && end > start) {
                --end;
            }
            return new Point(start, end);
        }
        catch (Exception exception) {
            return null;
        }
    }

    void insertTextAtCaret(String str) {
        GosuEditorPane editor = this.getGosuEditor().getEditor();
        try {
            editor.getDocument().insertString(editor.getCaretPosition(), str, null);
        }
        catch (BadLocationException e1) {
            throw new RuntimeException(e1);
        }
    }

    protected void showValueCompletionPopup(IValuePopup popup, boolean bFocusInEditor) {
        this.getGosuEditor().setValuePopup(popup);
        IParseTree currentLocation = this.getDeepestLocationToComplete();
        if (currentLocation != null && currentLocation.getParsedElement() instanceof IExpression && AbstractParseExceptionResolver.shouldPositionAtStartOfElement(currentLocation, this.getEditor())) {
            this.getEditor().setCaretPosition(currentLocation.getOffset());
            this.getEditor().moveCaretPosition(currentLocation.getOffset() + currentLocation.getLength());
        }
        this.getGosuEditor().displayValuePopup(this.getEditor().getSelectionStart(), bFocusInEditor);
    }

    public static boolean shouldPositionAtStartOfElement(IParseTree currentLocation, JTextComponent editor) {
        return currentLocation != null && !AbstractParseExceptionResolver.isEditorAtPossibleArgPosition(currentLocation.getParsedElement(), editor) && !AbstractParseExceptionResolver.isEmptyLocation(currentLocation);
    }

    private static boolean isEmptyLocation(IParseTree currentLocation) {
        return currentLocation.getLength() == 0;
    }
}

