/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GosuPanel;
import editor.RunMe;
import editor.search.StudioUtilities;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class ClasspathDialog
extends JDialog {
    private JTextPane _pathsList;
    private File _dir;

    public ClasspathDialog(File dir) {
        super((JFrame)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), "Classpath", true);
        this._dir = dir;
        this.configUI();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ClasspathDialog.this.dispose();
            }
        });
    }

    protected void configUI() {
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        contentPane.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel panel = new JPanel(new BorderLayout());
        this._pathsList = new JTextPane();
        JScrollPane scroller = new JScrollPane(this._pathsList);
        this.setPathsList();
        this._pathsList.setBorder(BorderFactory.createEmptyBorder());
        JButton btnPaths = new JButton("...");
        btnPaths.addActionListener(e -> this.updatePaths());
        panel.add((Component)btnPaths, "North");
        JPanel filler = new JPanel();
        filler.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        panel.add((Component)filler, "Center");
        mainPanel.add((Component)scroller, "Center");
        mainPanel.add((Component)panel, "East");
        contentPane.add((Component)mainPanel, "Center");
        JPanel south = new JPanel(new BorderLayout());
        south.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        filler = new JPanel();
        south.add((Component)filler, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        JButton btnFind = new JButton("OK");
        btnFind.setMnemonic('O');
        btnFind.addActionListener(e -> {
            this.saveClassPath();
            this.close();
        });
        buttonPanel.add(btnFind);
        this.getRootPane().setDefaultButton(btnFind);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(e -> this.close());
        buttonPanel.add(btnCancel);
        south.add((Component)buttonPanel, "East");
        contentPane.add((Component)south, "South");
        this.mapCancelKeystroke();
        this.setSize(600, 400);
        StudioUtilities.centerWindowInFrame(this, this.getOwner());
    }

    private void setPathsList() {
        String strPaths = "";
        List<String> paths = RunMe.getEditorFrame().getGosuPanel().getExperimentView().getExperiment().getSourcePath();
        for (int i = 0; i < paths.size(); ++i) {
            String strPath = paths.get(i);
            strPaths = strPaths + strPath + (i == paths.size() - 1 ? "" : File.pathSeparator + "\n");
        }
        this._pathsList.setText(strPaths);
    }

    private void saveClassPath() {
        String strPaths = this._pathsList.getText();
        StringTokenizer tokenizer = new StringTokenizer(strPaths, File.pathSeparator + "\n\r\t");
        ArrayList<String> paths = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String strPath = tokenizer.nextToken();
            paths.add(strPath);
        }
        ArrayList<File> pathFiles = new ArrayList<File>();
        for (String strPath : paths) {
            pathFiles.add(new File(strPath).getAbsoluteFile());
        }
        this.savePathsAndReopenExperiment(pathFiles);
    }

    private void savePathsAndReopenExperiment(List<File> pathFiles) {
        GosuPanel gosuPanel = RunMe.getEditorFrame().getGosuPanel();
        Experiment experiment = gosuPanel.getExperimentView().getExperiment();
        List<String> srcPaths = pathFiles.stream().map(File::getAbsolutePath).collect(Collectors.toList());
        experiment.setSourcePath(srcPaths);
        gosuPanel.openExperiment(experiment.getExperimentDir());
    }

    private void updatePaths() {
        JFileChooser fc = new JFileChooser(this.getCurrentDir());
        fc.setDialogTitle("Add Paths");
        fc.setDialogType(0);
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(true);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".zip") || f.getName().endsWith(".jar");
            }

            @Override
            public String getDescription() {
                return "Classpath (directories or archive files)";
            }
        });
        int returnVal = fc.showOpenDialog(EditorUtilities.frameForComponent(this));
        if (returnVal == 0) {
            String strExisting = this._pathsList.getText().trim();
            if (strExisting.endsWith(File.pathSeparator)) {
                strExisting = strExisting.substring(0, strExisting.length() - 1);
            }
            for (File f : fc.getSelectedFiles()) {
                strExisting = strExisting + File.pathSeparatorChar + "\n" + f.getAbsolutePath();
            }
            this._dir = fc.getCurrentDirectory();
            this._pathsList.setText(strExisting);
        }
    }

    private File getCurrentDir() {
        return this._dir;
    }

    private void mapCancelKeystroke() {
        Object key = this.getRootPane().getInputMap(1).get(KeyStroke.getKeyStroke(27, 0));
        if (key == null) {
            key = "Cancel";
            this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), key);
        }
        this.getRootPane().getActionMap().put(key, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClasspathDialog.this.close();
            }
        });
    }

    private void close() {
        this.dispose();
    }
}

