/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.ExtractVariablePopup;
import editor.GosuEditor;
import editor.TypePopup;
import editor.undo.AtomicUndoManager;
import editor.util.TextComponentUtil;
import gw.lang.parser.IParseTree;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.Keyword;
import gw.lang.parser.statements.IClasspathStatement;
import gw.lang.parser.statements.INamespaceStatement;
import gw.lang.parser.statements.IUsesStatement;
import gw.lang.reflect.TypeSystem;
import gw.util.GosuRefactorUtil;
import gw.util.GosuStringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.CompoundEdit;

public class CodeRefactorManager {
    private GosuEditor _gsEditor;

    public CodeRefactorManager(GosuEditor gsEditor) {
        this._gsEditor = gsEditor;
    }

    public void moveSelectionUp() {
        this.moveSelection(true);
    }

    public void moveSelectionDown() {
        this.moveSelection(false);
    }

    private void moveSelection(boolean up) {
        this._gsEditor.waitForParser();
        this.moveSelectionNow(up);
    }

    private void moveSelectionNow(boolean up) {
        IParseTree lastStatement;
        int rawEnd;
        int rawStart;
        String line;
        int start = this._gsEditor.getEditor().getSelectionStart();
        int end = this._gsEditor.getEditor().getSelectionEnd();
        String script = this._gsEditor.getEditor().getText();
        if (start != end && end > 0 && script.charAt(end - 1) == '\n') {
            --end;
        }
        if (GosuStringUtil.isWhitespace((String)(line = script.substring(rawStart = TextComponentUtil.getLineStart(script, start), rawEnd = TextComponentUtil.getLineEnd(script, end)))) || line.trim().startsWith("//")) {
            if (up) {
                if (rawStart == 0) {
                    return;
                }
                int lineStartBefore = TextComponentUtil.getLineStart(script, rawStart - 1);
                GosuRefactorUtil.MoveInstruction moveInstruction = new GosuRefactorUtil.MoveInstruction(false, false, lineStartBefore);
                this.handleMoveInstruction(script, moveInstruction, rawStart, rawEnd, up);
                return;
            }
            if (rawEnd >= script.length()) {
                return;
            }
            int lineStartBefore = rawEnd + 1;
            GosuRefactorUtil.MoveInstruction moveInstruction = new GosuRefactorUtil.MoveInstruction(false, false, lineStartBefore);
            this.handleMoveInstruction(script, moveInstruction, rawStart, rawEnd, up);
            return;
        }
        int peStart = TextComponentUtil.findNonWhitespacePositionAfter(script, rawStart);
        int peEnd = TextComponentUtil.findNonWhitespacePositionBefore(script, rawEnd);
        peStart = Math.min(peStart, script.length() - 1);
        peEnd = Math.min(peEnd, script.length() - 1);
        IParseTree firstStatement = GosuRefactorUtil.findFirstStatementAtLine((int)TextComponentUtil.getLineAtPosition(this._gsEditor.getEditor(), peStart), (int)peStart, (List)this._gsEditor.getParser().getLocations());
        IParseTree[] boundingPair = GosuRefactorUtil.findSpanningLogicalRange((IParseTree)firstStatement, (IParseTree)(lastStatement = GosuRefactorUtil.findLastStatementAtLine((int)TextComponentUtil.getLineAtPosition(this._gsEditor.getEditor(), peEnd), (int)peEnd, (List)this._gsEditor.getParser().getLocations())));
        if (boundingPair != null) {
            GosuRefactorUtil.MoveInstruction moveInstruction;
            int clipStart = Math.min(rawStart, TextComponentUtil.getLineStart(script, boundingPair[0].getOffset()));
            int clipEnd = Math.max(rawEnd, TextComponentUtil.getLineEnd(script, boundingPair[1].getExtent()));
            if (!GosuRefactorUtil.isClassElement((IParseTree)boundingPair[0])) {
                int lineStart;
                int n = lineStart = up ? TextComponentUtil.getWhiteSpaceOrCommentLineStartBefore(script, clipStart) : TextComponentUtil.getWhiteSpaceOrCommentLineStartAfter(script, clipEnd);
                if (lineStart != -1) {
                    GosuRefactorUtil.MoveInstruction moveInstruction2 = new GosuRefactorUtil.MoveInstruction(false, false, lineStart);
                    this.handleMoveInstruction(script, moveInstruction2, clipStart, clipEnd, up);
                    return;
                }
            }
            GosuRefactorUtil.MoveInstruction moveInstruction3 = moveInstruction = up ? GosuRefactorUtil.getMoveUpInstruction((IParseTree)boundingPair[0]) : GosuRefactorUtil.getMoveDownInstruction((IParseTree)boundingPair[1]);
            if (moveInstruction != null) {
                IParseTree nextSibling;
                if (GosuRefactorUtil.isClassElement((IParseTree)boundingPair[1]) && (nextSibling = boundingPair[1].getNextSibling()) != null) {
                    clipEnd = TextComponentUtil.getLineStart(script, nextSibling.getOffset()) - 1;
                    if (!up) {
                        moveInstruction.position = TextComponentUtil.getDeepestWhiteSpaceLineStartAfter(script, moveInstruction.position);
                    }
                }
                this.handleMoveInstruction(script, moveInstruction, clipStart, clipEnd, up);
            }
        }
    }

    private void handleMoveInstruction(String script, GosuRefactorUtil.MoveInstruction moveInstruction, int startClip, int endClip, boolean up) {
        String[] strings;
        String movedCodeAsString;
        if (endClip == script.length() - 1 && !up) {
            return;
        }
        if (endClip < script.length()) {
            ++endClip;
        }
        if (!(movedCodeAsString = script.substring(startClip, endClip)).endsWith("\n")) {
            movedCodeAsString = movedCodeAsString + "\n";
        }
        int offset = moveInstruction.position;
        offset = up ? TextComponentUtil.getLineStart(script, offset) : TextComponentUtil.getLineEnd(script, offset) + 1 - movedCodeAsString.length();
        StringBuilder movedCode = new StringBuilder();
        int caretPosition = this._gsEditor.getEditor().getCaretPosition();
        int selectionStart = this._gsEditor.getEditor().getSelectionStart();
        int selectionEnd = this._gsEditor.getEditor().getSelectionEnd();
        int currentPosition = startClip;
        if (moveInstruction.indent) {
            for (String str : strings = movedCodeAsString.split("\n")) {
                if (caretPosition > currentPosition) {
                    caretPosition += 2;
                }
                if (selectionStart > currentPosition) {
                    selectionStart += 2;
                }
                if (selectionEnd > currentPosition) {
                    selectionEnd += 2;
                }
                movedCode.append("  ");
                movedCode.append(str);
                movedCode.append("\n");
                currentPosition += str.length() + 1;
            }
        } else if (moveInstruction.outdent && movedCodeAsString.startsWith("  ")) {
            for (String str : strings = movedCodeAsString.split("\n")) {
                if (str.startsWith("  ")) {
                    if (caretPosition > currentPosition) {
                        caretPosition -= 2;
                    }
                    if (selectionStart > currentPosition) {
                        selectionStart -= 2;
                    }
                    if (selectionEnd > currentPosition) {
                        selectionEnd -= 2;
                    }
                    str = str.substring(2, str.length());
                }
                movedCode.append(str);
                movedCode.append("\n");
                currentPosition += str.length() + 1;
            }
        } else {
            movedCode.append(movedCodeAsString);
        }
        AtomicUndoManager.DisplayableCompoundEdit undoAtom = this._gsEditor.getUndoManager().getUndoAtom();
        if (undoAtom != null && ((CompoundEdit)undoAtom).getPresentationName().equals("Script Change")) {
            this._gsEditor.getUndoManager().endUndoAtom();
        }
        this._gsEditor.getUndoManager().beginUndoAtom("moveLine");
        try {
            this._gsEditor.getEditor().getDocument().remove(startClip, endClip - startClip);
            this._gsEditor.getEditor().getDocument().insertString(offset, movedCode.toString(), null);
            this._gsEditor.getEditor().setSelectionStart(selectionStart - (startClip - offset));
            this._gsEditor.getEditor().setSelectionEnd(selectionEnd - (startClip - offset));
            this._gsEditor.getEditor().getCaret().moveDot(caretPosition - (startClip - offset));
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        finally {
            this._gsEditor.getUndoManager().endUndoAtom();
        }
    }

    public void addToUses(String strType, boolean bTemplate, boolean bProgram) {
        int iInsertionPt;
        if (this.isTypeUsed(strType)) {
            return;
        }
        Document doc = this._gsEditor.getEditor().getDocument();
        int iPos = this.findUsesInsertionPosition(bProgram);
        int iIndex = doc.getDefaultRootElement().getElementIndex(iPos);
        String strUsesStmt = Keyword.KW_uses + " " + strType;
        if (bTemplate) {
            strUsesStmt = "<% " + strUsesStmt + " %>";
        }
        strUsesStmt = strUsesStmt + "\n";
        if (iPos == 0) {
            iInsertionPt = iPos;
            if (!bTemplate) {
                strUsesStmt = strUsesStmt + "\n";
            }
        } else {
            iInsertionPt = doc.getDefaultRootElement().getElement(iIndex).getEndOffset();
        }
        try {
            doc.insertString(iInsertionPt, strUsesStmt, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isTypeUsed(String strType) {
        String strRelativeName = TypePopup.getRelativeTypeName(strType);
        try {
            return this._gsEditor.getParser().getTypeUsesMap().resolveType(strRelativeName) != null || TypeSystem.parseType((String)strRelativeName, (ITypeUsesMap)this._gsEditor.getParser().getTypeUsesMap().copy()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int findUsesInsertionPosition(boolean bProgram) {
        Set usesStmts = this._gsEditor.getParser().getTypeUsesMap().getUsesStatements();
        int iPos = -1;
        for (IUsesStatement usesStmt : usesStmts) {
            iPos = Math.max(usesStmt.getLocation().getOffset(), iPos);
        }
        if (iPos < 0) {
            iPos = this.findPackageLocation();
            iPos = iPos < 0 ? (bProgram ? ((iPos = this.findClasspathLocation()) < 0 ? 0 : ++iPos) : 0) : ++iPos;
        } else if (iPos == 0) {
            iPos = 1;
        }
        return iPos;
    }

    private int findPackageLocation() {
        List locations = this._gsEditor.getParser().getLocations();
        ArrayList listOut = new ArrayList();
        IParseTree.Search.getContainedParsedElementsByType((List)locations, INamespaceStatement.class, listOut);
        if (listOut.size() > 0) {
            return ((INamespaceStatement)listOut.get(0)).getLocation().getOffset();
        }
        return -1;
    }

    private int findClasspathLocation() {
        List locations = this._gsEditor.getParser().getLocations();
        ArrayList listOut = new ArrayList();
        IParseTree.Search.getContainedParsedElementsByType((List)locations, IClasspathStatement.class, listOut);
        if (listOut.size() > 0) {
            return ((IClasspathStatement)listOut.get(0)).getLocation().getOffset();
        }
        return -1;
    }

    public void extractVariable() {
        ExtractVariablePopup extractVarPopup = new ExtractVariablePopup();
        extractVarPopup.showNow(this._gsEditor);
    }
}

