/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.util.EditorUtilities;
import gw.util.GosuObjectUtil;
import gw.util.GosuStringUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CopyBuffer {
    List<String> _buffer = new ArrayList<String>();
    private static final CopyBuffer INSTANCE = new CopyBuffer();
    private static final int MAX_SIZE = 10;
    private WindowListener _adapter = new WindowAdapter(){

        @Override
        public void windowActivated(WindowEvent e) {
            if (e.getOppositeWindow() == null) {
                CopyBuffer.this.captureState();
            }
        }
    };

    CopyBuffer() {
    }

    public static CopyBuffer instance() {
        return INSTANCE;
    }

    public void captureState() {
        try {
            if (!EditorUtilities.getClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        Transferable contents = EditorUtilities.getClipboard().getContents(this);
        this.addToCopyBuffer(contents);
    }

    void addToCopyBuffer(Transferable contents) {
        try {
            String element = String.valueOf(contents.getTransferData(DataFlavor.stringFlavor));
            if (!(GosuStringUtil.isEmpty((String)element) || this._buffer.size() != 0 && GosuObjectUtil.equals((Object)element, (Object)this._buffer.get(0)))) {
                this._buffer.add(0, element);
                if (this._buffer.size() > 10) {
                    this._buffer.remove(10);
                }
            }
        }
        catch (Exception e) {
            EditorUtilities.handleUncaughtException("Unable to copy from clipboard", e);
        }
    }

    public List<String> getCopyBuffer() {
        return this._buffer;
    }

    public void notifyOfPaste(int index) {
        if (index >= 0 && index < 10) {
            Collections.swap(this._buffer, 0, index);
        }
    }

    public WindowListener getWindowAdapter() {
        return this._adapter;
    }
}

