/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GosuEditor;
import editor.IValuePopup;
import editor.util.EditorUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

public abstract class EditorBasedPopup
extends JPopupMenu
implements IValuePopup {
    private GosuEditor _editor;

    public EditorBasedPopup(GosuEditor editor) {
        this._editor = editor;
    }

    protected GosuEditor getEditor() {
        return this._editor;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b && this._editor != null) {
            try {
                Rectangle bounds = this.getParent().getBounds();
                Point popupLocation = this.getParent().getLocationOnScreen();
                Rectangle caretLocation = new Rectangle(this._editor.getCaretLocation());
                EditorUtilities.convertRectangleToScreen(caretLocation, this._editor);
                if (popupLocation.getY() < caretLocation.getY() + caretLocation.getHeight()) {
                    Point loc = new Point((int)popupLocation.getX(), (int)(caretLocation.getY() - bounds.getHeight()));
                    SwingUtilities.convertPointFromScreen(loc, this.getParent().getParent());
                    this.getParent().setLocation(loc);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    protected boolean endsWithInvalidChar(String strPrefix) {
        char c;
        return strPrefix != null && strPrefix.length() > 0 && !Character.isJavaIdentifierPart(c = strPrefix.charAt(strPrefix.length() - 1)) && !Character.isJavaIdentifierStart(c);
    }
}

