/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.IIntelliTextModel;
import editor.PopupListModel;
import gw.lang.reflect.IEnumType;
import gw.lang.reflect.IEnumValue;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class EnumerationPopupListModel
extends PopupListModel {
    private List _model;
    private IEnumType _enumAccess;

    public EnumerationPopupListModel(IEnumType enumAccess) {
        this.init(enumAccess);
    }

    private EnumerationPopupListModel(EnumerationPopupListModel source) {
        this.init(source._enumAccess);
        this._model = source._model;
    }

    private void init(IEnumType classTypeKey) {
        this._enumAccess = classTypeKey;
        this._model = this.getTypeCodes();
    }

    @Override
    public String getInsertionTextFrom(Object element) {
        IEnumValue val = (IEnumValue)element;
        String str = val.getCode();
        return str;
    }

    @Override
    public String getDisplayText(Object element) {
        return ((IEnumValue)element).getCode();
    }

    @Override
    public PopupListModel createSubset(List subset) {
        EnumerationPopupListModel copy = new EnumerationPopupListModel(this);
        copy._model = subset;
        return copy;
    }

    @Override
    public List getModel() {
        return this._model;
    }

    @Override
    public List getUnfilteredModel() {
        return this.getTypeCodes();
    }

    @Override
    public String getTypeName() {
        return this._enumAccess.getDisplayName();
    }

    @Override
    public Object parseElement(String strValue) {
        return this._enumAccess.getEnumValue(strValue);
    }

    @Override
    public IIntelliTextModel getFilteredModel(String strPrefix) {
        PopupListModel filteredModel = (PopupListModel)super.getFilteredModel(strPrefix);
        Collections.sort(filteredModel.getModelUpdatedOrFilteredByPredicate(), new EnumeratorComparator());
        return filteredModel;
    }

    private List getTypeCodes() {
        List typecodes = this._enumAccess.getEnumValues();
        Collections.sort(typecodes, new EnumeratorComparator());
        return typecodes;
    }

    private static class EnumeratorComparator
    implements Comparator {
        private EnumeratorComparator() {
        }

        public int compare(Object o1, Object o2) {
            String code1 = ((IEnumValue)o1).getCode();
            String code2 = ((IEnumValue)o2).getCode();
            return code1.compareToIgnoreCase(code2);
        }
    }
}

