/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.FileTree;
import editor.util.EditorUtilities;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeCellRenderer;

public class FileTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private boolean _bSelected;
    private FileTree _node;
    private JTree _tree;

    public FileTreeCellRenderer(JTree tree) {
        this._tree = tree;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow, boolean bHasFocus) {
        if (value != null) {
            this._node = (FileTree)value;
            this._bSelected = bSelected;
            this.configure();
        }
        return this;
    }

    public void update() {
        this._tree.repaint();
    }

    public void configure() {
        if (this._node == null) {
            return;
        }
        this.setBorder(new EmptyBorder(0, 3, 0, 3));
        TypeSystem.lock();
        try {
            if (this._node.isDirectory() || !this._node.isFile() && this._node.getFileOrDir().getName().indexOf(46) < 0) {
                this.setText(this._node.getName());
            } else {
                IType type = this._node.getType();
                this.setText(type == null ? this._node.getName() : type.getRelativeName());
            }
            this.setIcon(this._node.getIcon());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            TypeSystem.unlock();
        }
    }

    @Override
    public void paint(Graphics g) {
        Color bkColor;
        boolean bFocus;
        boolean bl = bFocus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() == this._tree;
        if (this._bSelected) {
            bkColor = this._tree.isEnabled() && bFocus ? EditorUtilities.ACTIVE_CAPTION : EditorUtilities.CONTROL;
        } else {
            bkColor = this._tree.getBackground();
            if (bkColor == null) {
                bkColor = this.getBackground();
            }
        }
        if (bkColor != null) {
            g.setColor(bkColor);
            g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            if (this._bSelected) {
                g.setColor(this._tree.isEnabled() && bFocus ? EditorUtilities.XP_BORDER_COLOR : EditorUtilities.CONTROL_SHADOW);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            g.setColor(bkColor);
        }
        this.setForeground(EditorUtilities.CONTROL_TEXT);
        super.paint(g);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (dim != null) {
            dim = new Dimension(dim.width + 3, dim.height);
        }
        return dim;
    }
}

