/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GosuEditor;
import editor.util.EditorUtilities;
import editor.util.HTMLEscapeUtil;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.exceptions.ParseWarning;
import gw.lang.reflect.IType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class GosuEditorFeedbackPanel
extends JPanel {
    private static final Color COLOR_ERROR = Color.RED;
    private static final Color COLOR_ERROR_SHADOW = new Color(128, 0, 0);
    private static final Color COLOR_WARNING = Color.YELLOW;
    private static final Color COLOR_WARNING_SHADOW = new Color(128, 128, 0);
    private JLabel _icon;
    private FeedbackMargin _feedback;
    private GosuEditor _editor;

    public GosuEditorFeedbackPanel() {
        this.configureUI();
    }

    public void update(int iResCode, GosuEditor editor) {
        this._icon.setIcon(this.loadIcon(iResCode));
        this._editor = editor;
        this._feedback.repaint();
        this.repaint();
        editor.repaint();
    }

    void configureUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(EditorUtilities.CONTROL);
        this.setBorder(null);
        this._icon = new JLabel();
        this._icon.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add((Component)this._icon, "North");
        this._feedback = new FeedbackMargin();
        ToolTipManager.sharedInstance().registerComponent(this._feedback);
        this.add((Component)this._feedback, "Center");
    }

    protected Icon loadIcon(int iResCode) {
        switch (iResCode) {
            case 0: {
                return EditorUtilities.loadIcon("images/rule_green.gif");
            }
            case 1: {
                return EditorUtilities.loadIcon("images/rule_yellow.gif");
            }
            case 4: {
                return EditorUtilities.loadIcon("images/status_anim.gif");
            }
        }
        return EditorUtilities.loadIcon("images/rule_red.gif");
    }

    private class FeedbackMargin
    extends JPanel {
        private Point _iMousePos;

        FeedbackMargin() {
            ErrorMarkMouseHandler errorMarkMouser = new ErrorMarkMouseHandler();
            this.addMouseMotionListener(errorMarkMouser);
            this.addMouseListener(errorMarkMouser);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (GosuEditorFeedbackPanel.this._editor == null) {
                return;
            }
            ParseResultsException pe = GosuEditorFeedbackPanel.this._editor.getParseResultsException();
            if (pe == null) {
                return;
            }
            int iLineCount = this.getLineCount();
            List pws = pe.getParseWarnings();
            for (int i = 0; i < pws.size(); ++i) {
                ParseWarning w = (ParseWarning)pws.get(i);
                this.paintWarningMark(g, w, iLineCount);
            }
            List pes = pe.getParseExceptions();
            for (int i = 0; i < pes.size(); ++i) {
                ParseException e = (ParseException)((Object)pes.get(i));
                this.paintErrorMark(g, e, iLineCount);
            }
        }

        private void paintWarningMark(Graphics g, ParseWarning w, int iLineCount) {
            int iMark = this.getMarkForIssue((IParseIssue)w, iLineCount);
            g.setColor(COLOR_WARNING);
            g.fillRect(1, iMark - 1, this.getWidth() - 2, 3);
            g.setColor(COLOR_WARNING_SHADOW);
            g.drawLine(2, iMark + 1, this.getWidth() - 2, iMark + 1);
            g.drawLine(this.getWidth() - 2, iMark - 1, this.getWidth() - 2, iMark + 1);
        }

        private void paintErrorMark(Graphics g, ParseException e, int iLineCount) {
            int iMark = this.getMarkForIssue((IParseIssue)e, iLineCount);
            g.setColor(COLOR_ERROR);
            g.fillRect(1, iMark - 1, this.getWidth() - 2, 3);
            g.setColor(COLOR_ERROR_SHADOW);
            g.drawLine(2, iMark + 1, this.getWidth() - 2, iMark + 1);
            g.drawLine(this.getWidth() - 2, iMark - 1, this.getWidth() - 2, iMark + 1);
        }

        @Override
        public String getToolTipText() {
            if (this._iMousePos == null) {
                return null;
            }
            return this.makeToolTipText(this.getErrorsFromCursorPos());
        }

        private String makeToolTipText(List parseExceptions) {
            if (parseExceptions == null || parseExceptions.isEmpty()) {
                return null;
            }
            String strFeedback = "";
            for (int i = parseExceptions.size() - 1; i >= 0; --i) {
                String strTypesExpected;
                ParseException pe;
                IType typeExpected;
                strFeedback = strFeedback.length() > 0 ? strFeedback + "<br><hr>" : "<html>";
                IParseIssue pi = (IParseIssue)parseExceptions.get(i);
                strFeedback = strFeedback + "&nbsp;" + HTMLEscapeUtil.escape(pi.getUIMessage());
                if (!(pi instanceof ParseException) || (typeExpected = (pe = (ParseException)pi).getExpectedType()) == null || (strTypesExpected = ParseResultsException.getExpectedTypeName((IType)typeExpected)).length() <= 0) continue;
                strFeedback = strFeedback + "\nExpected Type:" + strTypesExpected;
            }
            return strFeedback;
        }

        private List getErrorsFromCursorPos() {
            if (GosuEditorFeedbackPanel.this._editor == null) {
                return null;
            }
            ArrayList<IParseIssue> matches = new ArrayList<IParseIssue>();
            ParseResultsException pe = GosuEditorFeedbackPanel.this._editor.getParseResultsException();
            if (pe == null) {
                return matches;
            }
            int iLineCount = this.getLineCount();
            List pes = pe.getParseIssues();
            for (int i = pes.size() - 1; i >= 0; --i) {
                IParseIssue e = (IParseIssue)pes.get(i);
                int iMark = this.getMarkForIssue(e, iLineCount);
                if (iMark < this._iMousePos.y - 3 || iMark > this._iMousePos.y + 3) continue;
                matches.add(e);
            }
            return matches;
        }

        private int getMarkForIssue(IParseIssue e, int iLineCount) {
            if (--iLineCount == 0) {
                return this.getHeight() / 2;
            }
            int iLine = e.getLine() - 1;
            float fOffset = (float)iLine / (float)iLineCount;
            return (int)((float)(this.getHeight() - 10) * fOffset) + 5;
        }

        public int getLineCount() {
            int iLinesOfCode = GosuEditorFeedbackPanel.this._editor.getEditor().getDocument().getDefaultRootElement().getElementCount();
            int iViewHeight = GosuEditorFeedbackPanel.this._editor.getScroller().getViewport().getHeight();
            FontMetrics fm = GosuEditorFeedbackPanel.this._editor.getEditor().getFontMetrics(GosuEditorFeedbackPanel.this._editor.getEditor().getFont());
            int iLineHeight = fm.getHeight();
            int iViewLines = iViewHeight / iLineHeight;
            return Math.max(iViewLines, iLinesOfCode);
        }

        private class ErrorMarkMouseHandler
        extends MouseAdapter
        implements MouseMotionListener {
            private ErrorMarkMouseHandler() {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                FeedbackMargin.this._iMousePos = e.getPoint();
                List errors = FeedbackMargin.this.getErrorsFromCursorPos();
                FeedbackMargin.this.setCursor(errors == null || errors.isEmpty() ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                List errors = FeedbackMargin.this.getErrorsFromCursorPos();
                if (!errors.isEmpty()) {
                    GosuEditorFeedbackPanel.this._editor.getEditor().requestFocusInWindow();
                    GosuEditorFeedbackPanel.this._editor.setCaretPositionForParseIssue((IParseIssue)errors.get(0));
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        }
    }
}

