/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractParseExceptionResolver;
import editor.BeanInfoPopup;
import editor.BeanTree;
import editor.util.EditorUtilities;
import editor.util.TextComponentUtil;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.expressions.IFieldAccessExpression;
import gw.util.IFeatureFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MemberAccessValueCompletion
extends AbstractParseExceptionResolver {
    @Override
    public void resolve(ParseException e) {
    }

    @Override
    public boolean handleCompleteValue() {
        IParseTree currentLocation = this.getDeepestLocationToComplete();
        IParsedElement element = currentLocation.getParsedElement();
        if (!(element instanceof IFieldAccessExpression)) {
            return false;
        }
        IFieldAccessExpression ma = (IFieldAccessExpression)element;
        try {
            String strLastMember = ma.getMemberName();
            IFeatureFilter filter = null;
            BeanInfoPopup popup = new BeanInfoPopup(ma.getRootType(), strLastMember, false, this.getGosuEditor(), filter);
            popup.setSelection(strLastMember, true);
            popup.addNodeChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    BeanTree beanInfoSelection = (BeanTree)e.getSource();
                    String strRef = beanInfoSelection.makePath(false);
                    TextComponentUtil.replaceWordAtClosestDot(MemberAccessValueCompletion.this.getEditor(), strRef);
                    MemberAccessValueCompletion.this.getEditor().requestFocus();
                    MemberAccessValueCompletion.this.getGosuEditor().fixSwingFocusBugWhenPopupCloses();
                    MemberAccessValueCompletion.this.getEditor().repaint();
                }
            });
            this.getGosuEditor().setBeanInfoPopup(popup);
            this.getGosuEditor().displayBeanInfoPopup(currentLocation.getOffset() + currentLocation.getLength());
        }
        catch (ParseException pe) {
            EditorUtilities.handleUncaughtException(pe);
        }
        return true;
    }
}

