/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractParseExceptionResolver;
import editor.StringPopup;
import editor.util.TextComponentUtil;
import gw.config.CommonServices;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.expressions.ILiteralExpression;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NumberValueCompletion
extends AbstractParseExceptionResolver {
    @Override
    public boolean canResolve(ParseException pe) {
        if (!super.canResolve(pe)) {
            return false;
        }
        IType typeExpected = this.getExpectedType(pe);
        return typeExpected != null && TypeSystem.isNumericType((IType)typeExpected);
    }

    @Override
    public void resolve(ParseException pe) {
        IType baseType = this.getBaseType(pe);
        StringPopup popup = new StringPopup("0", baseType == null ? JavaTypes.NUMBER().getRelativeName() : baseType.getRelativeName(), this.getGosuEditor().getEditor());
        popup.addNodeChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AbstractParseExceptionResolver.isEditorAtPossibleArgPosition(NumberValueCompletion.this.getDeepestLocationToComplete().getParsedElement(), NumberValueCompletion.this.getEditor())) {
                    NumberValueCompletion.this.insertTextAtCaret(e.getSource().toString());
                } else {
                    TextComponentUtil.replaceWordAtCaretDynamic(NumberValueCompletion.this.getEditor(), (String)e.getSource(), NumberValueCompletion.this.getGosuEditor().getReplaceWordCallback(), false);
                }
                NumberValueCompletion.this.getEditor().requestFocus();
                NumberValueCompletion.this.getGosuEditor().fixSwingFocusBugWhenPopupCloses();
                NumberValueCompletion.this.getEditor().repaint();
            }
        });
        this.showValueCompletionPopup(popup, false);
    }

    @Override
    public boolean handleCompleteValue() {
        IType typeExpected = this.getTypeExpected();
        if (typeExpected == null) {
            return false;
        }
        if (!TypeSystem.isNumericType((IType)typeExpected)) {
            return false;
        }
        final IParseTree currentLocation = this.getDeepestLocationToComplete();
        Double dValue = null;
        IParsedElement element = currentLocation.getParsedElement();
        if (element instanceof ILiteralExpression) {
            dValue = (Double)CommonServices.getCoercionManager().convertValue(((ILiteralExpression)element).evaluate(), TypeSystem.get(Double.class));
        }
        StringPopup popup = new StringPopup(dValue == null ? "0" : dValue.toString(), JavaTypes.NUMBER().getRelativeName(), this.getGosuEditor().getEditor());
        popup.addNodeChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NumberValueCompletion.this.getGosuEditor().replaceLocation(currentLocation, e.getSource().toString());
                NumberValueCompletion.this.getEditor().requestFocus();
                NumberValueCompletion.this.getGosuEditor().fixSwingFocusBugWhenPopupCloses();
                NumberValueCompletion.this.getEditor().repaint();
            }
        });
        this.showValueCompletionPopup(popup, true);
        return true;
    }
}

