/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.IContextMenuHandler;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class PopupHandler<E>
extends MouseAdapter {
    protected E _owner;
    private IContextMenuHandler<E> _contextMenuHandler;

    public PopupHandler(E owner, IContextMenuHandler<E> contextMenuHandler) {
        this._owner = owner;
        this._contextMenuHandler = contextMenuHandler;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handleContextMenu(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handleContextMenu(e);
    }

    private void handleContextMenu(MouseEvent e) {
        int iXPos = e.getX();
        int iYPos = e.getY();
        if (e.isPopupTrigger()) {
            this.handleRightClick(iXPos, iYPos, e.getComponent());
        }
    }

    protected void handleRightClick(final int iXPos, final int iYPos, final Component component) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PopupHandler.this._contextMenuHandler.displayContextMenu(PopupHandler.this._owner, iXPos, iYPos, component);
            }
        });
    }
}

