/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.ScriptChangeHandler;
import editor.undo.IStagedStateEditable;
import editor.util.EditorUtilities;
import java.util.Hashtable;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoableEdit;

public class ScriptEditorUndoItem
implements IStagedStateEditable {
    private ScriptChangeHandler _sch;
    private boolean _bUndo;
    private int _iUndoPos;
    private int _iRedoPos;
    private UndoableEdit _docEdit;

    public ScriptEditorUndoItem(ScriptChangeHandler sch, UndoableEdit docEdit) {
        this._sch = sch;
        this._docEdit = docEdit;
    }

    public void storeState(Hashtable stateTable) {
        this._bUndo = !this._bUndo;
        stateTable.put("_undo", this._bUndo ? Boolean.TRUE : Boolean.FALSE);
        if (this._bUndo) {
            this._iUndoPos = this._sch.getBefore();
        } else {
            this._iRedoPos = this._sch.getAfter();
        }
    }

    public void restoreState(Hashtable stateTable) {
        this._sch.getEditor().requestFocus();
        this._sch.setPaused(true);
        try {
            boolean bUndo = (Boolean)stateTable.get("_undo");
            if (this._docEdit != null) {
                if (bUndo) {
                    this._docEdit.undo();
                } else {
                    this._docEdit.redo();
                }
            }
            this._sch.getEditor().setCaretPosition(bUndo ? this._iUndoPos : this._iRedoPos);
            this._sch.updatePositionInfo();
        }
        catch (Exception e) {
            EditorUtilities.handleUncaughtException(e);
        }
        finally {
            this._sch.setPaused(false);
        }
    }

    @Override
    public boolean prepareForUndo() {
        JTextComponent editor = this._sch.getEditor();
        if (editor.getCaretPosition() != this._iRedoPos) {
            editor.setCaretPosition(this._iRedoPos);
            return false;
        }
        return true;
    }

    @Override
    public boolean prepareForRedo() {
        JTextComponent editor = this._sch.getEditor();
        if (editor.getCaretPosition() != this._iUndoPos) {
            editor.setCaretPosition(this._iUndoPos);
            return false;
        }
        return true;
    }
}

