/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.util.EditorUtilities;
import gw.util.GosuObjectUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;

public class ToggleToolBarButton
extends JToggleButton {
    private static final ImageIcon MENU_ICON = EditorUtilities.loadIcon("images/drop_down_arrow_3.gif");
    private Border _activeBorder;
    private Color _clrBkgnd;
    private boolean _bRollover;
    private boolean _bMenu;
    public static final Color XP_BORDER_COLOR = EditorUtilities.XP_BORDER_COLOR;
    private static final Color XP_TOGGLE_ROLLOVER_COLOR = EditorUtilities.XP_HIGHLIGHT_COLOR;
    private static final Color XP_TOGGLE_SELECTED_COLOR = EditorUtilities.XP_HIGHLIGHT_SELECTED_COLOR;

    public ToggleToolBarButton(String text, Icon icon) {
        super(text, icon);
        this.setContentAreaFilled(false);
        this.setOpaque(true);
        this._clrBkgnd = EditorUtilities.CONTROL;
        this._activeBorder = new CompoundBorder(new LineBorder(XP_BORDER_COLOR, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setBorder(this._activeBorder);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ToggleToolBarButton.this.isEnabled()) {
                    ToggleToolBarButton.this._bRollover = true;
                    ToggleToolBarButton.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToggleToolBarButton.this._bRollover = false;
                ToggleToolBarButton.this.repaint();
            }
        });
    }

    public ToggleToolBarButton(Icon icon) {
        this(null, icon);
    }

    public ToggleToolBarButton(String text) {
        this(text, null);
    }

    public ToggleToolBarButton() {
        this(null, null);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
    }

    public boolean isMenu() {
        return this._bMenu;
    }

    public void setMenu(boolean bMenu) {
        this._bMenu = bMenu;
    }

    @Override
    public void setVisible(boolean bVisible) {
        super.setVisible(bVisible);
        JComponent separator = (JComponent)this.getClientProperty("_separatorComp");
        if (separator != null) {
            separator.setVisible(bVisible);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this._bRollover) {
            if (!this.isSelected()) {
                this.setBackground(XP_TOGGLE_ROLLOVER_COLOR);
            } else {
                this.setBackground(XP_TOGGLE_SELECTED_COLOR);
            }
        } else if (this.isSelected()) {
            this.setBackground(XP_TOGGLE_SELECTED_COLOR);
        } else {
            this.setBackground(this._clrBkgnd);
        }
        super.paintComponent(g);
        if (this.isMenu()) {
            int iMenuIconX = this.getWidth() - this.getInsets().right - MENU_ICON.getIconWidth();
            MENU_ICON.paintIcon(this, g, iMenuIconX, this.getInsets().top + this.getMargin().top);
            g.setColor(EditorUtilities.CONTROL_SHADOW);
            g.drawLine(iMenuIconX - 2, 0, iMenuIconX - 2, this.getHeight());
            g.setColor(EditorUtilities.CONTROL_LIGHT);
            g.drawLine(iMenuIconX - 1, 0, iMenuIconX - 1, this.getHeight());
        }
    }

    public void setClrBkgnd(Color clrBkgnd) {
        this._clrBkgnd = clrBkgnd;
    }

    @Override
    protected void paintBorder(Graphics g) {
        if (this.isSelected() || this._bRollover) {
            this._activeBorder.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public ToggleToolBarButton(Action action) {
        this();
        this.setAction(action);
    }

    @Override
    public String getToolTipText() {
        String superText = super.getToolTipText();
        if (superText == null || superText.length() == 0) {
            return null;
        }
        if (this.getAction() != null) {
            return GosuObjectUtil.toString((Object)this.getAction().getValue("ShortDescription"));
        }
        return superText;
    }
}

