/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import editor.search.StudioUtilities;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;

public class MultiLineLabelUI
extends BasicLabelUI
implements SwingConstants {
    private static Rectangle _rcPaintIcon = new Rectangle();
    private static Rectangle _rcPaintText = new Rectangle();
    private static Rectangle _rcPaintView = new Rectangle();
    private static Insets _insetsPaintView = new Insets(0, 0, 0, 0);
    protected static final MultiLineLabelUI _multiLineLabelUI = new MultiLineLabelUI();

    public static ComponentUI createUI(JComponent c) {
        return _multiLineLabelUI;
    }

    protected Vector layoutCL(Graphics g, JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        return MultiLineLabelUI.layoutCompoundLabel(g, label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap());
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon icon;
        JLabel label = (JLabel)c;
        String strText = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && strText == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        if (c.getHeight() < fm.getHeight() + fm.getAscent() / 2 || c.getClientProperty("html") != null) {
            super.paint(g, c);
            return;
        }
        _insetsPaintView = c.getInsets(_insetsPaintView);
        MultiLineLabelUI._rcPaintView.x = MultiLineLabelUI._insetsPaintView.left;
        MultiLineLabelUI._rcPaintView.y = MultiLineLabelUI._insetsPaintView.top;
        MultiLineLabelUI._rcPaintView.width = c.getWidth() - (MultiLineLabelUI._insetsPaintView.left + MultiLineLabelUI._insetsPaintView.right);
        MultiLineLabelUI._rcPaintView.height = c.getHeight() - (MultiLineLabelUI._insetsPaintView.top + MultiLineLabelUI._insetsPaintView.bottom);
        MultiLineLabelUI._rcPaintIcon.height = 0;
        MultiLineLabelUI._rcPaintIcon.width = 0;
        MultiLineLabelUI._rcPaintIcon.y = 0;
        MultiLineLabelUI._rcPaintIcon.x = 0;
        MultiLineLabelUI._rcPaintText.height = 0;
        MultiLineLabelUI._rcPaintText.width = 0;
        MultiLineLabelUI._rcPaintText.y = 0;
        MultiLineLabelUI._rcPaintText.x = 0;
        Vector vtext = this.layoutCL(g, label, fm, strText, icon, _rcPaintView, _rcPaintIcon, _rcPaintText);
        if (icon != null) {
            icon.paintIcon(c, g, MultiLineLabelUI._rcPaintIcon.x, MultiLineLabelUI._rcPaintIcon.y);
        }
        MultiLineLabelUI._rcPaintText.y = MultiLineLabelUI._rcPaintText.y < 0 ? 0 : MultiLineLabelUI._rcPaintText.y;
        MultiLineLabelUI._rcPaintText.height = fm.getHeight();
        if (vtext != null) {
            g.setColor(label.getForeground());
            int iLines = vtext.size();
            for (int i = 0; i < iLines; ++i) {
                StudioUtilities.drawStringInRectClipped(g, fm, (String)vtext.elementAt(i), _rcPaintText, ((JLabel)c).getHorizontalAlignment(), ((JLabel)c).getVerticalAlignment(), false);
                MultiLineLabelUI._rcPaintText.y += fm.getHeight();
            }
        }
    }

    public Dimension getPreferredSizeWithVariableHeightOnly(JComponent c) {
        JLabel label = (JLabel)c;
        String strText = label.getText();
        Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        _insetsPaintView = c.getInsets(_insetsPaintView);
        MultiLineLabelUI._rcPaintView.x = MultiLineLabelUI._insetsPaintView.left;
        MultiLineLabelUI._rcPaintView.y = MultiLineLabelUI._insetsPaintView.top;
        MultiLineLabelUI._rcPaintView.width = c.getWidth() - (MultiLineLabelUI._insetsPaintView.left + MultiLineLabelUI._insetsPaintView.right);
        MultiLineLabelUI._rcPaintView.height = 0;
        MultiLineLabelUI._rcPaintIcon.height = 0;
        MultiLineLabelUI._rcPaintIcon.width = 0;
        MultiLineLabelUI._rcPaintIcon.y = 0;
        MultiLineLabelUI._rcPaintIcon.x = 0;
        MultiLineLabelUI._rcPaintText.height = 0;
        MultiLineLabelUI._rcPaintText.width = 0;
        MultiLineLabelUI._rcPaintText.y = 0;
        MultiLineLabelUI._rcPaintText.x = 0;
        FontMetrics fm = c.getFontMetrics(c.getFont());
        Vector vtext = this.layoutCL(null, label, fm, strText, icon, _rcPaintView, _rcPaintIcon, _rcPaintText);
        int iWidth = c.getWidth() - (MultiLineLabelUI._insetsPaintView.left + MultiLineLabelUI._insetsPaintView.right);
        int iHeight = fm.getHeight() * (vtext == null ? 0 : vtext.size()) - (MultiLineLabelUI._insetsPaintView.top + MultiLineLabelUI._insetsPaintView.bottom);
        return new Dimension(iWidth, iHeight);
    }

    public static Vector layoutCompoundLabel(Graphics g, JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        boolean orientationIsLeftToRight = true;
        int hAlign = horizontalAlignment;
        int hTextPos = horizontalTextPosition;
        if (c != null && !c.getComponentOrientation().isLeftToRight()) {
            orientationIsLeftToRight = false;
        }
        switch (horizontalAlignment) {
            case 10: {
                hAlign = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hAlign = orientationIsLeftToRight ? 4 : 2;
            }
        }
        switch (horizontalTextPosition) {
            case 10: {
                hTextPos = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hTextPos = orientationIsLeftToRight ? 4 : 2;
            }
        }
        return MultiLineLabelUI.layoutCompoundLabelImpl(g, c, fm, text, icon, verticalAlignment, hAlign, verticalTextPosition, hTextPos, viewR, iconR, textR, textIconGap);
    }

    public static Vector layoutCompoundLabel(Graphics g, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        return MultiLineLabelUI.layoutCompoundLabelImpl(g, null, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
    }

    private static Vector layoutCompoundLabelImpl(Graphics g, JComponent c, FontMetrics fm, String strText, Icon icon, int iVerticalAlignment, int iHorizontalAlignment, int iVerticalTextPosition, int iHorizontalTextPosition, Rectangle rcView, Rectangle rcIcon, Rectangle rcText, int iTextIconGap) {
        if (icon != null) {
            rcIcon.width = icon.getIconWidth();
            rcIcon.height = icon.getIconHeight();
        } else {
            rcIcon.height = 0;
            rcIcon.width = 0;
        }
        boolean bEmptyText = strText == null || strText.length() == 0;
        int iGap = bEmptyText || icon == null ? 0 : iTextIconGap;
        int iAvailTextWidth = iHorizontalTextPosition == 0 ? rcView.width : rcView.width - (rcIcon.width + iGap);
        Vector<Object> vtext = null;
        View viewHtml = null;
        if (bEmptyText) {
            vtext = new Vector<String>();
            rcText.height = 0;
            rcText.width = 0;
            strText = "";
            vtext.addElement(strText);
        } else {
            View view = viewHtml = c != null ? (View)c.getClientProperty("html") : null;
            if (viewHtml != null) {
                rcText.width = (int)viewHtml.getPreferredSpan(0);
                rcText.height = (int)viewHtml.getPreferredSpan(1);
                if (rcText.width > iAvailTextWidth) {
                    rcText.width = iAvailTextWidth;
                }
            } else {
                rcText.setBounds(rcView.x, rcView.y, iAvailTextWidth, rcView.height);
                vtext = StudioUtilities.drawTextWrapped(null, rcText, strText, fm.getFont(), 0, false, false);
                rcText.height = vtext.size() * fm.getHeight();
            }
        }
        rcText.y = iVerticalTextPosition == 1 ? (iHorizontalTextPosition != 0 ? 0 : -(rcText.height + iGap)) : (iVerticalTextPosition == 0 ? rcIcon.height / 2 - rcText.height / 2 : (iHorizontalTextPosition != 0 ? rcIcon.height - rcText.height : rcIcon.height + iGap));
        rcText.x = iHorizontalTextPosition == 2 ? -(rcText.width + iGap) : (iHorizontalTextPosition == 0 ? rcIcon.width / 2 - rcText.width / 2 : rcIcon.width + iGap);
        int iLabel_x = Math.min(rcIcon.x, rcText.x);
        int iLabel_width = Math.max(rcIcon.x + rcIcon.width, rcText.x + rcText.width) - iLabel_x;
        int iLabel_y = Math.min(rcIcon.y, rcText.y);
        int iLabel_height = Math.max(rcIcon.y + rcIcon.height, rcText.y + rcText.height) - iLabel_y;
        int dy = iVerticalAlignment == 1 ? rcView.y - iLabel_y : (iVerticalAlignment == 0 ? rcView.y + rcView.height / 2 - (iLabel_y + iLabel_height / 2) : rcView.y + rcView.height - (iLabel_y + iLabel_height));
        int dx = iHorizontalAlignment == 2 ? rcView.x - iLabel_x : (iHorizontalAlignment == 4 ? rcView.x + rcView.width - (iLabel_x + iLabel_width) : rcView.x + rcView.width / 2 - (iLabel_x + iLabel_width / 2));
        rcText.x += dx;
        rcText.y += dy;
        rcIcon.x += dx;
        rcIcon.y += dy;
        return vtext;
    }
}

