/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import editor.BasicGosuEditor;
import editor.RunMe;
import editor.search.MessageDisplay;
import editor.util.EditorUtilities;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class StudioUtilities
implements SwingConstants {
    static final HashMap<String, ImageIcon> ICON_TABLE = new HashMap();
    protected static Rectangle g_rcClipCursor;
    protected static ClipCursorHandler g_clipCursorListener;
    protected static Robot g_robot;
    static final Rectangle RCTEXT;
    static final Rectangle SHOULDPAINT_RECT;
    static final Rectangle SHOULDPAINT_RECT_IN;
    static Map<Component, Boolean> CONTAINS_FOCUS;
    static Map<Component, Boolean> FOCUS_CONTAINS;

    private StudioUtilities() {
    }

    public static void enableComponent(Component c, boolean bEnabled) {
        Component[] children;
        if (c.isEnabled() != bEnabled) {
            c.setEnabled(bEnabled);
        }
        if (c instanceof Container && (children = ((Container)c).getComponents()) != null) {
            for (Component child : children) {
                StudioUtilities.enableComponent(child, bEnabled);
            }
        }
    }

    public static Component getFocus() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
    }

    public static Window getFocusedWindow() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
    }

    public static Window getActiveWindow() {
        Frame[] frames;
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (activeWindow == null && (frames = Frame.getFrames()) != null && frames.length > 0) {
            return frames[0];
        }
        return activeWindow;
    }

    public static boolean containsFocus(Component c) {
        Component focusOwner;
        StudioUtilities.addFocusListener();
        Boolean containsFocus = CONTAINS_FOCUS.get(c);
        if (containsFocus != null) {
            return containsFocus;
        }
        Component temp = focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        while (temp != null) {
            if (temp == c) {
                CONTAINS_FOCUS.put(c, true);
                return true;
            }
            temp = temp instanceof Window ? null : temp.getParent();
        }
        CONTAINS_FOCUS.put(c, false);
        return false;
    }

    public static boolean focusContains(Component c) {
        StudioUtilities.addFocusListener();
        Boolean focusContains = FOCUS_CONTAINS.get(c);
        if (focusContains != null) {
            return focusContains;
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        Component temp = c;
        while (temp != null) {
            if (temp == focusOwner) {
                FOCUS_CONTAINS.put(c, true);
                return true;
            }
            temp = temp instanceof Window ? null : temp.getParent();
        }
        FOCUS_CONTAINS.put(c, false);
        return false;
    }

    private static void addFocusListener() {
        if (CONTAINS_FOCUS != null) {
            return;
        }
        CONTAINS_FOCUS = new HashMap<Component, Boolean>();
        FOCUS_CONTAINS = new HashMap<Component, Boolean>();
        KeyboardFocusManager focusMgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusMgr.addPropertyChangeListener("permanentFocusOwner", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CONTAINS_FOCUS.clear();
                FOCUS_CONTAINS.clear();
            }
        });
    }

    public static boolean isInFocusLineage(Component c) {
        return StudioUtilities.containsFocus(c) || StudioUtilities.focusContains(c);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void centerWindowInFrame(Component window, Window frame) {
        Point ptOffset;
        Dimension dimCenter;
        block5: {
            if (frame != null) {
                if ((!(frame instanceof Frame) || ((Frame)frame).getState() != 1) && frame.isShowing()) {
                    dimCenter = frame.getSize();
                    ptOffset = frame.getLocation();
                    break block5;
                } else {
                    StudioUtilities.centerWindowInFrame(window, null);
                    return;
                }
            }
            Window owner = SwingUtilities.getWindowAncestor(window);
            if (owner != null && owner.isShowing() && owner.getMinimumSize().height < owner.getHeight()) {
                if ((!(owner instanceof Frame) || ((Frame)owner).getState() != 1) && owner.isShowing()) {
                    Dimension dimCenter2 = owner.getSize();
                    Point ptOffset2 = owner.getLocation();
                    window.setLocation(ptOffset2.x + (dimCenter2.width - window.getWidth()) / 2, ptOffset2.y + (dimCenter2.height - window.getHeight()) / 2);
                }
                return;
            }
            Rectangle screenRect = StudioUtilities.getPrimaryMonitorScreenRect();
            dimCenter = new Dimension((int)screenRect.getWidth(), (int)screenRect.getHeight());
            ptOffset = new Point((int)screenRect.getX(), (int)screenRect.getY());
        }
        window.setLocation(ptOffset.x + (dimCenter.width - window.getWidth()) / 2, ptOffset.y + (dimCenter.height - window.getHeight()) / 2);
    }

    public static void removePopupBorder(final Container c) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Container p = c; p != null; p = p.getParent()) {
                    if (!(p instanceof JComponent)) continue;
                    ((JComponent)p).setBorder(null);
                }
            }
        });
    }

    public static JRootPane rootPaneForComponent(Component comp) {
        for (Component p = comp; p != null; p = p.getParent()) {
            if (p instanceof JRootPane) {
                return (JRootPane)p;
            }
            if (comp instanceof JFrame) {
                return ((JFrame)comp).getRootPane();
            }
            if (comp instanceof JDialog) {
                return ((JDialog)comp).getRootPane();
            }
            if (!(comp instanceof JWindow)) continue;
            return ((JWindow)comp).getRootPane();
        }
        return null;
    }

    public static Component showWaitCursor(boolean bWait) {
        return WaitCursorRunner.showWaitCursor(bWait);
    }

    public static void showWaitCursor(boolean bWait, Component c) {
        WaitCursorRunner.showWaitCursor(bWait, c);
    }

    public static void doWaitOperation(Runnable op) {
        Component key = StudioUtilities.showWaitCursor(true);
        try {
            op.run();
        }
        finally {
            StudioUtilities.showWaitCursor(false, key);
        }
    }

    public static String wrapText(String strText) {
        return StudioUtilities.wrapText(strText, 60);
    }

    public static String wrapText(String strText, int iLineLen) {
        Vector<String> vStrings = StudioUtilities.drawTextWrapped(null, new Rectangle(), strText, new Font("Tahoma", 0, 11), iLineLen, false, true);
        String strRet = "";
        for (int i = 0; i < vStrings.size(); ++i) {
            strRet = strRet + vStrings.elementAt(i);
        }
        return strRet;
    }

    public static void invokeInDispatchThread(Runnable task) {
        if (task == null) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            try {
                EventQueue.invokeAndWait(task);
            }
            catch (Throwable t) {
                EditorUtilities.handleUncaughtException(t);
            }
        }
    }

    public static void invokeNowOrLater(Runnable task) {
        if (task == null) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            try {
                EventQueue.invokeLater(task);
            }
            catch (Throwable t) {
                EditorUtilities.handleUncaughtException(t);
            }
        }
    }

    public static Rectangle drawStringInRectClipped(Graphics g, String strText, Rectangle rcClip, int iHorzAlign, int iVertAlign) {
        return StudioUtilities.drawStringInRectClipped(g, null, strText, rcClip, iHorzAlign, iVertAlign, true);
    }

    public static Rectangle drawStringInRectClipped(Graphics g, FontMetrics fm, String strText, Rectangle rcClip, int iHorzAlign, int iVertAlign, boolean bReturnBounds) {
        RCTEXT.setBounds(0, 0, 0, 0);
        MessageDisplay.SCRATCH_RECT.setBounds(0, 0, 0, 0);
        fm = fm == null ? g.getFontMetrics() : fm;
        String str = SwingUtilities.layoutCompoundLabel(fm, strText, null, iVertAlign, iHorzAlign, 3, 4, rcClip, MessageDisplay.SCRATCH_RECT, RCTEXT, 0);
        if (str != null && !str.equals("")) {
            g.drawString(str, StudioUtilities.RCTEXT.x, StudioUtilities.RCTEXT.y + fm.getAscent());
        }
        return bReturnBounds ? new Rectangle(RCTEXT) : null;
    }

    public static void drawStringInRect(Graphics g, String strText, Rectangle rc, int justification, boolean bClip) {
        StudioUtilities.drawStringInRect(g, strText, rc.x, rc.y, rc.width, rc.height, justification, bClip);
    }

    public static void drawStringInRect(Graphics g, String strText, int x, int y, int width, int height, int justification, boolean bClip) {
        int startX;
        if (g.getFont() == null) {
            return;
        }
        FontMetrics fontMetrics = g.getFontMetrics();
        if (fontMetrics == null) {
            return;
        }
        if (bClip) {
            MessageDisplay.SCRATCH_RECT.setBounds(g.getClipBounds());
            MessageDisplay.SCRATCH_RECT2.setBounds(x, y, width, height);
            if (MessageDisplay.SCRATCH_RECT.intersects(MessageDisplay.SCRATCH_RECT2)) {
                MessageDisplay.SCRATCH_RECT2.setBounds(MessageDisplay.SCRATCH_RECT.intersection(MessageDisplay.SCRATCH_RECT2));
                g.setClip(MessageDisplay.SCRATCH_RECT2);
            } else {
                return;
            }
        }
        if (justification == 0) {
            int drawWidth = fontMetrics.stringWidth(strText);
            if (drawWidth > width) {
                drawWidth = width;
            }
            startX = x + (width - drawWidth) / 2;
        } else if (justification == 4) {
            int drawWidth = fontMetrics.stringWidth(strText);
            if (drawWidth > width) {
                drawWidth = width;
            }
            startX = x + width - drawWidth;
        } else {
            startX = x;
        }
        int delta = (height - fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
        if (delta < 0) {
            delta = 0;
        }
        int startY = y + height - delta - fontMetrics.getDescent();
        g.drawString(strText, startX, startY);
        if (bClip) {
            g.setClip(MessageDisplay.SCRATCH_RECT);
        }
    }

    public static boolean shouldPaint(Graphics g, Component comp) {
        Rectangle rcBounds = comp.getBounds();
        return StudioUtilities.shouldPaint(g, rcBounds.x, rcBounds.y, rcBounds.width, rcBounds.height);
    }

    public static boolean shouldPaint(Graphics g, int x, int y, int iWidth, int iHeight) {
        Rectangle rcClipBounds = g.getClipBounds();
        if (rcClipBounds == null) {
            return true;
        }
        SHOULDPAINT_RECT.setBounds(rcClipBounds);
        SHOULDPAINT_RECT_IN.setBounds(x, y, iWidth, iHeight);
        return SHOULDPAINT_RECT.intersects(SHOULDPAINT_RECT_IN);
    }

    public static Vector<String> drawTextWrapped(Graphics g, Rectangle rect, String strText) {
        return StudioUtilities.drawTextWrapped(g, rect, strText, null, 0, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static Vector<String> drawTextWrapped(Graphics g, Rectangle rect, String strText, Font font, int iLineLengthChars, boolean bClip, boolean bAppendLineFeed) {
        try {
            v0 = vStrings = g == null ? new Vector<String>() : null;
            if (!bClip || g == null || rect == null || rect.isEmpty()) ** GOTO lbl12
            MessageDisplay.SCRATCH_RECT.setBounds(g.getClipBounds());
            MessageDisplay.SCRATCH_RECT2.setBounds(rect.x, rect.y, rect.width, rect.height);
            if (MessageDisplay.SCRATCH_RECT.intersects(MessageDisplay.SCRATCH_RECT2)) {
                MessageDisplay.SCRATCH_RECT2.setBounds(MessageDisplay.SCRATCH_RECT.intersection(MessageDisplay.SCRATCH_RECT2));
                g.setClip(MessageDisplay.SCRATCH_RECT2);
            } else {
                var8_8 = vStrings;
                return var8_8;
lbl12:
                // 1 sources

                bClip = false;
            }
            if (strText == null || strText.length() == 0 || iLineLengthChars <= 0 && (rect == null || rect.width == 0)) {
                var8_9 = vStrings;
                return var8_9;
            }
            strText = strText.indexOf(9) >= 0 ? strText.replace('\t', ' ') : strText;
            v1 = fm = g == null ? Toolkit.getDefaultToolkit().getFontMetrics(font) : g.getFontMetrics();
            if (iLineLengthChars > 0) {
                rect.width = fm.charWidth('p') * iLineLengthChars;
            }
            x = rect.x;
            y = rect.y + fm.getAscent();
            iWidth = rect.width;
            if (iWidth < 0) {
                var12_14 = vStrings;
                return var12_14;
            }
            strLine = "";
            bNeedToDrawLastToken = false;
            tokenizer = new StringTokenizer(strText, " \t\n\r", true);
            token = null;
            while (tokenizer.hasMoreTokens() || bNeedToDrawLastToken) {
                token = bNeedToDrawLastToken != false ? token : tokenizer.nextToken();
                bSkip = false;
                for (i = 0; i < " \t\n\r".length(); ++i) {
                    if (token.charAt(0) != " \t\n\r".charAt(i)) continue;
                    if (" \t\n\r".charAt(i) == ' ' || " \t\n\r".charAt(i) == '\n') break;
                    bSkip = true;
                    break;
                }
                if (bSkip) continue;
                bNeedToDrawLastToken = tokenizer.hasMoreTokens() == false;
                iLinePlusToken = fm.stringWidth(strLine) + fm.stringWidth(token);
                bLastLineOfRect = false;
                if (bNeedToDrawLastToken && (iLinePlusToken <= iWidth || (bLastLineOfRect = rect.height > 0 && rect.y + rect.height < y - fm.getAscent() + fm.getHeight() + fm.getAscent() / 2))) {
                    strLine = strLine.concat(token);
                    bNeedToDrawLastToken = false;
                }
                if (iLinePlusToken > iWidth || token.charAt(0) == '\n' || !tokenizer.hasMoreTokens()) {
                    if (strLine.length() > 0 && (token.charAt(0) == '\n' || tokenizer.hasMoreTokens() || iLinePlusToken <= iWidth || bNeedToDrawLastToken || bLastLineOfRect)) {
                        if (g != null) {
                            g.drawString(strLine, x, y);
                        }
                        if (vStrings != null) {
                            vStrings.addElement(bAppendLineFeed != false ? strLine + "\n" : strLine);
                        }
                        y += fm.getHeight();
                        strLine = "";
                        if (token.charAt(0) == ' ' || token.charAt(0) == '\n') {
                            continue;
                        }
                    } else {
                        if (token.charAt(0) == '\n') {
                            y += fm.getHeight();
                            continue;
                        }
                        do {
                            if (token.length() == 1) {
                                var19_26 = vStrings;
                                return var19_26;
                            }
                            iLen = iSeg = token.length() / 2 + token.length() % 2;
                            strTokenPart = null;
                            while (iSeg >= 1) {
                                try {
                                    strTokenPart = token.substring(0, iLen - 1);
                                }
                                catch (Exception var22_30) {
                                    // empty catch block
                                }
                                iTestWidth = fm.stringWidth(strTokenPart);
                                iSeg = iSeg / 2 + (iSeg == 1 ? 0 : iSeg % 2);
                                if (iTestWidth > iWidth) {
                                    iLen -= iSeg;
                                    continue;
                                }
                                if (iTestWidth == iWidth) break;
                                iLen += iSeg;
                            }
                            if (strTokenPart == null) break;
                            if (strText.startsWith("<html>") && strTokenPart.lastIndexOf("<") > strTokenPart.lastIndexOf(">")) {
                                strTokenPart = strTokenPart.substring(0, strTokenPart.lastIndexOf("<"));
                                iLen = strTokenPart.length();
                            }
                            if (g != null) {
                                g.drawString(strTokenPart, x, y);
                            }
                            if (vStrings != null) {
                                vStrings.addElement(bAppendLineFeed != false ? strTokenPart + "\n" : strTokenPart);
                            }
                            y += fm.getHeight();
                            if (iLen < token.length()) continue;
                            bNeedToDrawLastToken = false;
                            break;
                        } while (fm.stringWidth(token = token.substring(strTokenPart.length())) > iWidth);
                    }
                }
                strLine = bNeedToDrawLastToken != false ? "" : strLine.concat(token);
            }
            if (bAppendLineFeed && !vStrings.isEmpty() && (strLast = vStrings.lastElement()).endsWith("\n")) {
                vStrings.setElementAt(strLast.substring(0, strLast.length() - 1), vStrings.size() - 1);
            }
            var17_23 = vStrings;
            return var17_23;
        }
        finally {
            if (bClip) {
                g.setClip(MessageDisplay.SCRATCH_RECT);
            }
        }
    }

    public static Frame frameForComponent(Component comp) {
        for (Component p = comp; p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    public static Window windowForComponent(Component comp) {
        for (Component p = comp; p != null; p = p.getParent()) {
            if (!(p instanceof Window)) continue;
            return (Window)p;
        }
        return null;
    }

    public static Robot getRobot() {
        if (g_robot == null) {
            try {
                g_robot = new Robot();
            }
            catch (AWTException e) {
                throw new RuntimeException(e);
            }
        }
        return g_robot;
    }

    public static void clipCursor(Rectangle rcScreen) {
        if (rcScreen == null || rcScreen.isEmpty()) {
            if (g_clipCursorListener != null) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(g_clipCursorListener);
                g_clipCursorListener = null;
            }
            g_rcClipCursor = null;
            return;
        }
        g_clipCursorListener = new ClipCursorHandler();
        g_rcClipCursor = rcScreen;
        Toolkit.getDefaultToolkit().addAWTEventListener(g_clipCursorListener, 32L);
    }

    public static boolean clipPoint(Point pt) {
        if (g_rcClipCursor == null || g_rcClipCursor.contains(pt)) {
            return false;
        }
        if (pt.x < StudioUtilities.g_rcClipCursor.x) {
            pt.x = StudioUtilities.g_rcClipCursor.x;
        }
        if (pt.x >= StudioUtilities.g_rcClipCursor.x + StudioUtilities.g_rcClipCursor.width) {
            pt.x = StudioUtilities.g_rcClipCursor.x + StudioUtilities.g_rcClipCursor.width - 1;
        }
        if (pt.y < StudioUtilities.g_rcClipCursor.y) {
            pt.y = StudioUtilities.g_rcClipCursor.y;
        }
        if (pt.y >= StudioUtilities.g_rcClipCursor.y + StudioUtilities.g_rcClipCursor.height) {
            pt.y = StudioUtilities.g_rcClipCursor.y + StudioUtilities.g_rcClipCursor.height - 1;
        }
        StudioUtilities.getRobot().mouseMove(pt.x, pt.y);
        return true;
    }

    public static Dimension boundDimensionWithin(Dimension preferredSize, Dimension minimumSize, Dimension maxSize) {
        return StudioUtilities.boundWithMax(maxSize, StudioUtilities.boundWithMin(minimumSize, preferredSize));
    }

    private static Dimension boundWithMin(Dimension minimumSize, Dimension preferredSize) {
        if (minimumSize == null) {
            return preferredSize;
        }
        if (preferredSize == null) {
            return minimumSize;
        }
        return new Dimension(Math.max(preferredSize.width, minimumSize.width), Math.max(preferredSize.height, minimumSize.height));
    }

    private static Dimension boundWithMax(Dimension maxSize, Dimension preferredSize) {
        if (maxSize == null) {
            return preferredSize;
        }
        if (preferredSize == null) {
            return maxSize;
        }
        return new Dimension(Math.min(preferredSize.width, maxSize.width), Math.min(preferredSize.height, maxSize.height));
    }

    public static void invalidateTree(Component component) {
        component.invalidate();
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                StudioUtilities.invalidateTree(child);
            }
        }
    }

    public static <T> T findAncestor(Component start, Class<T> aClass) {
        if (start == null) {
            return null;
        }
        return StudioUtilities.findAtOrAbove(start.getParent(), aClass);
    }

    public static <T> T findAtOrAbove(Component start, Class<T> aClass) {
        for (Component comp = start; comp != null; comp = comp.getParent()) {
            if (!aClass.isInstance(comp)) continue;
            return (T)comp;
        }
        return null;
    }

    public static void ensureWindowIsVisible(Window w) {
        int width = w.getWidth();
        int height = w.getHeight();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = w.getGraphicsConfiguration();
        Insets screenInsets = toolkit.getScreenInsets(gc);
        Rectangle screenSize = gc.getBounds();
        w.setLocation(Math.max(screenInsets.left, Math.min(w.getX(), screenSize.width - screenInsets.right - width)), Math.max(screenInsets.top, Math.min(w.getY(), screenSize.height - screenInsets.bottom - height)));
    }

    public static void hideToolTip(JComponent c) {
        try {
            Method hideMethod = ToolTipManager.class.getDeclaredMethod("hide", JComponent.class);
            hideMethod.setAccessible(true);
            hideMethod.invoke((Object)ToolTipManager.sharedInstance(), c);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void convertRectangleToScreen(Rectangle rectangle, Component component) {
        Point loc = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(loc, component);
        rectangle.setLocation(loc);
    }

    public static Rectangle getPrimaryMonitorScreenRect() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gds = ge.getScreenDevices();
        BasicGosuEditor frame = RunMe.getEditorFrame();
        Rectangle foundBounds = null;
        if (frame != null) {
            Rectangle windowBounds = frame.getBounds();
            for (GraphicsDevice gd : gds) {
                Rectangle bounds = gd.getDefaultConfiguration().getBounds();
                if (!bounds.contains(windowBounds.getX(), windowBounds.getY())) continue;
                foundBounds = bounds;
                break;
            }
        }
        if (foundBounds == null) {
            foundBounds = gds[0].getDefaultConfiguration().getBounds();
        }
        return foundBounds;
    }

    public static Point getXYForDialogRelativeToStudioFrame(int width, int height) {
        Rectangle screenRect = StudioUtilities.getPrimaryMonitorScreenRect();
        return new Point((int)(screenRect.getX() + (screenRect.getWidth() - (double)width) / 2.0), (int)(screenRect.getY() + (screenRect.getHeight() - (double)height) / 2.0));
    }

    public static void mapCancelKeystroke(JDialog dialog, Action cancelAction) {
        Object key = dialog.getRootPane().getInputMap(1).get(KeyStroke.getKeyStroke(27, 0));
        if (key == null) {
            key = "Cancel";
            dialog.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), key);
        }
        dialog.getRootPane().getActionMap().put(key, cancelAction);
    }

    public static List<String> filterStrings(Collection<? extends CharSequence> collection, String filter) {
        return StudioUtilities.filterStrings(collection, filter, false);
    }

    public static List<String> filterStrings(Collection<? extends CharSequence> collection, String filter, boolean showChoicesIfEmpty) {
        int iDotIndex;
        if (filter == null) {
            filter = "";
        }
        if ((iDotIndex = filter.lastIndexOf(46)) >= 0) {
            filter = filter.substring(iDotIndex + 1);
        }
        ArrayList<String> filteredTypes = new ArrayList<String>();
        if (showChoicesIfEmpty || filter.length() > 0) {
            int iFlags = 0;
            if (filter.length() > 0 && filter.indexOf(42) < 0 && Character.isUpperCase(filter.charAt(0))) {
                filter = StudioUtilities.camelCasePrefix(filter);
            } else {
                iFlags = 66;
            }
            filter = filter.replaceAll("\\*", "\\.\\*");
            filter = filter.replaceAll("\\#", "\\*");
            boolean bHasDot = filter.indexOf(126) >= 0;
            filter = filter.replaceAll("~", "(\\\\.|\u2024)");
            boolean exactMatch = filter.endsWith(" ");
            filter = filter.trim();
            try {
                Pattern pattern = Pattern.compile('^' + filter + (exactMatch ? "" : (filter.startsWith(".*") ? "" : ".*")), iFlags);
                for (CharSequence charSequence : collection) {
                    String strType = charSequence.toString();
                    String strName = bHasDot ? strType : StudioUtilities.getRelativeTypeName(strType);
                    boolean shouldAdd = exactMatch ? pattern.matcher(strName).matches() : pattern.matcher(strName).find();
                    if (!shouldAdd) continue;
                    filteredTypes.add(strType);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return filteredTypes;
    }

    private static String camelCasePrefix(String strPrefix) {
        StringBuilder sb = new StringBuilder();
        for (int i = strPrefix.length() - 1; i >= 0; --i) {
            char c = strPrefix.charAt(i);
            sb.insert(0, c);
            if (i == 0 || !Character.isUpperCase(c)) continue;
            sb.insert(0, "[^A-Z]#");
        }
        return sb.toString();
    }

    private static String getRelativeTypeName(String strType) {
        int iIndex = strType.lastIndexOf(46);
        if (iIndex > 0) {
            return strType.substring(iIndex + 1);
        }
        return strType;
    }

    public static void htmlEncode(StringBuilder sb) {
        block6: for (int i = 0; i < sb.length(); ++i) {
            char ch = sb.charAt(i);
            switch (ch) {
                case '<': {
                    sb.replace(i, i + 1, "&lt;");
                    i += 3;
                    continue block6;
                }
                case '>': {
                    sb.replace(i, i + 1, "&gt;");
                    i += 3;
                    continue block6;
                }
                case '&': {
                    sb.replace(i, i + 1, "&amp;");
                    i += 4;
                    continue block6;
                }
                case '\"': {
                    sb.replace(i, i + 1, "&quot;");
                    i += 5;
                }
            }
        }
    }

    static {
        RCTEXT = new Rectangle();
        SHOULDPAINT_RECT = new Rectangle();
        SHOULDPAINT_RECT_IN = new Rectangle();
    }

    static final class WaitCursorRunner {
        private static final WaitCursorRunner WAIT_CURSOR_RUNNER = new WaitCursorRunner();
        private WeakHashMap<JRootPane, RefCounter> _waitCursorMap = new WeakHashMap();
        private WeakHashMap<Component, JRootPane> _rootPaneMap = new WeakHashMap();
        private boolean _bWait;
        private WeakReference<Component> _c;

        private WaitCursorRunner() {
        }

        static Component showWaitCursor(boolean bWait) {
            if (!EventQueue.isDispatchThread()) {
                return null;
            }
            WaitCursorRunner.WAIT_CURSOR_RUNNER._bWait = bWait;
            WaitCursorRunner.WAIT_CURSOR_RUNNER._c = null;
            return WAIT_CURSOR_RUNNER.run();
        }

        static void showWaitCursor(boolean bWait, Component c) {
            if (!EventQueue.isDispatchThread()) {
                return;
            }
            WaitCursorRunner.WAIT_CURSOR_RUNNER._bWait = bWait;
            WaitCursorRunner.WAIT_CURSOR_RUNNER._c = new WeakReference<Component>(c);
            WAIT_CURSOR_RUNNER.run();
        }

        public Component run() {
            Window win;
            JRootPane rootPane;
            if (this._c != null && (rootPane = this._rootPaneMap.get(this._c.get())) != null) {
                this.showWaitCursorNow(this._bWait, rootPane);
                return rootPane;
            }
            Window focus = this._c == null ? StudioUtilities.getActiveWindow() : (Component)this._c.get();
            JRootPane rootPane2 = StudioUtilities.rootPaneForComponent(focus = focus == null ? StudioUtilities.getFocusedWindow() : focus);
            if (rootPane2 == null && (rootPane2 = StudioUtilities.rootPaneForComponent(focus = (focus = StudioUtilities.getActiveWindow()) == null ? StudioUtilities.getFocusedWindow() : focus)) == null) {
                return null;
            }
            if (!this._bWait && !rootPane2.isShowing() && (win = StudioUtilities.windowForComponent(rootPane2)) != null && (win = win.getOwner()) != null) {
                rootPane2 = StudioUtilities.rootPaneForComponent(win);
            }
            this._rootPaneMap.put(focus, rootPane2);
            this.showWaitCursorNow(this._bWait, rootPane2);
            return rootPane2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void showWaitCursorNow(boolean bWait, JRootPane rootPane) {
            if (rootPane == null) {
                return;
            }
            RefCounter refCounter = this._waitCursorMap.get(rootPane);
            try {
                Component glassPane = rootPane.getGlassPane();
                if (bWait && refCounter == null) {
                    Cursor cursorWait = Cursor.getPredefinedCursor(3);
                    rootPane.setCursor(cursorWait);
                    glassPane.setCursor(cursorWait);
                    glassPane.setVisible(true);
                    glassPane.invalidate();
                    refCounter = new RefCounter();
                    this._waitCursorMap.put(rootPane, refCounter);
                } else if (!(bWait || refCounter != null && refCounter._iRefCount != 1)) {
                    Cursor cursorDefault = Cursor.getPredefinedCursor(0);
                    glassPane.setVisible(false);
                    glassPane.setCursor(cursorDefault);
                    rootPane.setCursor(cursorDefault);
                    glassPane.invalidate();
                    this._waitCursorMap.remove(rootPane);
                }
                if (refCounter == null) return;
                refCounter._iRefCount = refCounter._iRefCount + (bWait ? 1 : -1);
            }
            catch (Exception e) {
                try {
                    EditorUtilities.handleUncaughtException(e);
                    if (refCounter == null) return;
                    refCounter._iRefCount = refCounter._iRefCount + (bWait ? 1 : -1);
                }
                catch (Throwable throwable) {
                    if (refCounter == null) throw throwable;
                    refCounter._iRefCount = refCounter._iRefCount + (bWait ? 1 : -1);
                    if (refCounter._iRefCount >= 0) throw throwable;
                    this._waitCursorMap.remove(rootPane);
                    throw throwable;
                }
                if (refCounter._iRefCount >= 0) return;
                this._waitCursorMap.remove(rootPane);
                return;
            }
            if (refCounter._iRefCount >= 0) return;
            this._waitCursorMap.remove(rootPane);
            return;
        }

        static final class RefCounter {
            public int _iRefCount;

            RefCounter() {
            }
        }
    }

    static final class ClipCursorHandler
    implements AWTEventListener {
        ClipCursorHandler() {
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            if (e instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)e;
                switch (me.getID()) {
                    case 503: 
                    case 506: {
                        Component comp = me.getComponent();
                        if (comp == null) break;
                        Point pt = me.getPoint();
                        SwingUtilities.convertPointToScreen(pt, comp);
                        if (!StudioUtilities.clipPoint(pt)) break;
                        me.consume();
                        break;
                    }
                }
            }
        }
    }
}

