/*
 * Decompiled with CFR 0.152.
 */
package editor.tabpane;

import editor.IValuePopup;
import editor.search.StudioUtilities;
import editor.tabpane.ITab;
import editor.tabpane.TabContainer;
import editor.tabpane.TabListCellRenderer;
import editor.util.ContainerMoverSizer;
import editor.util.ContainerSizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class TabListPopup
extends JPopupMenu
implements IValuePopup {
    private JPanel _pane = new JPanel();
    private JList _list;
    private EventListenerList _nodeListenerList = new EventListenerList();
    private TabContainer _tabContainer;

    public TabListPopup(TabContainer tabContainer) {
        this._tabContainer = tabContainer;
        this.initLayout();
    }

    protected void initLayout() {
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        GridBagLayout gridBag = new GridBagLayout();
        this._pane.setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        CompoundBorder border = BorderFactory.createCompoundBorder(UIManager.getBorder("PopupMenu.border"), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ContainerMoverSizer content = new ContainerMoverSizer(border);
        content.setLayout(new BorderLayout());
        List tabs = this.getTabs();
        int iY = 0;
        if (tabs != null && tabs.size() > 0) {
            c.anchor = 17;
            c.fill = 2;
            c.gridx = 0;
            c.gridy = iY++;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            JLabel labelTitle = new JLabel("Open Views");
            this._pane.add((Component)labelTitle, c);
        }
        this._list = new JList(new TabListModel(tabs));
        this._list.addMouseListener(new TabListListener());
        this._list.setCellRenderer(new TabListCellRenderer());
        this._list.getSelectionModel().setSelectionMode(0);
        this._list.setVisibleRowCount(10);
        JScrollPane scrollPane = new JScrollPane(this._list);
        scrollPane.setBorder(UIManager.getBorder("TextField.border"));
        c.anchor = 10;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this._pane.add((Component)scrollPane, c);
        content.add((Component)this._pane, "Center");
        this.add(content);
        JPanel sizerPanel = new JPanel(new BorderLayout());
        sizerPanel.add((Component)new JPanel(), "Center");
        sizerPanel.add((Component)new ContainerSizer(), "East");
        content.add((Component)sizerPanel, "South");
    }

    @Override
    public void setVisible(boolean bVisible) {
        super.setVisible(bVisible);
        if (bVisible) {
            StudioUtilities.removePopupBorder(this);
        }
    }

    @Override
    public void addNodeChangeListener(ChangeListener l) {
        this._nodeListenerList.add(ChangeListener.class, l);
    }

    public void removeNodeChangeListener(ChangeListener l) {
        this._nodeListenerList.remove(ChangeListener.class, l);
    }

    protected void fireNodeChanged(final EventListenerList list, final ChangeEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TabListPopup.this.fireNodeChangedNow(list, e);
            }
        });
    }

    protected void fireNodeChangedNow(EventListenerList list, ChangeEvent e) {
        Object[] listeners = list.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    private List getTabs() {
        List<ITab> tabs = Arrays.asList(this._tabContainer.getTabs());
        Collections.sort(tabs, new TabComparator());
        return tabs;
    }

    private static class TabComparator
    implements Comparator {
        private TabComparator() {
        }

        public int compare(Object o1, Object o2) {
            String code1 = ((ITab)o1).getLabel().getDisplayName();
            String code2 = ((ITab)o2).getLabel().getDisplayName();
            try {
                int iCode1 = Integer.parseInt(code1);
                int iCode2 = Integer.parseInt(code2);
                return iCode1 > iCode2 ? 1 : (iCode1 < iCode2 ? -1 : 0);
            }
            catch (NumberFormatException nfe) {
                return code1.compareToIgnoreCase(code2);
            }
        }
    }

    class TabListModel
    extends AbstractListModel {
        List _tabs;

        TabListModel(List tabs) {
            this._tabs = tabs;
        }

        @Override
        public int getSize() {
            return this._tabs.size();
        }

        @Override
        public Object getElementAt(int i) {
            return this._tabs.size() == 0 ? null : this._tabs.get(i);
        }
    }

    class TabListListener
    extends MouseAdapter {
        TabListListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int iIndex = TabListPopup.this._list.locationToIndex(e.getPoint());
            if (iIndex < 0) {
                return;
            }
            TabListPopup.this._list.setSelectedIndex(iIndex);
            ITab tab = (ITab)TabListPopup.this._list.getSelectedValue();
            TabListPopup.this.fireNodeChanged(TabListPopup.this._nodeListenerList, new ChangeEvent(tab));
            TabListPopup.this.setVisible(false);
        }
    }
}

