/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.BasicGosuEditor;
import editor.GosuPanel;
import editor.RunMe;
import editor.util.Experiment;
import editor.util.PlatformUtil;
import editor.util.ScreenUtil;
import editor.util.SystemColorFilter;
import editor.util.TaskQueue;
import editor.util.TypeNameUtil;
import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.fs.IResource;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.gs.ITemplateType;
import gw.lang.reflect.java.IJavaType;
import gw.util.GosuStringUtil;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicArrowButton;

public class EditorUtilities {
    static final HashMap<String, ImageIcon> ICON_TABLE = new HashMap();
    public static final Color ACTIVE_CAPTION = new Color(210, 235, 251);
    public static final Color ACTIVE_CAPTION_TEXT = Color.black;
    public static final Color CONTROL = new Color(240, 240, 240);
    public static final Color CONTROL_DARKSHADOW = new Color(105, 105, 105);
    public static final Color CONTROL_HIGHLIGHT = new Color(227, 227, 227);
    public static final Color CONTROL_LIGHT = Color.white;
    public static final Color CONTROL_SHADOW = new Color(160, 160, 160);
    public static final Color CONTROL_TEXT = Color.black;
    public static final Color TOOLTIP_BACKGROUND = new Color(255, 255, 225);
    public static final Color TOOLTIP_TEXT = Color.black;
    public static final Color WINDOW = new Color(252, 252, 252);
    public static final Color WINDOW_TEXT = Color.black;
    public static final Color WINDOW_BORDER = new Color(100, 100, 100);
    public static final Color TEXT_HIGHLIGHT = new Color(51, 153, 255);
    public static final Color TEXT_HIGHLIGHT_TEXT = Color.white;
    public static final Color TEXT_TEXT = Color.black;
    public static final Color XP_BORDER_COLOR = new Color(49, 106, 197);
    public static final Color XP_HIGHLIGHT_TOGGLE_COLOR = new Color(225, 230, 232);
    public static final Color XP_HIGHLIGHT_COLOR = ACTIVE_CAPTION;
    public static final Color XP_HIGHLIGHT_SELECTED_COLOR = new Color(152, 179, 219);
    private static final String BACKGROUND_QUEUE_NAME = "backgroundTasks";

    public static void doBackgroundOp(final Runnable run) {
        TaskQueue backgroundQueue = EditorUtilities.getBackgroundQueue();
        if (backgroundQueue != null) {
            backgroundQueue.postTask(new Runnable(){

                @Override
                public void run() {
                    run.run();
                }
            });
        } else {
            run.run();
        }
    }

    private static TaskQueue getBackgroundQueue() {
        return TaskQueue.getInstance(BACKGROUND_QUEUE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void settleBackgroundOps() {
        TaskQueue backgroundQueue = EditorUtilities.getBackgroundQueue();
        if (backgroundQueue != null) {
            Object wait;
            Object object = wait = new Object();
            synchronized (object) {
                EditorUtilities.doBackgroundOp(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = wait;
                        synchronized (object) {
                            wait.notifyAll();
                        }
                    }
                });
                try {
                    wait.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static void removePopupBorder(final Container c) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Container p = c; p != null; p = p.getParent()) {
                    if (!(p instanceof JComponent)) continue;
                    ((JComponent)p).setBorder(null);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void centerWindowInFrame(Component window, Window frame) {
        Point ptOffset;
        Dimension dimCenter;
        block5: {
            if (frame != null) {
                if ((!(frame instanceof Frame) || ((Frame)frame).getState() != 1) && frame.isShowing()) {
                    dimCenter = frame.getSize();
                    ptOffset = frame.getLocation();
                    break block5;
                } else {
                    EditorUtilities.centerWindowInFrame(window, null);
                    return;
                }
            }
            Window owner = SwingUtilities.getWindowAncestor(window);
            if (owner != null && owner.isShowing() && owner.getMinimumSize().height < owner.getHeight()) {
                if ((!(owner instanceof Frame) || ((Frame)owner).getState() != 1) && owner.isShowing()) {
                    Dimension dimCenter2 = owner.getSize();
                    Point ptOffset2 = owner.getLocation();
                    window.setLocation(ptOffset2.x + (dimCenter2.width - window.getWidth()) / 2, ptOffset2.y + (dimCenter2.height - window.getHeight()) / 2);
                }
                return;
            }
            Rectangle screenRect = EditorUtilities.getPrimaryMonitorScreenRect();
            dimCenter = new Dimension((int)screenRect.getWidth(), (int)screenRect.getHeight());
            ptOffset = new Point((int)screenRect.getX(), (int)screenRect.getY());
        }
        window.setLocation(ptOffset.x + (dimCenter.width - window.getWidth()) / 2, ptOffset.y + (dimCenter.height - window.getHeight()) / 2);
    }

    public static Rectangle getPrimaryMonitorScreenRect() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gds = ge.getScreenDevices();
        return gds[0].getConfigurations()[0].getBounds();
    }

    public static ImageIcon loadIcon(String strRes) {
        if (strRes == null || strRes.length() == 0) {
            return null;
        }
        ImageIcon icon = ICON_TABLE.get(strRes);
        if (icon == null && !strRes.contains(" | ")) {
            try {
                URL resource = EditorUtilities.class.getClassLoader().getResource(strRes);
                if (resource != null) {
                    icon = new ImageIcon(resource);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (icon != null) {
                ICON_TABLE.put(strRes, icon);
            }
        }
        return icon;
    }

    public static Icon findIcon(File fileOrDir) {
        IType type;
        if (fileOrDir.isDirectory()) {
            if (RunMe.getEditorFrame().getGosuPanel().getExperimentView().getExperiment().getSourcePath().contains(fileOrDir.getAbsolutePath())) {
                return EditorUtilities.loadIcon("images/srcfolder.png");
            }
            return EditorUtilities.loadIcon("images/folder.png");
        }
        String classNameForFile = TypeNameUtil.getClassNameForFile(fileOrDir);
        if (classNameForFile != null && (type = TypeSystem.getByFullNameIfValid((String)classNameForFile)) != null) {
            return EditorUtilities.findIcon(type);
        }
        return FileSystemView.getFileSystemView().getSystemIcon(fileOrDir);
    }

    public static Icon findIcon(IType type) {
        if (type instanceof IGosuClass) {
            if (type.isInterface()) {
                if (((IGosuClass)type).isStructure()) {
                    return EditorUtilities.findIcon(ClassType.Structure);
                }
                if (((IGosuClass)type).isAnnotation()) {
                    return EditorUtilities.findIcon(ClassType.Annotation);
                }
                return EditorUtilities.findIcon(ClassType.Interface);
            }
            if (type instanceof ITemplateType) {
                return EditorUtilities.findIcon(ClassType.Template);
            }
            if (type instanceof IGosuEnhancement) {
                return EditorUtilities.findIcon(ClassType.Enhancement);
            }
            if (type instanceof IGosuProgram) {
                return EditorUtilities.findIcon(ClassType.Program);
            }
            if (type.isEnum()) {
                return EditorUtilities.findIcon(ClassType.Enum);
            }
            return EditorUtilities.findIcon(ClassType.Class);
        }
        if (type instanceof IJavaType) {
            return EditorUtilities.loadIcon("images/javaclass.png");
        }
        return EditorUtilities.loadIcon("images/empty16x16.gif");
    }

    public static Icon findIcon(ClassType classType) {
        switch (classType) {
            case Class: {
                return EditorUtilities.loadIcon("images/class.png");
            }
            case Enum: {
                return EditorUtilities.loadIcon("images/enum.png");
            }
            case Interface: {
                return EditorUtilities.loadIcon("images/interface.png");
            }
            case Structure: {
                return EditorUtilities.loadIcon("images/structure.png");
            }
            case Annotation: {
                return EditorUtilities.loadIcon("images/annotation.png");
            }
            case Enhancement: {
                return EditorUtilities.loadIcon("images/Enhancement.png");
            }
            case Program: {
                return EditorUtilities.loadIcon("images/program.png");
            }
            case Template: {
                return EditorUtilities.loadIcon("images/template.png");
            }
        }
        return null;
    }

    public static void handleUncaughtException(Throwable e) {
        EditorUtilities.handleUncaughtException("", e);
    }

    public static void handleUncaughtException(String s, Throwable e) {
        System.out.println(s);
        e.printStackTrace();
    }

    public static void settleEventQueue() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while (eventQueue.peekEvent() != null) {
            try {
                AWTEvent event = Toolkit.getDefaultToolkit().getSystemEventQueue().getNextEvent();
                Object src = event.getSource();
                if (event instanceof ActiveEvent) {
                    ((ActiveEvent)((Object)event)).dispatch();
                    continue;
                }
                if (src instanceof Component) {
                    ((Component)src).dispatchEvent(event);
                    continue;
                }
                if (!(src instanceof MenuComponent)) continue;
                ((MenuComponent)src).dispatchEvent(event);
            }
            catch (Throwable e) {
                EditorUtilities.handleUncaughtException("", e);
            }
        }
    }

    public static Clipboard getClipboard() {
        return RunMe.getEditorFrame().getGosuPanel().getClipboard();
    }

    public static Frame frameForComponent(Component comp) {
        for (Component p = comp; p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    public static String buildFunctionIntellisenseString(boolean bFeatureLiteralCompletion, IFunctionType functionType) {
        StringBuilder sb = new StringBuilder();
        String rawName = functionType.getDisplayName();
        sb.append(rawName);
        sb.append("(");
        EditorUtilities.buildArgListFromType(functionType, sb, true, bFeatureLiteralCompletion);
        sb.append(")");
        return sb.toString();
    }

    private static void buildArgListFromType(IFunctionType functionType, StringBuilder sb, boolean topLevel, boolean bFeatureLiteralCompletion) {
        IType[] parameters = functionType.getParameterTypes();
        HashSet<String> generatedNames = new HashSet<String>();
        for (int i = 0; i < parameters.length; ++i) {
            String name;
            if (i != 0) {
                sb.append(",");
            }
            sb.append(" ");
            IType paramType = parameters[i];
            if (bFeatureLiteralCompletion) {
                sb.append(paramType.getRelativeName());
                continue;
            }
            if (topLevel && paramType instanceof IFunctionType) {
                IFunctionType blockType = (IFunctionType)paramType;
                sb.append("\\");
                EditorUtilities.buildArgListFromType(blockType, sb, false, bFeatureLiteralCompletion);
                sb.append("-> ");
                continue;
            }
            if (functionType.getMethodInfo() != null) {
                IParameterInfo info = functionType.getMethodInfo().getParameters()[i];
                name = info.getName();
            } else {
                name = EditorUtilities.createUniqueParamNameFromType(paramType, generatedNames);
            }
            sb.append(GosuStringUtil.uncapitalize((String)name));
        }
        if (parameters.length > 0) {
            sb.append(" ");
        }
    }

    private static String createUniqueParamNameFromType(IType paramType, HashSet<String> generatedNames) {
        String initialName = paramType.getRelativeName();
        if (!GosuStringUtil.isAlphanumeric((String)initialName.substring(0, 1))) {
            initialName = paramType.getDisplayName();
        }
        initialName = initialName.substring(0, 1);
        String name = initialName = initialName.toLowerCase();
        int j = 2;
        while (generatedNames.contains(name)) {
            name = initialName + j;
            ++j;
        }
        generatedNames.add(name);
        return name;
    }

    public static JButton createArrowButton() {
        return new BasicArrowButton(5, UIManager.getColor("ComboBox.buttonBackground"), UIManager.getColor("ComboBox.buttonShadow"), UIManager.getColor("ComboBox.buttonDarkShadow"), UIManager.getColor("ComboBox.buttonHighlight"));
    }

    public static Window getWindow() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
    }

    public static Image createSystemColorImage(Image i) {
        SystemColorFilter filter = new SystemColorFilter();
        FilteredImageSource prod = new FilteredImageSource(i.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    public static void displayInformation(String strMsg) {
        EditorUtilities.displayMessageBox(strMsg, 1, false);
    }

    public static void displayError(Throwable e) {
        EditorUtilities.displayMessageBox(e == null ? "Error performing operation." : e.getMessage(), 0, false);
    }

    public static void displayError(String strMsg) {
        EditorUtilities.displayMessageBox(strMsg, 0, false);
    }

    public static void displayWarning(String strMsg) {
        EditorUtilities.displayMessageBox(strMsg, 2, false);
    }

    public static void displayMessageBox(String strMsg, final int iType, boolean bWrapText) {
        final String strWrappedMsg = bWrapText ? EditorUtilities.wrapText(strMsg) : strMsg;
        Runnable logMsgBox = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(EditorUtilities.getWindow(), strWrappedMsg, "", iType);
            }
        };
        if (EventQueue.isDispatchThread()) {
            logMsgBox.run();
        } else {
            try {
                EventQueue.invokeAndWait(logMsgBox);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static String wrapText(String strText) {
        return EditorUtilities.wrapText(strText, 60);
    }

    public static String wrapText(String strText, int iLineLen) {
        StringBuilder sb = new StringBuilder();
        while (strText != null) {
            if (strText.length() > iLineLen) {
                sb.append(strText.substring(0, 60)).append("\n");
                strText = strText.substring(60);
                continue;
            }
            sb.append(strText);
            strText = null;
        }
        return sb.toString();
    }

    public static void convertRectangleToScreen(Rectangle rectangle, Component component) {
        Point loc = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(loc, component);
        rectangle.setLocation(loc);
    }

    public static List<String> filterStrings(Collection<? extends CharSequence> collection, String filter) {
        int iDotIndex;
        if (filter != null && (iDotIndex = filter.lastIndexOf(46)) >= 0) {
            filter = filter.substring(iDotIndex + 1);
        }
        ArrayList<String> filteredTypes = new ArrayList<String>();
        if (filter != null && filter.length() > 0) {
            int iFlags = 0;
            if (filter.indexOf(42) < 0 && Character.isUpperCase(filter.charAt(0))) {
                filter = EditorUtilities.camelCasePrefix(filter);
            } else {
                iFlags = 2;
            }
            filter = filter.replaceAll("\\*", "\\.\\*");
            filter = filter.replaceAll("\\#", "\\*");
            boolean bHasDot = filter.indexOf(126) >= 0;
            filter = filter.replaceAll("~", "(\\\\.|\u2024)");
            try {
                Pattern pattern = Pattern.compile(filter + (filter.startsWith(".*") ? "" : ".*"), iFlags);
                for (CharSequence charSequence : collection) {
                    String strType = charSequence.toString();
                    String strName = bHasDot ? strType : EditorUtilities.getRelativeTypeName(strType);
                    if (!pattern.matcher(strName).find()) continue;
                    filteredTypes.add(strType);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return filteredTypes;
    }

    private static String camelCasePrefix(String strPrefix) {
        StringBuilder sb = new StringBuilder();
        for (int i = strPrefix.length() - 1; i >= 0; --i) {
            char c = strPrefix.charAt(i);
            sb.insert(0, c);
            if (i == 0 || !Character.isUpperCase(c)) continue;
            sb.insert(0, "[^A-Z]#");
        }
        return sb.toString();
    }

    private static String getRelativeTypeName(String strType) {
        int iIndex = strType.lastIndexOf(46);
        if (iIndex > 0) {
            return strType.substring(iIndex + 1);
        }
        return strType;
    }

    public static void hideToolTip(JComponent c) {
        try {
            Method hideMethod = ToolTipManager.class.getDeclaredMethod("hide", JComponent.class);
            hideMethod.setAccessible(true);
            hideMethod.invoke((Object)ToolTipManager.sharedInstance(), c);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JRootPane rootPaneForComponent(Component comp) {
        for (Component p = comp; p != null; p = p.getParent()) {
            if (p instanceof JRootPane) {
                return (JRootPane)p;
            }
            if (comp instanceof JFrame) {
                return ((JFrame)comp).getRootPane();
            }
            if (comp instanceof JDialog) {
                return ((JDialog)comp).getRootPane();
            }
            if (!(comp instanceof JWindow)) continue;
            return ((JWindow)comp).getRootPane();
        }
        return null;
    }

    public static void invokeInDispatchThread(Runnable task) {
        if (task == null) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            task.run();
        } else {
            try {
                EventQueue.invokeAndWait(task);
            }
            catch (Throwable t) {
                EditorUtilities.handleUncaughtException(t);
            }
        }
    }

    public static Process browse(String strURL) throws IOException {
        String strCmd = PlatformUtil.isWindows() ? "rundll32 url.dll,FileProtocolHandler " + strURL : "firefox " + strURL;
        return Runtime.getRuntime().exec(strCmd);
    }

    public static <T> T findAncestor(Component start, Class<T> aClass) {
        if (start == null) {
            return null;
        }
        return EditorUtilities.findAtOrAbove(start.getParent(), aClass);
    }

    public static <T> T findAtOrAbove(Component start, Class<T> aClass) {
        for (Component comp = start; comp != null; comp = comp.getParent()) {
            if (!aClass.isInstance(comp)) continue;
            return (T)comp;
        }
        return null;
    }

    public static File getUserFile(GosuPanel gosuPanel) {
        File file = new File(EditorUtilities.getUserGosuEditorDir(), "layout.properties");
        if (!file.isFile()) {
            Properties props = new Properties();
            props.put("experiment", EditorUtilities.makeScratchExperiment(gosuPanel).getExperimentDir().getAbsolutePath());
            try (FileWriter writer = new FileWriter(file);){
                props.store(writer, "Gosu Editor");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Experiment loadRecentExperiment(GosuPanel gosuPanel) {
        File userFile = EditorUtilities.getUserFile(gosuPanel);
        Properties props = new Properties();
        try (FileReader reader = new FileReader(userFile);){
            props.load(reader);
            EditorUtilities.restoreScreenProps(props);
            Experiment experiment = new Experiment(new File(props.getProperty("experiment")), gosuPanel);
            return experiment;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveLayoutState(Experiment experiment) {
        if (!RunMe.getEditorFrame().isVisible()) {
            return;
        }
        File userFile = EditorUtilities.getUserFile(experiment.getGosuPanel());
        try (FileWriter writer = new FileWriter(userFile);){
            Properties props = new Properties();
            props.put("experiment", experiment.getExperimentDir().getAbsolutePath());
            EditorUtilities.saveScreenProps(props);
            props.store(writer, "Gosu Editor");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void saveScreenProps(Map<String, String> props) {
        BasicGosuEditor frame = RunMe.getEditorFrame();
        boolean maximized = (frame.getExtendedState() & 6) == 6;
        props.put("Frame.Maximized", String.valueOf(maximized));
        Rectangle bounds = frame.getRestoreBounds();
        if (bounds != null) {
            ScreenUtil.convertToPercentageOfScreenWidth(bounds);
            props.put("Frame.Bounds.X", String.valueOf(bounds.x));
            props.put("Frame.Bounds.Y", String.valueOf(bounds.y));
            props.put("Frame.Bounds.Width", String.valueOf(bounds.width));
            props.put("Frame.Bounds.Height", String.valueOf(bounds.height));
        }
    }

    private static void restoreScreenProps(Map<String, String> props) {
        Integer height;
        Integer width;
        Integer y;
        BasicGosuEditor frame = RunMe.getEditorFrame();
        boolean bSet = false;
        Integer x = EditorUtilities.readInteger(props, "Frame.Bounds.X");
        if (x != null && (y = EditorUtilities.readInteger(props, "Frame.Bounds.Y")) != null && (width = EditorUtilities.readInteger(props, "Frame.Bounds.Width")) != null && (height = EditorUtilities.readInteger(props, "Frame.Bounds.Height")) != null) {
            Rectangle bounds = new Rectangle(x, y, width, height);
            ScreenUtil.convertFromPercentageOfScreenWidth(bounds);
            frame.setBounds(bounds);
            frame.setRestoreBounds(bounds);
            bSet = true;
        }
        if (!bSet) {
            EditorUtilities.setInitialFrameBounds(RunMe.getEditorFrame());
        }
        if (Boolean.valueOf(props.get("Frame.Maximized")) == Boolean.TRUE) {
            frame.setExtendedState(6);
        }
    }

    private static Integer readInteger(Map<String, String> props, String prop) {
        String value = props.get(prop);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    private static void setInitialFrameBounds(Frame frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = screenSize.width * 2 / 3;
        int height = width * 2 / 3;
        frame.setSize(width, height);
        EditorUtilities.centerWindowInFrame(frame, frame);
    }

    public static File getUserGosuEditorDir() {
        File gosuDir = new File(System.getProperty("user.home"), ".GosuLab");
        gosuDir.mkdirs();
        return gosuDir;
    }

    public static File getStockExperimentsDir() {
        File gosuDir = new File(System.getProperty("user.home") + File.separator + ".GosuLab" + File.separator + "experiments");
        EditorUtilities.copyExampleExperiments(EditorUtilities.getStockExamplesDir());
        return gosuDir;
    }

    private static void copyExampleExperiments(File gosuDir) {
        URL marker = EditorUtilities.class.getClassLoader().getResource("examples/marker.txt");
        try {
            IDirectory examplesDir = CommonServices.getFileSystem().getIFile(marker).getParent();
            EditorUtilities.copyExamples((IResource)examplesDir, gosuDir);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyExamples(IResource from, File to) {
        if (from instanceof IDirectory) {
            if (!to.getName().equals("examples") && to.exists()) {
                return;
            }
            if (!to.exists() && !to.mkdirs()) {
                System.out.println("Failed to create experiment directory: " + to.getAbsolutePath());
            }
            for (IDirectory child : ((IDirectory)from).listDirs()) {
                EditorUtilities.copyExamples((IResource)child, new File(to, child.getName()));
            }
            for (IDirectory child : ((IDirectory)from).listFiles()) {
                EditorUtilities.copyExamples((IResource)child, new File(to, child.getName()));
            }
        } else {
            try {
                int len;
                InputStream in = ((IFile)from).openInputStream();
                FileOutputStream out = new FileOutputStream(to);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                in.close();
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static File getStockExamplesDir() {
        File gosuDir = new File(System.getProperty("user.home") + File.separator + ".GosuLab" + File.separator + "examples");
        gosuDir.mkdirs();
        return gosuDir;
    }

    public static List<File> getStockExampleExperiments() {
        ArrayList<File> experiments = new ArrayList<File>();
        File experimentsDir = EditorUtilities.getStockExamplesDir();
        for (File dir : experimentsDir.listFiles()) {
            File experimentFile;
            if (!dir.isDirectory() || (experimentFile = EditorUtilities.findExperimentFile(dir)) == null) continue;
            experiments.add(dir);
        }
        return experiments;
    }

    public static File findExperimentFile(File dir) {
        for (File f : dir.listFiles()) {
            if (!f.getName().equalsIgnoreCase(dir.getName() + ".prj")) continue;
            return f;
        }
        return null;
    }

    private static Experiment makeScratchExperiment(GosuPanel gosuPanel) {
        File experimentDir = new File(EditorUtilities.getStockExperimentsDir(), "Scratch");
        return new Experiment(experimentDir, gosuPanel);
    }

    public static void openFileOrDir(File file) {
        try {
            File parent;
            if (file.isDirectory()) {
                parent = file;
                file = null;
            } else {
                if (!file.exists()) {
                    return;
                }
                parent = (file = file.getAbsoluteFile()).getParentFile();
                if (parent == null) {
                    return;
                }
            }
            EditorUtilities.doOpen(parent, file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void doOpen(File dir, File toSelect) throws IOException {
        if (PlatformUtil.isWindows()) {
            String cmd = toSelect != null ? "explorer /select," + toSelect.getAbsolutePath() : "explorer /root," + dir.getAbsolutePath();
            Runtime.getRuntime().exec(cmd);
            return;
        }
        if (PlatformUtil.isMac()) {
            if (toSelect != null) {
                String script = String.format("tell application \"Finder\"\n\treveal {\"%s\"} as POSIX file\n\tactivate\nend tell", toSelect.getAbsolutePath());
                Runtime.getRuntime().exec(new String[]{"/usr/bin/osascript", "-e", script});
            } else {
                Runtime.getRuntime().exec(new String[]{"open", dir.getAbsolutePath()});
            }
            return;
        }
        String path = dir.getAbsolutePath();
        if (PlatformUtil.hasXdgOpen()) {
            Runtime.getRuntime().exec(new String[]{"/usr/bin/xdg-open", path});
        } else if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            Desktop.getDesktop().open(new File(path));
        } else {
            JOptionPane.showMessageDialog(RunMe.getEditorFrame(), "This action isn't supported on the current platform", "Cannot Open File", 0);
        }
    }

    public static void delete(File fileOrDir) {
        if (fileOrDir.isDirectory()) {
            for (File f : fileOrDir.listFiles()) {
                if (f.isDirectory()) {
                    EditorUtilities.delete(f);
                    continue;
                }
                f.delete();
            }
        }
        fileOrDir.delete();
    }

    public static ImageIcon loadLabIcon() {
        return EditorUtilities.loadIcon("images/project4.png");
    }
}

