/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import gw.util.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TaskQueue
extends Thread {
    private static final HashMap<String, TaskQueue> QUEUE_MAP = new HashMap();
    private ILogger _logger;
    private final LinkedList<Runnable> _queue;
    private boolean _shutdown = false;

    private TaskQueue(ILogger logger, String strName) {
        super(strName);
        this._logger = logger;
        this._queue = new LinkedList();
        this.setPriority(3);
    }

    public static TaskQueue getInstance(String strQueueName) {
        return TaskQueue.getInstance(null, strQueueName);
    }

    public static TaskQueue getInstance(ILogger logger, String strQueueName) {
        if (strQueueName == null) {
            return null;
        }
        TaskQueue taskQueue = QUEUE_MAP.get(strQueueName);
        if (taskQueue == null) {
            taskQueue = new TaskQueue(logger, strQueueName);
            QUEUE_MAP.put(strQueueName, taskQueue);
        }
        return taskQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void emptyAndRemoveQueue(String strQueueName) {
        TaskQueue taskQueue = QUEUE_MAP.get(strQueueName);
        if (taskQueue != null) {
            taskQueue.emptyQueue();
            LinkedList<Runnable> linkedList = taskQueue._queue;
            synchronized (linkedList) {
                taskQueue._shutdown = true;
                taskQueue._queue.notifyAll();
            }
            QUEUE_MAP.remove(strQueueName);
        }
    }

    public static void killAll() {
        ArrayList<TaskQueue> taskQueues = new ArrayList<TaskQueue>(QUEUE_MAP.values());
        for (TaskQueue taskQueue : taskQueues) {
            TaskQueue.emptyAndRemoveQueue(taskQueue.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postTask(Runnable task) {
        LinkedList<Runnable> linkedList = this._queue;
        synchronized (linkedList) {
            this._queue.add(task);
            if (!this.isAlive()) {
                this.start();
            }
            this._queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilAllCurrentTasksFinish() {
        final Object lock = new Object();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    lock.notifyAll();
                }
            }
        };
        Object object = lock;
        synchronized (object) {
            this.postTask(runnable);
            try {
                lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable peekTask() {
        LinkedList<Runnable> linkedList = this._queue;
        synchronized (linkedList) {
            return this._queue.isEmpty() ? null : this._queue.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Runnable> getTasks() {
        LinkedList<Runnable> linkedList = this._queue;
        synchronized (linkedList) {
            return (List)this._queue.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emptyQueue() {
        LinkedList<Runnable> linkedList = this._queue;
        synchronized (linkedList) {
            this._queue.clear();
        }
    }

    public int size() {
        return this._queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this._shutdown) {
            try {
                Runnable task;
                LinkedList<Runnable> linkedList = this._queue;
                synchronized (linkedList) {
                    while (this._queue.isEmpty()) {
                        if (this._shutdown) {
                            return;
                        }
                        this._queue.wait();
                    }
                    task = this._queue.get(0);
                    this._queue.notifyAll();
                }
                try {
                    task.run();
                }
                catch (Exception t) {
                    this.log(t);
                }
                linkedList = this._queue;
                synchronized (linkedList) {
                    if (this._queue.size() > 0) {
                        this._queue.removeFirst();
                    }
                }
            }
            catch (Exception t) {
                this.log(t);
            }
        }
    }

    protected void log(Throwable t) {
        if (this._logger == null) {
            t.printStackTrace();
        } else {
            this._logger.warn((Object)"Error running job.", t);
        }
    }

    public static boolean hasWork() {
        for (TaskQueue taskQueue : QUEUE_MAP.values()) {
            if (taskQueue.peekTask() == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postTaskAndWait(final Runnable runnable, long timeout) {
        if (Thread.currentThread() == this) {
            throw new IllegalStateException("Cannot postTaskAndWait from within the TaskQueue thread");
        }
        final Object wait = new Object();
        Runnable waitForTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                runnable.run();
                Object object = wait;
                synchronized (object) {
                    wait.notify();
                }
            }
        };
        Object object = wait;
        synchronized (object) {
            this.postTask(waitForTask);
            try {
                if (timeout < 0L) {
                    wait.wait();
                } else {
                    wait.wait(timeout);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void postTaskAndWait(Runnable runnable) {
        this.postTaskAndWait(runnable, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTasks(Class taskClass) {
        LinkedList<Runnable> linkedList = this._queue;
        synchronized (linkedList) {
            Iterator<Runnable> iterator = this.getTasks().iterator();
            while (iterator.hasNext()) {
                Runnable task = iterator.next();
                if (!taskClass.isInstance(task)) continue;
                iterator.remove();
            }
        }
    }

    public void setILogger(final ILogger logger) {
        this.postTask(new Runnable(){

            @Override
            public void run() {
                TaskQueue.this._logger = logger;
            }
        });
    }
}

