/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.util.EditorUtilities;
import gw.util.GosuObjectUtil;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;

public class XPToolbarButton
extends JButton {
    private static final int DEFAULT_MARGIN = 2;
    private boolean _bConstantBorder;

    public XPToolbarButton(String text, Icon icon, final int iMargin) {
        super(text, icon);
        this.setUI(BasicButtonUI.createUI(this));
        this.setBorderPainted(false);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.setBackground(EditorUtilities.CONTROL);
        this.setContentAreaFilled(false);
        this.setOpaque(true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                XPToolbarButton.this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(EditorUtilities.XP_BORDER_COLOR), BorderFactory.createEmptyBorder(iMargin, iMargin, iMargin, iMargin)));
                XPToolbarButton.this.setBackground(EditorUtilities.CONTROL);
            }
        });
        this.addMouseListener(this.createMouseListener());
        this.setToolTipText("");
    }

    protected MouseListener createMouseListener() {
        return new MouseAdapter(){
            Color _bkColor;

            @Override
            public void mouseEntered(MouseEvent e) {
                if (XPToolbarButton.this.isEnabled()) {
                    this._bkColor = XPToolbarButton.this.getBackground();
                    XPToolbarButton.this.setBorderPainted(true);
                    if (XPToolbarButton.this.getModel().isArmed()) {
                        XPToolbarButton.this.setBackground(EditorUtilities.XP_HIGHLIGHT_SELECTED_COLOR);
                    } else {
                        XPToolbarButton.this.setBackground(EditorUtilities.XP_HIGHLIGHT_COLOR);
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                XPToolbarButton.this.setBorderPainted(XPToolbarButton.this.isBorderConstant());
                XPToolbarButton.this.setBackground(this._bkColor != null ? this._bkColor : EditorUtilities.CONTROL);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                XPToolbarButton.this.setBackground(EditorUtilities.XP_HIGHLIGHT_SELECTED_COLOR);
            }
        };
    }

    public XPToolbarButton(String text, Icon icon) {
        this(text, icon, 2);
    }

    public XPToolbarButton(Icon icon, int iMargin) {
        this(null, icon, iMargin);
    }

    public XPToolbarButton(Icon icon) {
        this(icon, 2);
    }

    public XPToolbarButton(String text) {
        this(text, null);
    }

    public XPToolbarButton() {
        this(null, null);
    }

    @Override
    public void setVisible(boolean bVisible) {
        super.setVisible(bVisible);
        JComponent separator = (JComponent)this.getClientProperty("_separatorComp");
        if (separator != null) {
            separator.setVisible(bVisible);
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.setBorderPainted(this.isBorderConstant());
    }

    public XPToolbarButton(Action action) {
        this();
        this.setAction(action);
    }

    @Override
    public String getToolTipText() {
        String superText = super.getToolTipText();
        if (superText == null || superText.length() == 0) {
            return null;
        }
        if (this.getAction() != null) {
            return GosuObjectUtil.toString((Object)this.getAction().getValue("ShortDescription"));
        }
        return superText;
    }

    public boolean isBorderConstant() {
        return this._bConstantBorder;
    }

    public void setBorderConstant(boolean bConstantBorder) {
        this._bConstantBorder = bConstantBorder;
        this.setBorderPainted(this._bConstantBorder);
    }
}

