/*
 * Decompiled with CFR 0.152.
 */
package editor.util.transform.java.visitor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SymbolTable {
    private LinkedList<Scope> globals;
    private LinkedList<Scope> locals;
    private HashSet<String> reservedWords;
    int counter = 0;
    private String[] reserved = new String[]{"true", "false", "NaN", "Infinity", "and", "or", "not", "null", "length", "exists", "in", "startswith", "contains", "where", "find", "var", "delegate", "represents", "as", "typeof", "statictypeof", "typeis", "typeas", "package", "uses", "if", "else", "except", "unless", "foreach", "for", "index", "iterator", "while", "do", "continue", "break", "return", "construct", "function", "property", "get", "set", "try", "catch", "finally", "this", "throw", "new", "switch", "case", "default", "eval", "private", "internal", "protected", "public", "abstract", "override", "hide", "final", "static", "extends", "transient", "implements", "readonly", "class", "interface", "structure", "enum", "super", "outer", "execution", "request", "session", "application", "void", "block", "enhancement", "classpath", "typeloader", "using", "now"};

    public SymbolTable() {
        this.globals = new LinkedList();
        this.locals = new LinkedList();
        this.reservedWords = new HashSet();
        for (String word : this.reserved) {
            this.reservedWords.add(word);
        }
    }

    void pushGlobalScope(String clazz) {
        this.globals.add(new Scope(clazz));
    }

    void pushLocalScope() {
        this.locals.add(new Scope());
    }

    public String convertLocalSymbol(String ident) {
        String converted = null;
        for (int end = this.locals.size() - 1; end >= 0; --end) {
            Scope s = this.locals.get(end);
            converted = s.conversions.get(ident);
            if (converted != null) break;
        }
        return converted == null ? ident : converted;
    }

    String addLocally(String ident) {
        Scope last;
        String original = ident;
        int i = 0;
        while (this.isDefinedLocally(ident) || this.isDefinedGlobally(ident) || this.isReserved(ident)) {
            ident = original + "_" + i;
            ++i;
        }
        try {
            last = this.locals.getLast();
        }
        catch (NoSuchElementException ex) {
            throw new RuntimeException("Error: adding a new identifier in an empty scope.Have you forgotten to pushNewScope() first?");
        }
        last.idents.add(ident);
        if (!original.equals(ident)) {
            last.conversions.put(original, ident);
        }
        return ident;
    }

    private boolean isReserved(String ident) {
        return this.reservedWords.contains(ident);
    }

    void popLocalScope() {
        try {
            this.locals.removeLast();
        }
        catch (NoSuchElementException ex) {
            throw new RuntimeException("Error: the scope's stack is empty.Have you forgotten to pushNewScope() first?");
        }
    }

    void popGlobalScope() {
        try {
            this.globals.removeLast();
        }
        catch (NoSuchElementException ex) {
            throw new RuntimeException("Error: the scope's stack is empty.Have you forgotten to pushNewScope() first?");
        }
    }

    private boolean isDefinedLocally(String ident) {
        for (int end = this.locals.size() - 1; end >= 0; --end) {
            Scope s = this.locals.get(end);
            if (!s.idents.contains(ident)) continue;
            return true;
        }
        return false;
    }

    private boolean isDefinedGlobally(String ident) {
        for (int end = this.globals.size() - 1; end >= 0; --end) {
            Scope s = this.globals.get(end);
            if (!s.idents.contains(ident)) continue;
            return true;
        }
        return false;
    }

    public int getClassLevelFromCurrent(String clazz) {
        int end;
        int level = end = this.globals.size() - 1;
        while (end >= 0) {
            Scope s = this.globals.get(end);
            if (s.clazz.equals(clazz)) {
                level -= end;
                break;
            }
            --end;
        }
        return level;
    }

    public String addGlobally(String ident) {
        Scope last;
        try {
            last = this.globals.getLast();
        }
        catch (NoSuchElementException ex) {
            throw new RuntimeException("Error: adding a new identifier in an empty scope.Have you forgotten to pushNewScope() first?");
        }
        last.idents.add(ident);
        return ident;
    }

    private class Scope {
        String clazz;
        Set<String> idents;
        Map<String, String> conversions;

        Scope() {
            this.idents = new HashSet<String>();
            this.conversions = new HashMap<String, String>();
        }

        Scope(String clazz) {
            this.clazz = clazz;
            this.idents = new HashSet<String>();
            this.conversions = new HashMap<String, String>();
        }
    }
}

