/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractGotoPopup;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.gs.IGosuClassTypeInfo;
import gw.lang.reflect.gs.IGosuConstructorInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class ClassStructureViewPopupDelegate {
    public static final List<IFeatureInfo> EMPTY_LIST = Collections.emptyList();

    ClassStructureViewPopupDelegate() {
    }

    public static List<IFeatureInfo> filter(IGosuClassTypeInfo typeInfo, String prefix) {
        assert (prefix != null);
        AlphabeticalFeatureInfoComparator comparator = new AlphabeticalFeatureInfoComparator();
        ArrayList propertyInfos = new ArrayList(typeInfo.getProperties((IType)typeInfo.getGosuClass()));
        Collections.sort(propertyInfos, comparator);
        ArrayList constructorInfos = new ArrayList(typeInfo.getConstructors((IType)typeInfo.getGosuClass()));
        Collections.sort(constructorInfos, comparator);
        MethodList methodInfos = typeInfo.getMethods((IType)typeInfo.getGosuClass());
        Collections.sort(methodInfos, comparator);
        String lowerCasePrefix = prefix.toLowerCase();
        ArrayList<IFeatureInfo> featureInfos = new ArrayList<IFeatureInfo>();
        for (IPropertyInfo propertyInfo : propertyInfos) {
            if (!ClassStructureViewPopupDelegate.matches(typeInfo, (IAttributedFeatureInfo)propertyInfo, lowerCasePrefix)) continue;
            featureInfos.add((IFeatureInfo)propertyInfo);
        }
        for (IGosuConstructorInfo constructorInfo : constructorInfos) {
            if (!ClassStructureViewPopupDelegate.matches(typeInfo, (IAttributedFeatureInfo)constructorInfo, lowerCasePrefix)) continue;
            featureInfos.add((IFeatureInfo)constructorInfo);
        }
        for (IMethodInfo methodInfo : methodInfos) {
            if (!ClassStructureViewPopupDelegate.matches(typeInfo, (IAttributedFeatureInfo)methodInfo, lowerCasePrefix)) continue;
            featureInfos.add((IFeatureInfo)methodInfo);
        }
        return featureInfos;
    }

    private static boolean matches(IGosuClassTypeInfo typeInfo, IAttributedFeatureInfo featureInfo, String prefix) {
        return featureInfo.getName().toLowerCase().startsWith(prefix) && !featureInfo.getName().startsWith("@") && featureInfo.getOwnersType() == typeInfo.getGosuClass();
    }

    public static class FeatureModel
    extends AbstractGotoPopup.AbstractPopupListModel<IFeatureInfo> {
        private List<IFeatureInfo> _allFeatures;

        public FeatureModel(List<IFeatureInfo> allFeatures) {
            this._allFeatures = allFeatures;
        }

        @Override
        public int getSize() {
            return this._allFeatures.size();
        }

        @Override
        public IFeatureInfo getElementAt(int i) {
            return this._allFeatures.get(i);
        }
    }

    public static class AlphabeticalFeatureInfoComparator
    implements Comparator<IFeatureInfo> {
        @Override
        public int compare(IFeatureInfo o1, IFeatureInfo o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

