/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.ExperimentTreeContextMenu;
import editor.FileTree;
import editor.FileTreeCellRenderer;
import editor.splitpane.CollapsibleSplitPane;
import editor.tabpane.TabPane;
import editor.tabpane.TabPosition;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import editor.util.XPToolbarButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.MatteBorder;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ExperimentView
extends JPanel {
    private Experiment _experiment;
    private JTree _tree;
    private JPanel _examplesList;
    private JPanel _examplesListNorth;
    private CollapsibleSplitPane _splitPane;
    private JScrollPane _scroller;

    public ExperimentView() {
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this._splitPane = new CollapsibleSplitPane(1, new JPanel(), this.makeExamplesList());
        this.add((Component)this._splitPane, "Center");
        this._splitPane.setPosition(70);
    }

    private JComponent makeExamplesList() {
        this._examplesList = new JPanel();
        this._examplesList.setLayout(new BorderLayout());
        this._examplesList.add((Component)new JPanel(), "Center");
        this._examplesListNorth = new JPanel(new GridLayout(0, 1));
        this._examplesList.add((Component)this._examplesListNorth, "North");
        EventQueue.invokeLater(this::addExamples);
        this._examplesList.setBorder(null);
        JScrollPane scrollPane = new JScrollPane(this._examplesList);
        scrollPane.getVerticalScrollBar().setUnitIncrement(22);
        scrollPane.setBorder(null);
        TabPane tabPane = new TabPane(TabPosition.TOP, 5);
        tabPane.addTab("Examples", null, scrollPane);
        return tabPane;
    }

    public void load(Experiment experiment) {
        this._splitPane.clearTop();
        this._experiment = experiment;
        DefaultTreeModel model = new DefaultTreeModel(new FileTree(this.getExperiment()));
        this._tree = new JTree(model);
        this._tree.setBackground(EditorUtilities.WINDOW);
        this._tree.setShowsRootHandles(true);
        this._tree.setRowHeight(22);
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.setVisibleRowCount(20);
        this._tree.setCellRenderer(new FileTreeCellRenderer(this._tree));
        this._tree.addMouseListener(new TreeMouseHandler());
        this._tree.addKeyListener(new TreeKeyHankder());
        this._scroller = new JScrollPane(this._tree);
        this._scroller.setBorder(new MatteBorder(0, 0, 1, 1, EditorUtilities.CONTROL_SHADOW));
        this.expandToFirstSourcePath(0, this._tree.getRowCount());
        this._splitPane.setTop(this._scroller);
        this.revalidate();
    }

    private void addExamples() {
        List<File> examples = EditorUtilities.getStockExampleExperiments();
        for (File dir : examples) {
            XPToolbarButton item = new XPToolbarButton(dir.getName(), EditorUtilities.loadLabIcon());
            item.setHorizontalAlignment(2);
            item.addActionListener(e -> this.getExperiment().getGosuPanel().openExperiment(dir));
            this._examplesListNorth.add(item);
        }
    }

    public JTree getTree() {
        return this._tree;
    }

    public Experiment getExperiment() {
        return this._experiment;
    }

    private void expandToFirstSourcePath(int startingIndex, int rowCount) {
        FileTree fileTree = (FileTree)this._tree.getPathForRow(startingIndex).getLastPathComponent();
        if (fileTree.getParent() != null && fileTree.getParent().isSourcePathRoot()) {
            this._tree.expandRow(startingIndex);
            return;
        }
        for (int i = startingIndex; i < rowCount; ++i) {
            this._tree.expandRow(i);
        }
        if (this._tree.getRowCount() != rowCount) {
            this.expandToFirstSourcePath(rowCount, this._tree.getRowCount());
        }
    }

    private void expandAll(int startingIndex, int rowCount) {
        for (int i = startingIndex; i < rowCount; ++i) {
            this._tree.expandRow(i);
        }
        if (this._tree.getRowCount() != rowCount) {
            this.expandAll(rowCount, this._tree.getRowCount());
        }
    }

    public FileTree getSelectedTree() {
        return (FileTree)this._tree.getLastSelectedPathComponent();
    }

    private class TreeKeyHankder
    implements KeyListener {
        private TreeKeyHankder() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            FileTree selection;
            if (e.getKeyCode() == 127 && (selection = ExperimentView.this.getSelectedTree()) != null && selection.canDelete()) {
                selection.delete();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private class TreeMouseHandler
    implements MouseListener {
        private TreeMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            FileTree fileTree;
            TreePath selectionPath;
            if (e.getClickCount() == 2 && (selectionPath = ExperimentView.this._tree.getSelectionPath()) != null && (fileTree = (FileTree)selectionPath.getLastPathComponent()).isFile()) {
                if (fileTree.getType() != null) {
                    ExperimentView.this._experiment.getGosuPanel().openFile(fileTree.getFileOrDir());
                } else {
                    EditorUtilities.openFileOrDir(fileTree.getFileOrDir());
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleContextMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handleContextMenu(e);
        }

        private void handleContextMenu(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int row = ExperimentView.this._tree.getRowForLocation(e.getX(), e.getY());
                TreePath path = ExperimentView.this._tree.getPathForLocation(e.getX(), e.getY());
                ExperimentView.this._tree.setSelectionPath(path);
                if (row > -1) {
                    ExperimentView.this._tree.setSelectionRow(row);
                    EventQueue.invokeLater(() -> new ExperimentTreeContextMenu(ExperimentView.this.getExperiment()).displayContextMenu(ExperimentView.this._tree, e.getX(), e.getY(), (Component)ExperimentView.this._tree));
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

