/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GosuEditor;
import editor.IdentifierTextField;
import editor.util.EditorUtilities;
import editor.util.TextComponentUtil;
import gw.lang.parser.IExpression;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IStatement;
import gw.lang.parser.expressions.IProgram;
import gw.lang.parser.statements.IClassFileStatement;
import gw.lang.parser.statements.IFunctionStatement;
import gw.lang.parser.statements.INoOpStatement;
import gw.lang.parser.statements.IPropertyStatement;
import gw.util.GosuRefactorUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ExtractVariablePopup
extends JDialog {
    private IdentifierTextField _varName;
    private GosuEditor _gosuEditor;
    private JCheckBox _replaceAll;
    private JButton _okBtn;
    private static final String CLOSE = "_close";
    private static final String OK = "_ok";
    private JButton _cancelBtn;

    public ExtractVariablePopup() throws HeadlessException {
        this.setLayout(new GridBagLayout());
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), CLOSE);
        this.getRootPane().getActionMap().put(CLOSE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractVariablePopup.this._cancelBtn.doClick();
            }
        });
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), OK);
        this.getRootPane().getActionMap().put(OK, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractVariablePopup.this._okBtn.doClick();
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(4, 4, 4, 4);
        constraints.ipadx = 2;
        constraints.ipady = 2;
        constraints.anchor = 23;
        this._varName = new IdentifierTextField();
        constraints.gridx = 0;
        constraints.gridy = 0;
        JLabel nameLabel = new JLabel("Name");
        nameLabel.setDisplayedMnemonic('N');
        nameLabel.setLabelFor(this._varName);
        this.add((Component)nameLabel, constraints);
        ++constraints.gridx;
        this._varName.setColumns(20);
        this._varName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExtractVariablePopup.this._okBtn.setEnabled(ExtractVariablePopup.this._varName.getText().length() > 0);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExtractVariablePopup.this._okBtn.setEnabled(ExtractVariablePopup.this._varName.getText().length() > 0);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.add((Component)this._varName, constraints);
        this._replaceAll = new JCheckBox();
        constraints.gridwidth = 2;
        this._replaceAll = new JCheckBox("Replace All Occurences");
        constraints.anchor = 10;
        ++constraints.gridy;
        constraints.gridx = 0;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1, 4, 0));
        this._okBtn = new JButton(new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractVariablePopup.extractVariable(ExtractVariablePopup.this._gosuEditor, ExtractVariablePopup.this._varName.getText(), ExtractVariablePopup.this._replaceAll.isSelected());
                ExtractVariablePopup.this.setVisible(false);
            }
        });
        this._okBtn.setEnabled(false);
        this._cancelBtn = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractVariablePopup.this.setVisible(false);
            }
        });
        buttonPanel.add(this._okBtn);
        buttonPanel.add(this._cancelBtn);
        this.add((Component)buttonPanel, constraints);
        this.pack();
        this.setModal(true);
        this.setTitle("Extract Variable");
        this.setResizable(false);
    }

    static void extractVariable(GosuEditor gosuEditor, String varName, boolean replaceAll) {
        IParsedElement rootScopeElement = ExtractVariablePopup.findValidRootScopeElement(gosuEditor);
        if (rootScopeElement == null) {
            throw new IllegalStateException("Unable to extract a variable outside of a function or program");
        }
        if (!ExtractVariablePopup.verifyExpressionSelected(gosuEditor)) {
            throw new IllegalStateException("Unable to extract a variable unless an expression is selected");
        }
        gosuEditor.getUndoManager().beginUndoAtom("Extract Variable");
        try {
            int lineStart;
            String entireProgram = gosuEditor.getText();
            Document document = gosuEditor.getEditor().getDocument();
            int start = gosuEditor.getEditor().getSelectionStart();
            int end = gosuEditor.getEditor().getSelectionEnd() - 1;
            IParseTree deepestLocation = gosuEditor.getDeepestLocationSpanning(start, end);
            int varInsertionPoint = deepestLocation.getOffset();
            String selectedText = document.getText(varInsertionPoint, deepestLocation.getLength());
            boolean standaloneExpression = deepestLocation.getParsedElement().getParent() instanceof INoOpStatement;
            if (!replaceAll) {
                if (standaloneExpression) {
                    document.remove(varInsertionPoint, selectedText.length());
                } else {
                    ExtractVariablePopup.replaceStringInDocument(document, varInsertionPoint, selectedText, varName);
                }
            }
            String varString = "";
            while (!(deepestLocation.getParsedElement() instanceof IStatement)) {
                deepestLocation = deepestLocation.getParent();
            }
            if (!standaloneExpression) {
                int i = lineStart = TextComponentUtil.getLineStart(entireProgram, deepestLocation.getOffset());
                while (Character.isWhitespace(entireProgram.charAt(i))) {
                    varString = varString + entireProgram.charAt(i);
                    ++i;
                }
            } else {
                lineStart = varInsertionPoint;
            }
            varString = varString + "var " + varName + " = " + selectedText + (standaloneExpression ? "" : "\n");
            document.insertString(lineStart, varString, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        finally {
            gosuEditor.getUndoManager().endUndoAtom();
            gosuEditor.parse();
        }
    }

    private static void replaceStringInDocument(Document document, int position, String textToReplace, String replacementText) throws BadLocationException {
        document.remove(position, textToReplace.length());
        document.insertString(position, replacementText, null);
    }

    private static IParsedElement findValidRootScopeElement(GosuEditor gosuEditor) {
        IStatement list;
        int start = gosuEditor.getEditor().getSelectionStart();
        IParsedElement rootContainerElement = GosuRefactorUtil.boundingParent((List)gosuEditor.getParser().getLocations(), (int)start, (Class[])new Class[]{IProgram.class, IClassFileStatement.class, IFunctionStatement.class, IPropertyStatement.class});
        if (rootContainerElement == null) {
            return null;
        }
        if (rootContainerElement instanceof IProgram || rootContainerElement instanceof IClassFileStatement) {
            return rootContainerElement;
        }
        ArrayList stmtList = new ArrayList();
        boolean eltFound = rootContainerElement.getContainedParsedElementsByType(IStatement.class, stmtList);
        if (eltFound && (list = (IStatement)stmtList.get(0)).getLocation().contains(start)) {
            return list;
        }
        return null;
    }

    public void showNow(GosuEditor gosuEditor) {
        this._gosuEditor = gosuEditor;
        IParsedElement rootScopeElement = ExtractVariablePopup.findValidRootScopeElement(this._gosuEditor);
        if (rootScopeElement == null) {
            EditorUtilities.displayError("Unable to extract a variable");
            return;
        }
        boolean validExprSelected = ExtractVariablePopup.verifyExpressionSelected(this._gosuEditor);
        if (!validExprSelected) {
            EditorUtilities.displayError("Cannot extract a variable unless a valid expression is selected");
            return;
        }
        EditorUtilities.centerWindowInFrame(this, SwingUtilities.getWindowAncestor(gosuEditor));
        this.setVisible(true);
    }

    private static boolean verifyExpressionSelected(GosuEditor gosuEditor) {
        int end;
        int start = gosuEditor.getEditor().getSelectionStart();
        IParseTree deepestLocation = gosuEditor.getDeepestLocationSpanning(start, end = gosuEditor.getEditor().getSelectionEnd() - 1);
        if (deepestLocation.getParsedElement() instanceof IExpression) {
            if (deepestLocation.getOffset() == start && deepestLocation.getExtent() == end) {
                return true;
            }
            try {
                if (deepestLocation.getOffset() == start && deepestLocation.getExtent() == end - 1 && gosuEditor.getEditor().getText(end, 1).equals(";")) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }
}

