/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.util.EditorUtilities;
import editor.util.IModalHandler;
import editor.util.ModalEventQueue;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;

class GosuEventQueue
extends ModalEventQueue {
    private static GosuEventQueue INSTANCE;
    private String[] _args;
    private long _lErrMsgTime;
    private final List<Runnable> _idleListeners;

    public static GosuEventQueue instance() {
        if (INSTANCE == null) {
            INSTANCE = new GosuEventQueue(new String[0]);
        }
        return INSTANCE;
    }

    private GosuEventQueue(String[] args) {
        super(new ModalHandler());
        this._args = args;
        this._idleListeners = new ArrayList<Runnable>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdleListener(Runnable l) {
        List<Runnable> list = this._idleListeners;
        synchronized (list) {
            this._idleListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeIdleListener(Runnable l) {
        List<Runnable> list = this._idleListeners;
        synchronized (list) {
            return this._idleListeners.remove(l);
        }
    }

    @Override
    protected void handleUncaughtException(Throwable t) {
        if (System.currentTimeMillis() - this._lErrMsgTime > 5000L) {
            EditorUtilities.handleUncaughtException(t);
        }
        this._lErrMsgTime = System.currentTimeMillis();
    }

    @Override
    public void dispatchEvent(AWTEvent event) {
        super.dispatchEvent(event);
        this.checkForIdleTime();
    }

    private void checkForIdleTime() {
        try {
            if (Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent() == null) {
                this.handleIdleTasks();
            }
        }
        catch (Exception t) {
            this.handleUncaughtException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIdleTasks() {
        List<Runnable> list = this._idleListeners;
        synchronized (list) {
            for (Runnable r : this._idleListeners) {
                try {
                    r.run();
                }
                catch (Exception e) {
                    this.handleUncaughtException(e);
                }
            }
        }
    }

    private static class ModalHandler
    implements IModalHandler {
        private ModalHandler() {
        }

        @Override
        public boolean isModal() {
            return true;
        }
    }
}

