/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.ListPopup;
import editor.RangeCellRenderer;
import editor.RangeModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;

public class RangePopup
extends ListPopup {
    private static final String NAME = "Name";

    public RangePopup(JTextComponent editor) {
        super(editor, new RangeModel());
    }

    public RangePopup(JTextComponent editor, RangeModel model) {
        super(editor, model);
    }

    @Override
    protected JPanel getSortedByPanel() {
        JPanel sortPanel = new JPanel();
        sortPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        sortPanel.setLayout(new BoxLayout(sortPanel, 0));
        sortPanel.add(new JLabel("Sort by"));
        JToggleButton btnSortByName = new JToggleButton(NAME);
        btnSortByName.setSelected(true);
        btnSortByName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((RangeModel)RangePopup.this.getModel()).setSortByName(true);
                RangePopup.this.refresh();
            }
        });
        sortPanel.add(btnSortByName);
        return sortPanel;
    }

    @Override
    protected ListCellRenderer makeCellRenderer() {
        return new RangeCellRenderer((RangeModel)this._model, this.getJList());
    }
}

