/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.BasicGosuEditor;
import editor.GosuEditorPlatformHelper;
import editor.SplashScreen;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import editor.util.SettleModalEventQueue;
import gw.config.CommonServices;
import gw.config.IPlatformHelper;
import gw.config.IService;
import gw.lang.Gosu;
import gw.lang.gosuc.GosucModule;
import gw.lang.init.GosuInitialization;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.module.IExecutionEnvironment;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class RunMe {
    private static BasicGosuEditor _gosuEditor;
    private static GosuInitialization _gosuInitialization;

    public static void main(String[] args) throws Exception {
        RunMe.launchEditor();
    }

    public static BasicGosuEditor getEditorFrame() {
        return _gosuEditor;
    }

    public static void launchEditor() throws Exception {
        EventQueue.invokeLater(() -> {
            SplashScreen.instance().setFeedbackText("Initializing...");
            _gosuEditor = BasicGosuEditor.create();
            _gosuEditor.restoreState(EditorUtilities.loadRecentExperiment(_gosuEditor.getGosuPanel()));
            SettleModalEventQueue.instance().run();
            SplashScreen.instance().dispose();
            _gosuEditor.showMe();
        });
    }

    public static void reinitializeGosu(Experiment experiment) {
        CommonServices.getKernel().redefineService_Privileged(IPlatformHelper.class, (IService)new GosuEditorPlatformHelper());
        IExecutionEnvironment execEnv = TypeSystem.getExecutionEnvironment();
        _gosuInitialization = GosuInitialization.instance((IExecutionEnvironment)execEnv);
        GosucModule gosucModule = new GosucModule("_default_", experiment.getSourcePath(), RunMe.deriveClasspath(experiment), "", Collections.emptyList(), Collections.emptyList());
        _gosuInitialization.reinitializeSimpleIde(gosucModule);
    }

    private static List<String> deriveClasspath(Experiment experiment) {
        ArrayList<String> classpath = new ArrayList<String>();
        List<String> sourcePath = experiment.getSourcePath();
        for (String path : sourcePath) {
            if (path.toLowerCase().startsWith(experiment.getExperimentDir().getAbsolutePath().toLowerCase())) continue;
            classpath.add(path);
        }
        List collect = Gosu.deriveClasspathFrom(RunMe.class).stream().map(File::getAbsolutePath).collect(Collectors.toList());
        classpath.addAll(collect);
        return classpath;
    }
}

