/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractPathCompletionHandler;
import editor.GosuEditor;
import editor.InitializerCompletionHandler;
import editor.SymbolPopup;
import editor.TypePopup;
import editor.util.TextComponentUtil;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IParseTree;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.Keyword;
import gw.lang.parser.expressions.IMemberAccessExpression;
import gw.lang.reflect.java.GosuTypes;
import gw.util.GosuObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SymbolCompletionHandler
extends AbstractPathCompletionHandler {
    @Override
    public boolean handleCompletePath(ISymbolTable transientSymTable) {
        boolean isAtAsPosition;
        boolean bDotAtCaret;
        final GosuEditor gsEditor = this.getGosuEditor();
        boolean bl = bDotAtCaret = GosuObjectUtil.equals((Object)TextComponentUtil.getWordAtCaret(gsEditor.getEditor()), (Object)".") || GosuObjectUtil.equals((Object)TextComponentUtil.getWordBeforeCaret(gsEditor.getEditor()), (Object)".") || GosuObjectUtil.equals((Object)TextComponentUtil.getWordAtCaret(gsEditor.getEditor()), (Object)":") || GosuObjectUtil.equals((Object)TextComponentUtil.getWordBeforeCaret(gsEditor.getEditor()), (Object)":");
        if (bDotAtCaret) {
            return false;
        }
        IParseTree locationAtCaret = gsEditor.getDeepestLocationAtCaret();
        if (locationAtCaret != null && (locationAtCaret.getParsedElement() instanceof IMemberAccessExpression || InitializerCompletionHandler.isInitializerStart(locationAtCaret.getParsedElement()))) {
            return false;
        }
        String strMemberPath = this.getSingleNameAtCaret();
        strMemberPath = strMemberPath != null ? strMemberPath.trim() : null;
        String wordBeforeCaret = TextComponentUtil.getWordBeforeCaret(this.getGosuEditor().getEditor());
        boolean bl2 = isAtAsPosition = wordBeforeCaret != null && wordBeforeCaret.trim().equals(Keyword.KW_as.toString());
        if (gsEditor.isAltDown() || isAtAsPosition) {
            return this.displayTypesPopup(strMemberPath);
        }
        Collection<ISymbol> listSymbols = transientSymTable.getSymbols().values();
        this.filterUnwantedSymbols(listSymbols);
        ISymbol[] symbols = listSymbols.toArray(new ISymbol[listSymbols.size()]);
        SymbolPopup valuePopup = new SymbolPopup(symbols, strMemberPath, gsEditor);
        valuePopup.addNodeChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String word = (String)e.getSource();
                if (word.endsWith("()")) {
                    TextComponentUtil.replaceWordAtCaretDynamicAndRemoveEmptyParens(gsEditor.getEditor(), word, gsEditor.getReplaceWordCallback(), true);
                } else {
                    TextComponentUtil.replaceWordAtCaretDynamic(gsEditor.getEditor(), word, gsEditor.getReplaceWordCallback(), true);
                }
                gsEditor.getEditor().requestFocus();
                gsEditor.fixSwingFocusBugWhenPopupCloses();
                gsEditor.getEditor().repaint();
            }
        });
        gsEditor.setValuePopup(valuePopup);
        gsEditor.displayValuePopup();
        if (!valuePopup.isShowing() && !valuePopup.wasAutoDismissed()) {
            return this.displayTypesPopup(strMemberPath);
        }
        return false;
    }

    private void filterUnwantedSymbols(Collection<ISymbol> listSymbols) {
        ArrayList<ISymbol> deleteSyms = new ArrayList<ISymbol>();
        for (ISymbol s : listSymbols) {
            if (s.getType() == GosuTypes.DEF_CTOR_TYPE() || s instanceof IDynamicFunctionSymbol && ((IDynamicFunctionSymbol)s).isConstructor()) {
                deleteSyms.add(s);
                continue;
            }
            if (!(s instanceof IDynamicFunctionSymbol) || !s.getName().startsWith("@")) continue;
            deleteSyms.add(s);
        }
        listSymbols.removeAll(deleteSyms);
    }

    boolean displayTypesPopup(String strPrefix) {
        TypePopup popup = new TypePopup(strPrefix, this.getGosuEditor(), this.isAnnotationsOnly());
        this.getGosuEditor().setValuePopup(popup);
        final boolean addUsesAutomatically = this.getGosuEditor().acceptsUses();
        popup.addNodeChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String strQualifedType = (String)e.getSource();
                String strRelativeType = TypePopup.getRelativeTypeName(strQualifedType);
                String strPartialType = strQualifedType;
                if (strPartialType.contains(TextComponentUtil.getWordAtCaret(SymbolCompletionHandler.this.getGosuEditor().getEditor()))) {
                    strPartialType = strPartialType.substring(strPartialType.indexOf(TextComponentUtil.getWordAtCaret(SymbolCompletionHandler.this.getGosuEditor().getEditor())));
                }
                if (addUsesAutomatically) {
                    SymbolCompletionHandler.this.getGosuEditor().addToUses(strQualifedType);
                }
                if (!addUsesAutomatically || !GosuObjectUtil.equals((Object)TextComponentUtil.getWordBeforeCaret(SymbolCompletionHandler.this.getGosuEditor().getEditor()), (Object)strRelativeType)) {
                    TextComponentUtil.replaceWordAtCaretDynamic(SymbolCompletionHandler.this.getGosuEditor().getEditor(), addUsesAutomatically ? strRelativeType : strPartialType, SymbolCompletionHandler.this.getGosuEditor().getReplaceWordCallback(), false);
                }
                SymbolCompletionHandler.this.getGosuEditor().getEditor().requestFocus();
                SymbolCompletionHandler.this.getGosuEditor().fixSwingFocusBugWhenPopupCloses();
                SymbolCompletionHandler.this.getGosuEditor().getEditor().repaint();
            }
        });
        this.getGosuEditor().displayValuePopup();
        return true;
    }

    protected boolean isAnnotationsOnly() {
        return false;
    }
}

