/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.BatchDocument;
import editor.GosuEventQueue;
import editor.IColorConsole;
import gw.util.StreamUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class TextComponentWriter
extends PrintStream
implements IColorConsole {
    private BatchDocument _document;
    private PrintStream[] _echoWriters;
    private AttributeSet _attributes;
    private final SimpleAttributeSet _defaultAttributes;
    private StringBuilder _suspendedOutput = new StringBuilder();

    public TextComponentWriter(Color color, BatchDocument document, PrintStream ... echoWriters) {
        super(new NullOutputStream());
        this._document = document;
        this._echoWriters = echoWriters;
        this._defaultAttributes = new SimpleAttributeSet();
        this._defaultAttributes.addAttribute(StyleConstants.Foreground, color);
        GosuEventQueue.instance().addIdleListener(new ConsoleDrainer());
    }

    @Override
    public void print(boolean b) {
        this.print(String.valueOf(b));
    }

    @Override
    public void print(char c) {
        this.print(String.valueOf(c));
    }

    @Override
    public void print(int i) {
        this.print(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.print(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.print(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.print(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.print(String.valueOf(s));
    }

    @Override
    public synchronized void print(String strOutput) {
        this._suspendedOutput.append(strOutput);
        AttributeSet attributes = this._attributes == null ? this._defaultAttributes : this._attributes;
        this._document.appendBatchString(strOutput, attributes);
    }

    @Override
    public void print(Object obj) {
        this.print(String.valueOf(obj));
    }

    @Override
    public void println() {
        this.print("\n");
    }

    @Override
    public void println(boolean b) {
        this.println(String.valueOf(b));
    }

    @Override
    public void println(char c) {
        this.println(String.valueOf(c));
    }

    @Override
    public void println(int i) {
        this.println(String.valueOf(i));
    }

    @Override
    public void println(long l) {
        this.println(String.valueOf(l));
    }

    @Override
    public void println(float f) {
        this.println(String.valueOf(f));
    }

    @Override
    public void println(double d) {
        this.println(String.valueOf(d));
    }

    @Override
    public void println(char[] s) {
        this.println(String.valueOf(s));
    }

    @Override
    public void println(String strOutput) {
        this.print(strOutput + "\n");
    }

    @Override
    public void println(Object obj) {
        this.println(String.valueOf(obj));
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.print(StreamUtil.toString((byte[])buf, (int)off, (int)len));
    }

    @Override
    public void write(int b) {
        this.print((char)b);
    }

    @Override
    public void setAttributes(AttributeSet attributes) {
        this._attributes = attributes;
    }

    @Override
    public void suspendUpdates() {
    }

    @Override
    public void resumeUpdates() {
    }

    private class ConsoleDrainer
    implements Runnable {
        private ConsoleDrainer() {
        }

        @Override
        public synchronized void run() {
            if (TextComponentWriter.this._suspendedOutput.length() == 0) {
                return;
            }
            for (PrintStream echoWriter : TextComponentWriter.this._echoWriters) {
                echoWriter.print(TextComponentWriter.this._suspendedOutput);
                echoWriter.flush();
            }
            TextComponentWriter.this._suspendedOutput = new StringBuilder();
            TextComponentWriter.this._document.processBatchUpdates();
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

