/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.BeanMethodCallValueCompletion;
import editor.BooleanValueCompletion;
import editor.EnumerationValueCompletion;
import editor.GosuEditor;
import editor.IValueCompletionHandler;
import editor.MemberAccessValueCompletion;
import editor.NumberValueCompletion;
import editor.StringValueCompletion;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;

public class ValueCompletionIntellisense {
    private static final ValueCompletionIntellisense INSTANCE = new ValueCompletionIntellisense();
    private static final WeakHashMap<GosuEditor, List<? extends IValueCompletionHandler>> HANDLERS_BY_EDITOR = new WeakHashMap();
    private static final List<Class<? extends IValueCompletionHandler>> HANDLER_TYPES = new ArrayList<Class<? extends IValueCompletionHandler>>();

    public static ValueCompletionIntellisense instance() {
        return INSTANCE;
    }

    private ValueCompletionIntellisense() {
    }

    public boolean complete(GosuEditor gsEditor) {
        List<? extends IValueCompletionHandler> handlers = HANDLERS_BY_EDITOR.get(gsEditor);
        if (handlers == null) {
            handlers = this.initHandlers(gsEditor);
        }
        for (IValueCompletionHandler iValueCompletionHandler : handlers) {
            if (!iValueCompletionHandler.handleCompleteValue()) continue;
            return true;
        }
        return false;
    }

    private List<? extends IValueCompletionHandler> initHandlers(GosuEditor gsEditor) {
        ArrayList<IValueCompletionHandler> handlers = new ArrayList<IValueCompletionHandler>(HANDLER_TYPES.size());
        for (Class<? extends IValueCompletionHandler> type : HANDLER_TYPES) {
            try {
                IValueCompletionHandler handler = type.newInstance();
                handlers.add(handler);
                handler.setGosuEditor(gsEditor);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        HANDLERS_BY_EDITOR.put(gsEditor, handlers);
        return handlers;
    }

    static {
        HANDLER_TYPES.add(MemberAccessValueCompletion.class);
        HANDLER_TYPES.add(BeanMethodCallValueCompletion.class);
        HANDLER_TYPES.add(BooleanValueCompletion.class);
        HANDLER_TYPES.add(NumberValueCompletion.class);
        HANDLER_TYPES.add(EnumerationValueCompletion.class);
        HANDLER_TYPES.add(StringValueCompletion.class);
    }
}

