/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import editor.search.MessageDisplay;
import editor.search.RegExStringUtil;
import editor.search.SearchLocation;
import editor.search.StringUtil;
import editor.search.StudioUtilities;
import editor.undo.AtomicUndoManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataListener;
import javax.swing.undo.CompoundEdit;

public abstract class BaseLocalSearchDialog
extends JDialog {
    public static boolean g_bReplaceMode = false;
    private static final DefaultComboBoxModel g_historySearch = new DefaultComboBoxModel();
    private static final DefaultComboBoxModel g_historyReplace = new DefaultComboBoxModel();
    private static boolean g_bCaseSensitive;
    private static boolean g_bRegex;
    private JComboBox _comboSearch;
    private JComboBox _comboReplace;
    private JCheckBox _cbCaseSensitive;
    private JCheckBox _cbRegex;
    private boolean _bReplaceMode;
    private boolean _bAllMode;
    private boolean _bAllModeFromTop;
    private boolean _bStartedReplacing;
    private boolean _bDisplayNotFound;
    private String _selectedText;
    private AtomicUndoManager _undoManager;
    private CompoundEdit _undoAtom;

    public BaseLocalSearchDialog(boolean modal, boolean bReplace, String selectedText, AtomicUndoManager undoManager) {
        super((JFrame)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), bReplace ? "Replace" : "Find", modal);
        this._selectedText = selectedText;
        this._bDisplayNotFound = true;
        this._bReplaceMode = g_bReplaceMode = bReplace;
        this._undoManager = undoManager;
        this.setDefaultCloseOperation(0);
        this.configUI();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BaseLocalSearchDialog.this.dispose();
            }
        });
    }

    public static boolean canRepeatFind() {
        return g_historySearch.getSize() > 0;
    }

    public boolean isReplaceMode() {
        return this._bReplaceMode;
    }

    public void setReplaceMode(boolean bReplaceMode) {
        this._bReplaceMode = bReplaceMode;
    }

    public boolean isStartedReplacing() {
        return this._bStartedReplacing;
    }

    public void setStartedReplacing(boolean bStartedReplacing) {
        this._bStartedReplacing = bStartedReplacing;
    }

    public void repeatFind() {
        this._comboSearch.getEditor().setItem(g_historySearch.getElementAt(g_historySearch.getSize() - 1));
        this.performFind(false);
    }

    public void repeatFindBackwards() {
        this._comboSearch.getEditor().setItem(g_historySearch.getElementAt(g_historySearch.getSize() - 1));
        this.performFind(true);
    }

    private void find(final String strText, final boolean backwards) {
        this.addTextHistory(strText, g_historySearch);
        if (this.isReplaceMode()) {
            String replaceTxt = (String)this._comboReplace.getEditor().getItem();
            this.addTextHistory(replaceTxt, g_historyReplace);
            this._comboReplace.getEditor().setItem(replaceTxt);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseLocalSearchDialog.this.findNow(strText, backwards);
            }
        });
    }

    protected List findInSource(String strSource, String strPattern, int iOffset, boolean backwards) {
        if (this.isRegEx()) {
            try {
                return RegExStringUtil.search(strSource, strPattern, !this.isCaseSensitive(), iOffset, backwards);
            }
            catch (PatternSyntaxException e) {
                MessageDisplay.displayError("Invalid regular expression: " + e.getMessage());
                return Collections.emptyList();
            }
        }
        return StringUtil.search(strSource, strPattern, !this.isCaseSensitive(), iOffset, backwards);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findNow(String strText, boolean backwards) {
        if (this.isReplaceMode()) {
            this._undoAtom = null;
        }
        try {
            SearchLocation location = this.performFind(strText, backwards);
            if (location == null && this.isDisplayNotFound()) {
                if (this.isStartedReplacing()) {
                    MessageDisplay.displayInformation("Finished replacing: " + strText);
                } else {
                    MessageDisplay.displayInformation("Text: " + strText);
                }
            }
        }
        finally {
            if (this.isReplaceMode() && this._undoAtom != null) {
                AtomicUndoManager.DisplayableCompoundEdit endedAtom = null;
                while (endedAtom != this._undoAtom) {
                    endedAtom = this.getUndoManager().getUndoAtom();
                    this.getUndoManager().endUndoAtom();
                }
            }
        }
    }

    protected void startUndoIfNecessary() {
        if (this._undoAtom == null) {
            this._undoAtom = this.getUndoManager().beginUndoAtom("Replace All");
        }
    }

    private AtomicUndoManager getUndoManager() {
        return this._undoManager;
    }

    protected abstract SearchLocation performFind(String var1, boolean var2);

    public boolean isDisplayNotFound() {
        return this._bDisplayNotFound;
    }

    public void setDisplayNotFound(boolean bDisplayNotFound) {
        this._bDisplayNotFound = bDisplayNotFound;
    }

    private void saveSettings() {
        g_bCaseSensitive = this._cbCaseSensitive.isSelected();
        g_bRegex = this._cbRegex.isSelected();
    }

    private void addTextHistory(String strText, DefaultComboBoxModel model) {
        if (strText == null || strText.length() == 0) {
            return;
        }
        for (int i = 0; i < model.getSize(); ++i) {
            if (!model.getElementAt(i).equals(strText)) continue;
            model.removeElementAt(i);
        }
        model.addElement(strText);
    }

    private void initTextSettings() {
        this._cbCaseSensitive.setSelected(g_bCaseSensitive);
        this._cbRegex.setSelected(g_bRegex);
    }

    protected void configUI() {
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        contentPane.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.configTextSearchUI(mainPanel);
        contentPane.add((Component)mainPanel, "Center");
        JPanel south = new JPanel(new BorderLayout());
        south.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        JPanel filler = new JPanel();
        south.add((Component)filler, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        JButton btnFind = new JButton("Find");
        btnFind.setMnemonic('F');
        btnFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseLocalSearchDialog.this.performFind(false);
            }
        });
        this.addFindEnabler(btnFind);
        buttonPanel.add(btnFind);
        this.getRootPane().setDefaultButton(btnFind);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseLocalSearchDialog.this.close();
            }
        });
        buttonPanel.add(btnCancel);
        south.add((Component)buttonPanel, "East");
        contentPane.add((Component)south, "South");
        this.mapCancelKeystroke();
        this.setSize(400, 300);
        this.setResizable(false);
        StudioUtilities.centerWindowInFrame(this, this.getOwner());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (BaseLocalSearchDialog.this._comboSearch.isShowing()) {
                    BaseLocalSearchDialog.this._comboSearch.requestFocus();
                }
            }
        });
    }

    private void addFindEnabler(final JButton btnFind) {
        this.enableFindButton(btnFind);
        this._comboSearch.getEditor().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseLocalSearchDialog.this.enableFindButton(btnFind);
                if (btnFind.isEnabled() && !BaseLocalSearchDialog.this._comboSearch.isPopupVisible()) {
                    btnFind.doClick();
                }
            }
        });
        this._comboSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseLocalSearchDialog.this.enableFindButton(btnFind);
            }
        });
        if (this._comboReplace != null) {
            this._comboReplace.getEditor().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BaseLocalSearchDialog.this.enableFindButton(btnFind);
                    if (btnFind.isEnabled() && !BaseLocalSearchDialog.this._comboReplace.isPopupVisible()) {
                        btnFind.doClick();
                    }
                }
            });
            this._comboReplace.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BaseLocalSearchDialog.this.enableFindButton(btnFind);
                }
            });
        }
        ((JTextField)this._comboSearch.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                BaseLocalSearchDialog.this.enableFindButton(btnFind);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BaseLocalSearchDialog.this.enableFindButton(btnFind);
            }
        });
    }

    private void enableFindButton(JButton btnFind) {
        String strText = (String)this._comboSearch.getEditor().getItem();
        btnFind.setEnabled(strText != null && strText.length() > 0);
    }

    private void performFind(boolean backwards) {
        this.findText(backwards);
        this.saveSettings();
        this.close();
    }

    private void configTextSearchUI(JComponent contentPane) {
        JPanel north = new JPanel(new BorderLayout());
        JPanel textSearchPanel = new JPanel();
        textSearchPanel.setLayout(new BoxLayout(textSearchPanel, 1));
        JPanel nameValue = new JPanel(new BorderLayout());
        JLabel label = new JLabel("Text to find");
        nameValue.add((Component)label, "North");
        for (ListDataListener listener : g_historySearch.getListDataListeners()) {
            g_historySearch.removeListDataListener(listener);
        }
        this._comboSearch = new JComboBox(g_historySearch);
        this._comboSearch.setEditable(true);
        JTextField textField = (JTextField)this._comboSearch.getEditor().getEditorComponent();
        if (this._selectedText != null && !this._selectedText.isEmpty()) {
            textField.setText(this._selectedText);
        } else if (g_historySearch.getSize() > 0) {
            this._comboSearch.getEditor().setItem(g_historySearch.getElementAt(g_historySearch.getSize() - 1));
        }
        textField.setSelectionStart(0);
        textField.setSelectionEnd(textField.getText().length());
        nameValue.add((Component)this._comboSearch, "South");
        textSearchPanel.add(nameValue);
        if (this.isReplaceMode()) {
            nameValue = new JPanel(new BorderLayout());
            label = new JLabel("Replace with");
            nameValue.add((Component)label, "North");
            this._comboReplace = new JComboBox(g_historyReplace);
            this._comboReplace.setEditable(true);
            if (g_historyReplace.getSelectedItem() != null) {
                ((JTextField)this._comboReplace.getEditor().getEditorComponent()).setText(g_historyReplace.getSelectedItem().toString());
            }
            nameValue.add((Component)this._comboReplace, "South");
            textSearchPanel.add(nameValue);
        }
        north.add((Component)textSearchPanel, "South");
        contentPane.add((Component)north, "North");
        JPanel center = new JPanel();
        center.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        center.setLayout(new BoxLayout(center, 1));
        center.add(new JSeparator());
        this._cbCaseSensitive = new JCheckBox("Case sensitive");
        this._cbCaseSensitive.setMnemonic('C');
        center.add(this._cbCaseSensitive);
        this._cbRegex = new JCheckBox("Regular expression");
        this._cbRegex.setMnemonic('R');
        center.add(this._cbRegex);
        contentPane.add((Component)center, "Center");
        this.initTextSettings();
    }

    private final void close() {
        this.dispose();
    }

    private void findText(boolean backwards) {
        String strText = (String)this._comboSearch.getEditor().getItem();
        if (strText == null || strText.length() == 0) {
            return;
        }
        this.find(strText, backwards);
    }

    private void mapCancelKeystroke() {
        Object key = this.getRootPane().getInputMap(1).get(KeyStroke.getKeyStroke(27, 0));
        if (key == null) {
            key = "Cancel";
            this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), key);
        }
        this.getRootPane().getActionMap().put(key, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseLocalSearchDialog.this.close();
            }
        });
    }

    public boolean isCaseSensitive() {
        return this._cbCaseSensitive.isSelected();
    }

    public boolean isRegEx() {
        return this._cbRegex.isSelected();
    }

    public boolean isAllMode() {
        return this._bAllMode;
    }

    public void setAllMode(boolean bAllMode) {
        this._bAllMode = bAllMode;
    }

    public boolean hasAllModeRecycledFromTop() {
        return this._bAllModeFromTop;
    }

    public void setAllModeRecyclingFromTop(boolean bAllModeFromTop) {
        this._bAllModeFromTop = bAllModeFromTop;
    }

    public String getDialogReplaceText() {
        return (String)this._comboReplace.getEditor().getItem();
    }
}

