/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import editor.search.SearchLocation;
import editor.search.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExStringUtil {
    public static List<SearchLocation> searchIgnoreCase(String strSource, String strPattern) {
        return RegExStringUtil.search(strSource, strPattern, true);
    }

    public static List<SearchLocation> search(String strSource, String strPattern, boolean bIgnoreCase) {
        return RegExStringUtil.search(strSource, strPattern, bIgnoreCase, 0);
    }

    public static List<SearchLocation> search(String strSource, String strPattern, boolean bIgnoreCase, int iOffset) {
        return RegExStringUtil.search(strSource, strPattern, bIgnoreCase, iOffset, false);
    }

    public static List<SearchLocation> search(String strSource, String strPattern, boolean bIgnoreCase, int iOffset, boolean backwards) {
        boolean bFound;
        int iFlags = bIgnoreCase ? 2 : 0;
        ArrayList<SearchLocation> list = new ArrayList<SearchLocation>();
        int iIndex = 0;
        Pattern pattern = Pattern.compile(strPattern, iFlags);
        Matcher matcher = pattern.matcher(strSource);
        boolean bl = bFound = backwards ? matcher.find() : matcher.find(iOffset);
        if (!bFound) {
            return list;
        }
        int iIndex2 = matcher.start();
        SearchLocation slBuffer = new SearchLocation();
        while (!backwards || matcher.end() < iOffset) {
            SearchLocation sl = new SearchLocation();
            sl._iOffset = iIndex2;
            StringUtil.getLocation(strSource, iIndex, iIndex2, slBuffer);
            sl._iLine = slBuffer._iLine + 1;
            sl._iColumn = slBuffer._iColumn + 1;
            sl._iLineOffset = slBuffer._iLineOffset;
            sl._iLength = matcher.end() - matcher.start();
            sl._matcher = matcher;
            list.add(sl);
            iIndex = iIndex2;
            bFound = matcher.find();
            if (!bFound) break;
            iIndex2 = matcher.start();
        }
        if (backwards) {
            Collections.reverse(list);
        }
        return list;
    }
}

