/*
 * Decompiled with CFR 0.152.
 */
package editor.undo;

import editor.undo.IStagedStateEdit;
import editor.undo.IStagedStateEditable;
import editor.undo.UndoChangeEvent;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.StateEdit;
import javax.swing.undo.StateEditable;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class AtomicUndoManager
extends UndoManager {
    private Stack<DisplayableCompoundEdit> _undoAtomNest;
    private boolean _bPaused;
    private List<ChangeListener> _changeListeners;
    private long _lLastUndoTime;

    public AtomicUndoManager() {
        this(1000);
    }

    public AtomicUndoManager(int iUndoLimit) {
        this.setLimit(iUndoLimit);
        this._undoAtomNest = new Stack();
        this._changeListeners = new ArrayList<ChangeListener>();
    }

    public boolean isPaused() {
        return this._bPaused;
    }

    public void setPaused(boolean bPaused) {
        this._bPaused = bPaused;
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit edit) {
        if (this.isPaused()) {
            return false;
        }
        this.fireChangeEvent(UndoChangeEvent.ChangeType.ADD_EDIT, edit);
        DisplayableCompoundEdit undoAtom = this.getUndoAtom();
        if (undoAtom != null) {
            return undoAtom.addEdit(edit);
        }
        return super.addEdit(edit);
    }

    public synchronized void removeEdit(UndoableEdit edit) {
        int iIndex = this.edits.indexOf(edit);
        if (iIndex < 0) {
            return;
        }
        this.trimEdits(iIndex, iIndex);
    }

    public void beginUndoAtom() {
        this.beginUndoAtom(null);
    }

    public CompoundEdit beginUndoAtom(String strDisplayName) {
        if (this.isPaused()) {
            return null;
        }
        CompoundEdit parent = null;
        try {
            parent = this._undoAtomNest.peek();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        parent = parent == null ? this : parent;
        DisplayableCompoundEdit undoAtom = new DisplayableCompoundEdit(strDisplayName);
        parent.addEdit(undoAtom);
        this._undoAtomNest.push(undoAtom);
        return undoAtom;
    }

    public void endUndoAtom() {
        this.endUndoAtom(null);
    }

    public void endUndoAtom(CompoundEdit undoAtom) {
        if (this.isPaused()) {
            return;
        }
        try {
            CompoundEdit csr;
            do {
                csr = this._undoAtomNest.pop();
                csr.end();
            } while (undoAtom != null && csr != undoAtom);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DisplayableCompoundEdit getUndoAtom() {
        DisplayableCompoundEdit undoAtom = null;
        try {
            undoAtom = this._undoAtomNest.peek();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return undoAtom;
    }

    @Override
    public synchronized void redo() throws CannotRedoException {
        this.setLastUndoTime();
        try {
            IStagedStateEditable stagedState;
            this.fireChangeEvent(UndoChangeEvent.ChangeType.REDO, null);
            UndoableEdit edit = this.editToBeRedone();
            if (edit instanceof IStagedStateEdit && (stagedState = ((IStagedStateEdit)edit).getStagedRedoState()) != null && !stagedState.prepareForRedo()) {
                return;
            }
            super.redo();
        }
        finally {
            this.setLastUndoTime();
        }
    }

    @Override
    public synchronized void undo() throws CannotUndoException {
        this.setLastUndoTime();
        try {
            IStagedStateEditable stagedState;
            this.fireChangeEvent(UndoChangeEvent.ChangeType.UNDO, null);
            UndoableEdit edit = this.editToBeUndone();
            if (edit instanceof IStagedStateEdit && (stagedState = ((IStagedStateEdit)edit).getStagedUndoState()) != null && !stagedState.prepareForUndo()) {
                return;
            }
            super.undo();
        }
        finally {
            this.setLastUndoTime();
        }
    }

    public long getLastUndoTime() {
        return this._lLastUndoTime;
    }

    private void setLastUndoTime() {
        this._lLastUndoTime = System.currentTimeMillis();
    }

    @Override
    public synchronized void undoOrRedo() throws CannotRedoException, CannotUndoException {
        this.fireChangeEvent(UndoChangeEvent.ChangeType.UNDO_OR_REDO, null);
        super.undoOrRedo();
    }

    @Override
    protected void undoTo(UndoableEdit edit) throws CannotUndoException {
        this.fireChangeEvent(UndoChangeEvent.ChangeType.UNDO_TO, edit);
        super.undoTo(edit);
    }

    @Override
    protected void redoTo(UndoableEdit edit) throws CannotRedoException {
        this.fireChangeEvent(UndoChangeEvent.ChangeType.REDO_TO, edit);
        super.redoTo(edit);
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListeners.remove(listener);
    }

    public void recordChange(StateEditable change) {
        this.beginUndoAtom();
        try {
            StateEdit transaction = new StateEdit(change);
            transaction.end();
            this.addEdit(transaction);
        }
        finally {
            this.endUndoAtom();
        }
    }

    private void fireChangeEvent(UndoChangeEvent.ChangeType type, UndoableEdit edit) {
        ChangeListener[] listeners = this._changeListeners.toArray(new ChangeListener[this._changeListeners.size()]);
        if (listeners.length == 0) {
            return;
        }
        UndoChangeEvent e = new UndoChangeEvent(this, type, edit);
        for (int i = 0; i < listeners.length; ++i) {
            ChangeListener listener = listeners[i];
            listener.stateChanged(e);
        }
    }

    static class DisplayableCompoundEdit
    extends CompoundEdit
    implements IStagedStateEdit {
        String _strDisplayName;

        DisplayableCompoundEdit() {
            this(null);
        }

        DisplayableCompoundEdit(String strDisplayName) {
            this._strDisplayName = strDisplayName;
        }

        @Override
        public boolean isInProgress() {
            return false;
        }

        @Override
        public IStagedStateEditable getStagedUndoState() {
            UndoableEdit edit = this.lastEdit();
            return edit instanceof IStagedStateEdit ? ((IStagedStateEdit)edit).getStagedUndoState() : null;
        }

        @Override
        public IStagedStateEditable getStagedRedoState() {
            UndoableEdit edit = this.edits.size() > 0 ? (UndoableEdit)this.edits.elementAt(0) : null;
            return edit instanceof IStagedStateEdit ? ((IStagedStateEdit)edit).getStagedRedoState() : null;
        }

        @Override
        public String getPresentationName() {
            if (this._strDisplayName != null && this._strDisplayName.length() > 0) {
                return this._strDisplayName;
            }
            return super.getPresentationName();
        }

        @Override
        public String getUndoPresentationName() {
            String strDisplayName = this.getPresentationName();
            if (strDisplayName != null && strDisplayName.length() > 0) {
                return "Undo " + strDisplayName;
            }
            return super.getUndoPresentationName();
        }

        @Override
        public String getRedoPresentationName() {
            String strDisplayName = this.getPresentationName();
            if (strDisplayName != null && strDisplayName.length() > 0) {
                return "Redo " + strDisplayName;
            }
            return super.getRedoPresentationName();
        }
    }
}

