/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.FileWatcher;
import editor.GosuPanel;
import editor.tabpane.ITab;
import editor.tabpane.TabPane;
import editor.util.EditorUtilities;
import gw.lang.reflect.module.IProject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class Experiment
implements IProject {
    private String _name;
    private List<String> _sourcePath;
    private File _experimentDir;
    private List<String> _openFiles;
    private String _activeFile;
    private String _recentProgram;
    private GosuPanel _gosuPanel;

    public Experiment(String name, File dir, GosuPanel gosuPanel) {
        this._name = name;
        this._gosuPanel = gosuPanel;
        this._sourcePath = Arrays.asList(new File(dir, Experiment.getRelativeGosuSourcePath()).getAbsolutePath());
        this._experimentDir = dir;
        this._experimentDir.mkdirs();
        this._openFiles = Collections.emptyList();
    }

    public Experiment(File dir, GosuPanel gosuPanel) {
        this._name = dir.getName();
        this._experimentDir = dir;
        this._gosuPanel = gosuPanel;
        this.load();
        FileWatcher.instance(this);
    }

    public String getName() {
        return this._name;
    }

    public Object getNativeProject() {
        return this;
    }

    public boolean isDisposed() {
        return false;
    }

    public boolean isHeadless() {
        return false;
    }

    public boolean isShadowMode() {
        return false;
    }

    public void setName(String name) {
        this._name = name;
    }

    public List<String> getSourcePath() {
        return this._sourcePath;
    }

    public void setSourcePath(List<String> classpath) {
        this._sourcePath = classpath;
    }

    public File getExperimentDir() {
        return this._experimentDir;
    }

    public void setExperimentDir(File experimentDir) {
        this._experimentDir = experimentDir;
    }

    public List<String> getOpenFiles() {
        return this._openFiles;
    }

    public String getActiveFile() {
        return this._activeFile;
    }

    public GosuPanel getGosuPanel() {
        return this._gosuPanel;
    }

    public File getOrMakeExperimentFile() {
        File experimentDir = this.getExperimentDir();
        experimentDir.mkdirs();
        File experiment = EditorUtilities.findExperimentFile(experimentDir);
        if (experiment != null) {
            return experiment;
        }
        experiment = new File(experimentDir.getAbsolutePath() + File.separator + experimentDir.getName() + ".prj");
        try (FileWriter writer = new FileWriter(experiment);){
            Properties props = new Properties();
            props.put("Name", this.getName());
            if (this.getSourcePath() != null) {
                for (int i = 0; i < this.getSourcePath().size(); ++i) {
                    String sourcePath = this.getSourcePath().get(i);
                    props.put("Classpath.Entry" + i, sourcePath);
                    File sourceDir = new File(sourcePath);
                    sourceDir.mkdirs();
                }
            }
            props.store(writer, "Gosu Experiment: " + this.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return experiment;
    }

    public void save(TabPane tabPane) {
        int i;
        File userFile = this.getOrMakeExperimentFile();
        Properties props = new Properties();
        props.put("Name", this.getName());
        ITab selectedTab = tabPane.getSelectedTab();
        if (selectedTab != null) {
            props.put("Tab.Active", this.makeExperimentRelativePathWithSlashes((File)tabPane.getSelectedTab().getContentPane().getClientProperty("_file")));
            for (i = 0; i < tabPane.getTabCount(); ++i) {
                File file = (File)tabPane.getTabAt(i).getContentPane().getClientProperty("_file");
                props.put("Tab.Open." + (char)(i + 65), this.makeExperimentRelativePathWithSlashes(file));
            }
        }
        for (i = 0; i < this.getSourcePath().size(); ++i) {
            String path = this.getSourcePath().get(i);
            String relativePath = this.makeExperimentRelativePathWithSlashes(new File(path));
            props.put("Classpath.Entry" + i, relativePath == null ? path : relativePath);
        }
        if (this.getRecentProgram() != null) {
            props.put("Recent.Program", this.getRecentProgram());
        }
        try {
            FileWriter fw = new FileWriter(userFile);
            props.store(fw, "Gosu Experiment");
            fw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String makeExperimentRelativePath(File file) {
        String absExperimentDir = this.getExperimentDir().getAbsolutePath();
        String absFile = file.getAbsolutePath();
        if (!absFile.startsWith(absExperimentDir)) {
            return absFile;
        }
        return absFile.substring(absExperimentDir.length() + 1);
    }

    public String makeExperimentRelativePathWithSlashes(File file) {
        return this.makeExperimentRelativePath(file).replace('\\', '/');
    }

    private void load() {
        Properties props = new Properties();
        try {
            System.setProperty("user.dir", this.getExperimentDir().getAbsolutePath());
            FileReader reader = new FileReader(this.getOrMakeExperimentFile());
            props.load(reader);
            reader.close();
            this.setName(props.getProperty("Name", this.getExperimentDir().getName()));
            Set<String> keys = props.stringPropertyNames();
            Object[] sortedKeys = keys.toArray(new String[keys.size()]);
            Arrays.sort(sortedKeys);
            ArrayList<String> sourcePath = new ArrayList<String>();
            for (Object cpEntry : sortedKeys) {
                File file;
                if (!((String)cpEntry).startsWith("Classpath.Entry") || !(file = new File(props.getProperty((String)cpEntry)).getAbsoluteFile()).exists()) continue;
                sourcePath.add(file.getAbsolutePath());
            }
            this._sourcePath = sourcePath;
            if (this._sourcePath.isEmpty()) {
                File srcPath = new File(this.getExperimentDir(), Experiment.getRelativeGosuSourcePath());
                this._sourcePath.add(srcPath.getAbsolutePath());
            }
            ArrayList<String> openFiles = new ArrayList<String>();
            for (Object strTab : sortedKeys) {
                File file;
                if (!((String)strTab).startsWith("Tab.Open") || !(file = new File(props.getProperty((String)strTab)).getAbsoluteFile()).isFile()) continue;
                openFiles.add(file.getAbsolutePath());
            }
            this._openFiles = openFiles;
            this._activeFile = props.getProperty("Tab.Active");
            if (this._activeFile != null && !this._activeFile.isEmpty()) {
                this._activeFile = new File(this._activeFile).getAbsolutePath();
            }
            this._recentProgram = props.getProperty("Recent.Program");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File getOrMakeUntitledProgram() {
        File srcDir = new File(this.getSourcePath().get(0));
        srcDir.mkdirs();
        File scratchPackage = new File(srcDir, "scratch");
        scratchPackage.mkdirs();
        File file = new File(scratchPackage, "RunMe.gsp");
        try {
            if (file.createNewFile()) {
                try (FileWriter writer = new FileWriter(file);){
                    writer.write("//\n// Run this from the Run menu or press F5\n//\nprint(\"Hello, World!\")\n");
                }
            }
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getRelativeGosuSourcePath() {
        return "src" + File.separator + "main" + File.separator + "gosu";
    }

    public String getRecentProgram() {
        return this._recentProgram;
    }

    public void setRecentProgram(String name) {
        this._recentProgram = name;
    }
}

