/*
 * Decompiled with CFR 0.152.
 */
package editor.util.transform.java;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import editor.util.transform.java.JavaStringObject;
import editor.util.transform.java.Wrap;
import editor.util.transform.java.visitor.GosuVisitor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;

public class JavaToGosu {
    public static String convertString(String javaSource) {
        Wrap[] wraps = new Wrap[]{new Wrap("", "", "", ""), new Wrap("class _JAVA_TO_GOSU_INTERNAL_ {", "\n}", "class _JAVA_TO_GOSU_INTERNAL_  {\n\n", "\n}\n"), new Wrap("class _JAVA_TO_GOSU_INTERNAL_ { void _JAVA_TO_GOSU_INTERNAL_METHOD_() {", "\n}}", "class _JAVA_TO_GOSU_INTERNAL_  {\n\n  function _JAVA_TO_GOSU_INTERNAL_METHOD_() : void {\n", "\n  }\n\n}\n"), new Wrap("class _JAVA_TO_GOSU_INTERNAL_ { void _JAVA_TO_GOSU_INTERNAL_METHOD_() {", ";\n}}", "class _JAVA_TO_GOSU_INTERNAL_  {\n\n  function _JAVA_TO_GOSU_INTERNAL_METHOD_() : void {\n", "\n  }\n\n}\n"), new Wrap("class _JAVA_TO_GOSU_INTERNAL_ { void _JAVA_TO_GOSU_INTERNAL_METHOD_() { if(", ");\n}}", "class _JAVA_TO_GOSU_INTERNAL_  {\n\n  function _JAVA_TO_GOSU_INTERNAL_METHOD_() : void {\n    if (", ") {\n      \n    }\n  }\n\n}\n")};
        String javaWrapStart = "";
        String javaWrapEnd = "";
        String gosuWrapStart = "";
        String gosuWrapEnd = "";
        ArrayList<CompilationUnitTree> trees = null;
        boolean parsed = false;
        String output = null;
        for (int i = wraps.length - 1; i >= 0 && !parsed; --i) {
            javaWrapStart = wraps[i].JAVA_WRAP_START;
            javaWrapEnd = wraps[i].JAVA_WRAP_END;
            gosuWrapStart = wraps[i].GOSU_WRAP_START;
            gosuWrapEnd = wraps[i].GOSU_WRAP_END;
            trees = new ArrayList<CompilationUnitTree>();
            String src = javaWrapStart + javaSource + javaWrapEnd;
            parsed = JavaToGosu.parseJava(trees, src);
        }
        if (!parsed) {
            return "";
        }
        GosuVisitor visitor = new GosuVisitor(2);
        for (CompilationUnitTree tree : trees) {
            tree.accept(visitor, null);
        }
        output = visitor.getOutput().toString();
        if (!javaWrapStart.isEmpty()) {
            int b = output.indexOf(gosuWrapStart) + gosuWrapStart.length();
            int e = output.lastIndexOf(gosuWrapEnd);
            output = JavaToGosu.unIndent(output.substring(b, e));
        }
        return output;
    }

    private static String unIndent(String output) {
        int tab;
        StringBuilder src = new StringBuilder();
        String[] lines = output.split("\n");
        char[] chars = lines[0].toCharArray();
        for (tab = 0; tab < chars.length && chars[tab] == ' '; ++tab) {
        }
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            if (line.length() > tab && line.substring(0, tab).trim().isEmpty()) {
                src.append(line.substring(tab));
            } else {
                src.append(line);
            }
            src.append("\n");
        }
        return src.toString();
    }

    private static boolean parseJava(List<CompilationUnitTree> trees, String src) {
        JavacTool compiler = JavacTool.create();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        boolean success = true;
        ArrayList<JavaStringObject> javaStringObjects = new ArrayList<JavaStringObject>();
        javaStringObjects.add(new JavaStringObject(src));
        StringWriter errors = new StringWriter();
        JavaCompiler.CompilationTask task = compiler.getTask((Writer)errors, (JavaFileManager)fileManager, null, null, null, javaStringObjects);
        JavacTaskImpl javacTask = (JavacTaskImpl)task;
        try {
            Iterable<? extends CompilationUnitTree> iterable = javacTask.parse();
            for (CompilationUnitTree compilationUnitTree : iterable) {
                trees.add(compilationUnitTree);
            }
            fileManager.close();
        }
        catch (IOException e) {
            success = false;
        }
        if (!errors.toString().isEmpty()) {
            success = false;
        }
        return success;
    }
}

