/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractParseExceptionResolver;
import editor.BeanInfoPopup;
import editor.BeanTree;
import editor.util.EditorUtilities;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.expressions.IBeanMethodCallExpression;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;

public class BeanMethodCallValueCompletion
extends AbstractParseExceptionResolver {
    @Override
    public void resolve(ParseException e) {
    }

    @Override
    public boolean handleCompleteValue() {
        final IParseTree currentLocation = this.getDeepestLocationToComplete();
        IParsedElement element = currentLocation.getParsedElement();
        if (!(element instanceof IBeanMethodCallExpression)) {
            return false;
        }
        final IBeanMethodCallExpression ma = (IBeanMethodCallExpression)element;
        try {
            String strLastMember = ma.getMemberName();
            BeanInfoPopup popup = new BeanInfoPopup(ma.getRootType(), strLastMember, this.getGosuEditor());
            popup.setSelection(strLastMember, true);
            popup.addNodeChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    BeanTree beanInfoSelection = (BeanTree)e.getSource();
                    String strRef = beanInfoSelection.makePath(false);
                    try {
                        String strRoot = BeanMethodCallValueCompletion.this.getGosuEditor().getEditor().getText(currentLocation.getOffset(), ma.getRootExpression().getLocation().getLength());
                        BeanMethodCallValueCompletion.this.getGosuEditor().replaceLocation(currentLocation, strRoot + '.' + strRef);
                    }
                    catch (BadLocationException e1) {
                        throw new RuntimeException(e1);
                    }
                    BeanMethodCallValueCompletion.this.getEditor().requestFocus();
                    BeanMethodCallValueCompletion.this.getGosuEditor().fixSwingFocusBugWhenPopupCloses();
                    BeanMethodCallValueCompletion.this.getEditor().repaint();
                }
            });
            this.getGosuEditor().setBeanInfoPopup(popup);
            this.getGosuEditor().displayBeanInfoPopup(currentLocation.getOffset());
        }
        catch (ParseException pe) {
            EditorUtilities.handleUncaughtException(pe);
        }
        return true;
    }
}

