/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractParseExceptionResolver;
import editor.EnumerationListPopup;
import editor.util.TextComponentUtil;
import gw.config.CommonServices;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.expressions.ILiteralExpression;
import gw.lang.reflect.IEnumType;
import gw.lang.reflect.IType;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EnumerationValueCompletion
extends AbstractParseExceptionResolver {
    @Override
    public boolean canResolve(ParseException pe) {
        if (!super.canResolve(pe)) {
            return false;
        }
        IType typeExpected = this.getExpectedType(pe);
        return typeExpected != null && typeExpected.isEnum();
    }

    @Override
    public void resolve(ParseException pe) {
        IType typeExpected = this.getExpectedType(pe);
        EnumerationListPopup popup = new EnumerationListPopup((IEnumType)typeExpected, this.getEditor());
        popup.addNodeChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AbstractParseExceptionResolver.isEditorAtPossibleArgPosition(EnumerationValueCompletion.this.getDeepestLocationToComplete().getParsedElement(), EnumerationValueCompletion.this.getEditor())) {
                    EnumerationValueCompletion.this.insertTextAtCaret(e.getSource().toString());
                } else {
                    TextComponentUtil.replaceWordAtCaretDynamic(EnumerationValueCompletion.this.getEditor(), (String)e.getSource(), EnumerationValueCompletion.this.getGosuEditor().getReplaceWordCallback(), false);
                }
                EnumerationValueCompletion.this.getEditor().requestFocus();
                EnumerationValueCompletion.this.getGosuEditor().fixSwingFocusBugWhenPopupCloses();
                EnumerationValueCompletion.this.getEditor().repaint();
            }
        });
        this.showValueCompletionPopup(popup, true);
    }

    @Override
    public boolean handleCompleteValue() {
        IType typeExpected = this.getTypeExpected();
        if (typeExpected == null) {
            return false;
        }
        if (!typeExpected.isEnum()) {
            return false;
        }
        final IParseTree currentLocation = this.getDeepestLocationToComplete();
        IParsedElement element = currentLocation.getParsedElement();
        EnumerationListPopup popup = new EnumerationListPopup((IEnumType)typeExpected, this.getEditor());
        Object value = null;
        if (element instanceof ILiteralExpression) {
            try {
                value = CommonServices.getCoercionManager().convertValue(((ILiteralExpression)element).evaluate(), typeExpected);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value != null) {
            popup.setValue(value);
        }
        popup.addNodeChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EnumerationValueCompletion.this.getGosuEditor().replaceLocation(currentLocation, (String)e.getSource());
                EnumerationValueCompletion.this.getEditor().requestFocus();
                EnumerationValueCompletion.this.getGosuEditor().fixSwingFocusBugWhenPopupCloses();
                EnumerationValueCompletion.this.getEditor().repaint();
            }
        });
        this.showValueCompletionPopup(popup, true);
        return true;
    }
}

