/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractPathCompletionHandler;
import editor.BeanInfoPopup;
import editor.BeanTree;
import editor.GosuEditor;
import editor.GosuEditorPane;
import editor.util.TextComponentUtil;
import gw.lang.parser.IExpression;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.expressions.IIdentifierExpression;
import gw.lang.parser.expressions.IInitializerAssignment;
import gw.lang.parser.expressions.IObjectInitializerExpression;
import gw.lang.parser.resources.Res;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.IFeatureFilter;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InitializerCompletionHandler
extends AbstractPathCompletionHandler {
    @Override
    public boolean handleCompletePath(ISymbolTable transientSymTable) {
        final GosuEditor gsEditor = this.getGosuEditor();
        IExpression parsedElement = null;
        if (InitializerCompletionHandler.isInitializerStart((IParsedElement)this.getGosuEditor().getExpressionAtCaret())) {
            parsedElement = this.getGosuEditor().getExpressionAtCaret();
        }
        if (this.isDoubleColonAtCaret()) {
            parsedElement = this.getGosuEditor().getDeepestLocationAtCaret().getParsedElement();
        }
        if (parsedElement != null) {
            BeanInfoPopup valuePopup;
            IObjectInitializerExpression oie = this.findObjectInitializerExpression((IParsedElement)parsedElement);
            IType type = oie.getType();
            String strMemberPath = this.getSingleNameAtCaret();
            strMemberPath = strMemberPath != null ? strMemberPath.trim() : null;
            try {
                valuePopup = new BeanInfoPopup(type, strMemberPath, true, gsEditor, new IFeatureFilter(){

                    public boolean acceptFeature(IType beanType, IFeatureInfo fi) {
                        IPropertyInfo pi;
                        return fi instanceof IPropertyInfo && ((pi = (IPropertyInfo)fi).isWritable(null) || JavaTypes.COLLECTION().isAssignableFrom(pi.getFeatureType()) || JavaTypes.MAP().isAssignableFrom(pi.getFeatureType()));
                    }
                });
            }
            catch (ParseException e) {
                return false;
            }
            valuePopup.addNodeChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    BeanTree beanTree = (BeanTree)e.getSource();
                    GosuEditorPane editor = gsEditor.getEditor();
                    editor.select(TextComponentUtil.findCharacterPositionOnLine(editor.getCaretPosition() - 1, editor.getText(), ':', TextComponentUtil.Direction.BACKWARD) + 1, editor.getCaretPosition());
                    editor.replaceSelection(beanTree.getBeanNode().getName() + " = ");
                    editor.requestFocus();
                    gsEditor.fixSwingFocusBugWhenPopupCloses();
                    editor.repaint();
                }
            });
            gsEditor.setValuePopup(valuePopup);
            gsEditor.displayValuePopup();
            return true;
        }
        return false;
    }

    private boolean isDoubleColonAtCaret() {
        if (":".equals(TextComponentUtil.getWordBeforeCaret(this.getGosuEditor().getEditor()))) {
            return this.getGosuEditor().getDeepestLocationAtCaret() != null && this.getGosuEditor().getDeepestLocationAtCaret().getParsedElement() instanceof IInitializerAssignment && this.getGosuEditor().getExpressionAtCaret() == null;
        }
        return false;
    }

    private IObjectInitializerExpression findObjectInitializerExpression(IParsedElement parsedElement) {
        if (parsedElement instanceof IObjectInitializerExpression) {
            return (IObjectInitializerExpression)parsedElement;
        }
        if (parsedElement.getParent() != null) {
            return this.findObjectInitializerExpression(parsedElement.getParent());
        }
        return null;
    }

    public static boolean isInitializerStart(IParsedElement parsedElement) {
        if (parsedElement instanceof IInitializerAssignment) {
            IInitializerAssignment iia = (IInitializerAssignment)parsedElement;
            if (parsedElement instanceof IIdentifierExpression) {
                return true;
            }
            List exceptions = iia.getParseExceptions();
            for (IParseIssue exception : exceptions) {
                if (!exception.getMessageKey().equals(Res.MSG_EQUALS_FOR_INITIALIZER_EXPR)) continue;
                return true;
            }
            return false;
        }
        return parsedElement != null && InitializerCompletionHandler.isInitializerStart(parsedElement.getParent());
    }
}

