/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GosuEditor;
import editor.HtmlViewer;
import editor.util.EditorUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.text.Position;

public class JavadocPopup
extends JPopupMenu
implements MouseMotionListener,
MouseListener {
    private static final int MAX_WIDTH = 520;
    private HtmlViewer _viewer;
    private String _strHelpText;
    private GosuEditor _editor;
    private JScrollPane _scroller;
    private EditorKeyListener _editorKeyListener;
    private boolean _bResizedWidth;
    private boolean _bResizedHeight;
    private Point _clickLocation;

    public JavadocPopup(String strHelpText, GosuEditor editor) {
        this._strHelpText = strHelpText;
        this._editor = editor;
        this.initLayout();
    }

    protected void initLayout() {
        this.setOpaque(false);
        this.setBorder(BorderFactory.createLineBorder(EditorUtilities.WINDOW_BORDER));
        GridBagLayout gridBag = new GridBagLayout();
        JPanel pane = new JPanel();
        pane.addMouseListener(this);
        pane.addMouseMotionListener(this);
        pane.setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        this._viewer = new HtmlViewer();
        this._viewer.setText(this._strHelpText);
        this._viewer.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this._viewer.addMouseListener(this);
        this._viewer.addMouseMotionListener(this);
        this._scroller = new JScrollPane(this._viewer);
        this._scroller.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._scroller.setMaximumSize(this.calcMaximumViewerSize());
        this._viewer.setBackground(EditorUtilities.TOOLTIP_BACKGROUND);
        c.anchor = 10;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        pane.add((Component)this._scroller, c);
        this._editorKeyListener = new EditorKeyListener();
        this.add(pane);
        this.addSeparator();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void show(Component c, int iX, int iY) {
        super.show(c, iX, iY);
        EventQueue.invokeLater(() -> {
            if (!this._bResizedWidth && this._viewer.getWidth() > 520) {
                this._scroller.setPreferredSize(new Dimension(520, 520));
                this._bResizedWidth = true;
                this.pack();
                this.setVisible(false);
                this.show(c, iX, iY);
                return;
            }
            if (!this._bResizedHeight && this.isViewerLessThanHalfFull()) {
                this._scroller.setPreferredSize(new Dimension(520, this._scroller.getHeight() / 2));
                this._bResizedHeight = true;
                this.pack();
                this.setVisible(false);
                this.show(c, iX, iY);
            }
        });
    }

    private Dimension calcMaximumViewerSize() {
        Toolkit defToolkit = Toolkit.getDefaultToolkit();
        int iMaxHeight = defToolkit.getScreenSize().height * 2 / 3;
        return new Dimension(520, iMaxHeight);
    }

    private boolean isViewerLessThanHalfFull() {
        Position endPos = this._viewer.getDocument().getEndPosition();
        if (endPos == null) {
            return false;
        }
        int iEndPos = endPos.getOffset() - 1;
        try {
            Rectangle rcEndPos = this._viewer.modelToView(iEndPos);
            if (rcEndPos != null) {
                return rcEndPos.y + rcEndPos.height < this._scroller.getHeight() / 2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void setVisible(boolean bVisible) {
        super.setVisible(bVisible);
        if (bVisible) {
            this.registerListeners();
        } else {
            this.unregisterListeners();
            this._editor.getEditor().requestFocus();
        }
    }

    void registerListeners() {
        this.unregisterListeners();
        this._editor.getEditor().addKeyListener(this._editorKeyListener);
    }

    void unregisterListeners() {
        this._editor.getEditor().removeKeyListener(this._editorKeyListener);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this._clickLocation != null) {
            Point location = this.getLocationOnScreen();
            location.translate(e.getX() - this._clickLocation.x, e.getY() - this._clickLocation.y);
            this.setLocation(location);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this._clickLocation = e.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this._clickLocation = null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class EditorKeyListener
    extends KeyAdapter {
        EditorKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                JavadocPopup.this.setVisible(false);
                e.consume();
            }
        }
    }
}

