/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GosuEditor;
import editor.GosuEditorPane;
import gw.lang.parser.IParseTree;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

class MouseInEditorHandler
implements MouseListener,
MouseMotionListener,
KeyListener {
    private static final UnderlineHighlighterPainter PAINTER = new UnderlineHighlighterPainter(Color.BLACK);
    private final GosuEditor _editor;
    private Cursor _previousCursor;

    public MouseInEditorHandler(GosuEditor editor) {
        assert (editor != null);
        this._editor = editor;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && (e.getModifiersEx() & 0x80) == 128) {
            this._editor.gotoDeclaration();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseMoved(MouseEvent event) {
        this.removeHighlights();
        GosuEditorPane editorComponent = this._editor.getEditor();
        Highlighter highlighter = editorComponent.getHighlighter();
        if ((event.getModifiersEx() & 0x80) == 128) {
            IParseTree deepestStatementLocationAtPos;
            if (this._previousCursor == null) {
                this._previousCursor = event.getComponent().getCursor();
                event.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }
            if ((deepestStatementLocationAtPos = this._editor.getDeepestLocation(event.getPoint())) == null) return;
        }
        if (this._previousCursor == null) return;
        event.getComponent().setCursor(this._previousCursor);
        this._previousCursor = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getModifiers() == 16 && e.getClickCount() == 2) {
            this._editor.selectWordForMouseClick();
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.removeHighlights();
    }

    private void removeHighlights() {
        Highlighter.Highlight[] highlights;
        GosuEditorPane editorComponent = this._editor.getEditor();
        Highlighter highlighter = editorComponent.getHighlighter();
        for (Highlighter.Highlight highlight : highlights = highlighter.getHighlights()) {
            if (highlight.getPainter() != PAINTER) continue;
            highlighter.removeHighlight(highlight);
        }
    }

    private static class UnderlineHighlighterPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        private static final int HEIGHT_PIXELS = 1;

        public UnderlineHighlighterPainter(Color color) {
            super(color);
        }

        @Override
        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
            Color color = this.getColor();
            if (color == null) {
                g.setColor(c.getSelectionColor());
            } else {
                g.setColor(color);
            }
            return this.paintUnderline(g, offs0, offs1, c, color);
        }

        public void undoUnderline(Highlighter.Highlight highlight, JTextComponent editor) {
            this.paintUnderline(editor.getGraphics(), highlight.getStartOffset(), highlight.getEndOffset(), editor, editor.getBackground());
        }

        private Rectangle paintUnderline(Graphics g, int startOffset, int endOffset, JTextComponent editor, Color c) {
            try {
                Rectangle p0 = editor.modelToView(startOffset);
                Rectangle p1 = editor.modelToView(endOffset);
                Rectangle underline = new Rectangle(p0.x, p0.y + p0.height - 1, p1.x - p0.x, 1);
                this.fillRectangle(g, underline);
                return underline;
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }

        private void fillRectangle(Graphics g, Rectangle underline) {
            g.fillRect(underline.x, underline.y, underline.width, underline.height);
        }
    }
}

