/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GosuEditor;
import editor.ITabHistoryContext;
import editor.ITabHistoryHandler;
import editor.TabSelectionHistoryItem;
import editor.tabpane.ITab;
import editor.tabpane.TabPane;
import editor.undo.AtomicUndoManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.StateEdit;

public class NavigationHistory {
    public static final int MAX_MRU_HISTORY = 30;
    public static final int MAX_NAVIGATION_HISTORY = 100;
    private TabPane _tabPane;
    private AtomicUndoManager _undoMgr;
    private GosuEditor _prevTab;
    private boolean _bLocked;
    private ITabHistoryHandler _tabHistoryHandler;
    private List<ITabHistoryContext> _tabMruList;

    public NavigationHistory(TabPane tabPane) {
        this._tabPane = tabPane;
        this._undoMgr = new AtomicUndoManager(100);
        this._tabMruList = new ArrayList<ITabHistoryContext>();
        this._tabPane.addSelectionListener(new TabSelectionHandler());
    }

    public void goBackward() {
        if (this.canGoBackward()) {
            this._undoMgr.undo();
        }
    }

    public void goForward() {
        if (this.canGoForward()) {
            this._undoMgr.redo();
        }
    }

    public boolean canGoBackward() {
        return this._undoMgr.canUndo();
    }

    public boolean canGoForward() {
        return this._undoMgr.canRedo();
    }

    public TabPane getTabPane() {
        return this._tabPane;
    }

    public ITabHistoryHandler getTabHistoryHandler() {
        return this._tabHistoryHandler;
    }

    public void setTabHistoryHandler(ITabHistoryHandler tabHistoryHandler) {
        this._tabHistoryHandler = tabHistoryHandler;
    }

    public List<ITabHistoryContext> getTabMruList() {
        return this._tabMruList;
    }

    public GosuEditor getPreviousEditor() {
        return this._prevTab;
    }

    public void dispose() {
        this._undoMgr = new AtomicUndoManager(100);
        this._tabMruList.clear();
        this._prevTab = null;
    }

    public void resourceDeleted(String strTypeName) {
        Iterator<ITabHistoryContext> it = this._tabMruList.iterator();
        while (it.hasNext()) {
            ITabHistoryContext iTabHistoryContext = it.next();
            if (iTabHistoryContext == null || !iTabHistoryContext.getContentId().equals(strTypeName)) continue;
            it.remove();
        }
    }

    public void addNavigationHistory(GosuEditor editor, int prevCaretPos, int currentCaretPos) {
        TabSelectionHistoryItem undoItem = new TabSelectionHistoryItem(this, editor, prevCaretPos, editor, currentCaretPos);
        StateEdit transaction = new StateEdit(undoItem, "navigation");
        transaction.end();
        this._undoMgr.addEdit(transaction);
    }

    void unlock() {
        this._bLocked = false;
    }

    void lock() {
        this._bLocked = true;
    }

    boolean isLocked() {
        return this._bLocked;
    }

    private void addToMruList(ITabHistoryContext tabHistoryContext) {
        if (this._tabMruList.contains(tabHistoryContext)) {
            this._tabMruList.remove(tabHistoryContext);
        }
        this._tabMruList.add(0, tabHistoryContext);
        if (this._tabMruList.size() > 30) {
            this._tabMruList.remove(this._tabMruList.size() - 1);
        }
    }

    private class TabSelectionHandler
    implements ChangeListener {
        private TabSelectionHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            GosuEditor editor;
            ITab selectedTab = NavigationHistory.this._tabPane.getSelectedTab();
            GosuEditor gosuEditor = editor = selectedTab == null ? null : (GosuEditor)selectedTab.getContentPane();
            if (editor != null) {
                NavigationHistory.this.addToMruList(NavigationHistory.this._tabHistoryHandler.makeTabContext(editor));
            }
            if (NavigationHistory.this._prevTab == editor) {
                return;
            }
            if (NavigationHistory.this.isLocked()) {
                NavigationHistory.this._prevTab = editor;
                return;
            }
            if (!NavigationHistory.this._undoMgr.canUndo() && NavigationHistory.this._prevTab == null) {
                NavigationHistory.this._prevTab = editor;
                return;
            }
            if (editor == null) {
                return;
            }
            TabSelectionHistoryItem undoItem = new TabSelectionHistoryItem(NavigationHistory.this, NavigationHistory.this._prevTab, -1, NavigationHistory.this._prevTab = editor, -1);
            StateEdit transaction = new StateEdit(undoItem, "tab selection");
            transaction.end();
            NavigationHistory.this._undoMgr.addEdit(transaction);
        }
    }
}

