/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.BooleanValueCompletion;
import editor.EnumerationValueCompletion;
import editor.GosuEditor;
import editor.IParseExceptionResolver;
import editor.NumberValueCompletion;
import editor.StringValueCompletion;
import gw.lang.parser.exceptions.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;

public class ParseExceptionIntellisense {
    private static final ParseExceptionIntellisense INSTANCE = new ParseExceptionIntellisense();
    private static final WeakHashMap<GosuEditor, List<? extends IParseExceptionResolver>> HANDLERS_BY_EDITOR = new WeakHashMap();
    private static final List<Class<? extends IParseExceptionResolver>> HANDLER_TYPES = new ArrayList<Class<? extends IParseExceptionResolver>>();

    public static ParseExceptionIntellisense instance() {
        return INSTANCE;
    }

    private ParseExceptionIntellisense() {
    }

    public void resolve(GosuEditor gsEditor, ParseException pe) {
        List<? extends IParseExceptionResolver> handlers = this.getHandlers(gsEditor);
        for (IParseExceptionResolver iParseExceptionResolver : handlers) {
            if (!iParseExceptionResolver.canResolve(pe)) continue;
            iParseExceptionResolver.resolve(pe);
            break;
        }
    }

    public boolean canResolve(GosuEditor gsEditor, ParseException pe) {
        List<? extends IParseExceptionResolver> handlers = this.getHandlers(gsEditor);
        for (IParseExceptionResolver iParseExceptionResolver : handlers) {
            if (!iParseExceptionResolver.canResolve(pe)) continue;
            return true;
        }
        return false;
    }

    private List<? extends IParseExceptionResolver> getHandlers(GosuEditor gsEditor) {
        List<? extends IParseExceptionResolver> handlers = HANDLERS_BY_EDITOR.get(gsEditor);
        if (handlers == null) {
            handlers = this.initHandlers(gsEditor);
        }
        return handlers;
    }

    private List<? extends IParseExceptionResolver> initHandlers(GosuEditor gsEditor) {
        ArrayList<IParseExceptionResolver> handlers = new ArrayList<IParseExceptionResolver>(HANDLER_TYPES.size());
        for (Class<? extends IParseExceptionResolver> type : HANDLER_TYPES) {
            try {
                IParseExceptionResolver handler = type.newInstance();
                handlers.add(handler);
                handler.setGosuEditor(gsEditor);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        HANDLERS_BY_EDITOR.put(gsEditor, handlers);
        return handlers;
    }

    static {
        HANDLER_TYPES.add(BooleanValueCompletion.class);
        HANDLER_TYPES.add(NumberValueCompletion.class);
        HANDLER_TYPES.add(EnumerationValueCompletion.class);
        HANDLER_TYPES.add(StringValueCompletion.class);
    }
}

