/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.IIntelliTextModel;
import gw.util.Predicate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;

public abstract class PopupListModel
extends AbstractListModel
implements IIntelliTextModel {
    private String _strFilterPrefix;
    private Predicate _filter;

    protected PopupListModel() {
        this._filter = null;
    }

    protected PopupListModel(Predicate filter) {
        this._filter = filter;
    }

    public abstract PopupListModel createSubset(List var1);

    public abstract List getModel();

    public abstract List getUnfilteredModel();

    public void setFilter(Predicate filter) {
        this._filter = filter;
    }

    public Predicate getFilter() {
        return this._filter;
    }

    @Override
    public int getSize() {
        return this.getModelUpdatedOrFilteredByPredicate().size();
    }

    @Override
    public Object getElementAt(int iIndex) {
        List modelFilteredByPredicate = this.getModelUpdatedOrFilteredByPredicate();
        return modelFilteredByPredicate.size() == 0 ? null : modelFilteredByPredicate.get(iIndex);
    }

    @Override
    public String getFilterPrefix() {
        return this._strFilterPrefix;
    }

    @Override
    public IIntelliTextModel getFilteredModel(String strPrefix) {
        int iDotIndex;
        if (strPrefix != null && strPrefix.length() > 0 && (iDotIndex = strPrefix.lastIndexOf(46)) >= 0) {
            strPrefix = strPrefix.substring(iDotIndex + 1);
        }
        this._strFilterPrefix = strPrefix;
        ArrayList filteredList = new ArrayList();
        List model = this.getUnfilteredModel();
        for (int i = 0; i < model.size(); ++i) {
            Object element = model.get(i);
            String strElement = this.getDisplayText(element);
            if (strPrefix != null && strPrefix.length() != 0 && !strElement.toLowerCase().startsWith(strPrefix.toLowerCase())) continue;
            filteredList.add(element);
        }
        return this.createSubset(filteredList);
    }

    public List getModelUpdatedOrFilteredByPredicate() {
        ArrayList model = this.getModel();
        if (this._filter != null) {
            model = new ArrayList(model);
            Iterator it = model.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (this._filter.evaluate(o)) continue;
                it.remove();
            }
        }
        return model;
    }
}

