/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractRangeCellRenderer;
import editor.RangeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class RangeCellRenderer
extends AbstractRangeCellRenderer {
    private JLabel _hyphen;
    private JLabel _labelName;
    private RangeModel _model;

    public RangeCellRenderer(RangeModel model, JList list) {
        super(list);
        this._model = model;
        this.init();
    }

    @Override
    protected void setUpLabels() {
        this._labelName = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                pref.width = RangeCellRenderer.this._iMaxCodeWidth;
                return pref;
            }
        };
        this._labelName.setOpaque(false);
        JPanel codePanel = new JPanel(new BorderLayout());
        codePanel.setOpaque(false);
        this._hyphen = new JLabel("  -  ");
        this._hyphen.setOpaque(false);
        codePanel.add((Component)this._labelName, "West");
        codePanel.add((Component)this._hyphen, "East");
        this.add((Component)codePanel, "West");
    }

    @Override
    protected void setLabelsValues(JList list, Object value, boolean isSelected) {
        if (isSelected) {
            this._labelName.setForeground(list.getSelectionForeground());
            this._hyphen.setForeground(list.getSelectionForeground());
        } else {
            this._labelName.setForeground(list.getForeground());
            this._hyphen.setForeground(list.getForeground());
        }
        this._labelName.setEnabled(list.isEnabled());
        this._labelName.setFont(list.getFont());
        this._labelName.setText(value == null ? "" : this._model.getDisplayText(value));
        this._hyphen.setEnabled(list.isEnabled());
        this._hyphen.setFont(list.getFont());
    }

    @Override
    protected int getCodeWidth(FontMetrics fm, Object obj) {
        return fm.stringWidth(this._model.getDisplayText(obj));
    }
}

