/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GosuEditor;
import editor.ITabHistoryContext;
import editor.NavigationHistory;
import editor.RunMe;
import editor.util.SettleModalEventQueue;
import gw.util.GosuObjectUtil;
import java.io.File;
import java.util.Hashtable;
import javax.swing.undo.StateEditable;

public class TabSelectionHistoryItem
implements StateEditable {
    private NavigationHistory _tabHistory;
    private ITabHistoryContext _tabContext;
    private int _caretPos;
    private ITabHistoryContext _prevTabContext;
    private int _prevCaretPos;
    private boolean _bUndo;

    public TabSelectionHistoryItem(NavigationHistory tabHistory, GosuEditor prevTab, int prevCaretPos, GosuEditor selectedTab, int caretPos) {
        this._tabHistory = tabHistory;
        this._prevTabContext = this._tabHistory.getTabHistoryHandler().makeTabContext(prevTab);
        this._prevCaretPos = prevCaretPos;
        this._tabContext = this._tabHistory.getTabHistoryHandler().makeTabContext(selectedTab);
        this._caretPos = caretPos;
        this._bUndo = true;
    }

    public void storeState(Hashtable stateTable) {
        stateTable.put("_undo", this._bUndo ? Boolean.TRUE : Boolean.FALSE);
        this._bUndo = !this._bUndo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreState(Hashtable stateTable) {
        this._tabHistory.lock();
        try {
            boolean bUndo = (Boolean)stateTable.get("_undo");
            if (!GosuObjectUtil.equals((Object)this._prevTabContext, (Object)this._tabContext)) {
                assert (this._caretPos < 0 && this._prevCaretPos < 0);
                this._tabHistory.getTabHistoryHandler().selectTab(bUndo ? this._prevTabContext : this._tabContext);
            } else if (bUndo) {
                GosuEditor editor = RunMe.getEditorFrame().getGosuPanel().findTab((File)this._prevTabContext.getContentId());
                this._caretPos = editor.getEditor().getCaretPosition();
                editor.getEditor().setCaretPosition(this._prevCaretPos);
            } else {
                GosuEditor editor = RunMe.getEditorFrame().getGosuPanel().findTab((File)this._tabContext.getContentId());
                editor.getEditor().setCaretPosition(this._caretPos);
            }
            SettleModalEventQueue.instance().run();
        }
        finally {
            this._tabHistory.unlock();
        }
    }
}

