/*
 * Decompiled with CFR 0.152.
 */
package editor.actions;

import editor.actions.ConditionalActionHandler;
import editor.actions.ConditionalNameActionHandler;
import editor.actions.ToggleConditionalActionHandler;
import editor.util.EditorUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GenericAction
extends AbstractAction
implements ChangeListener {
    public static final String ACTION_PROPERTY = "_genericAction";
    public static final String CTRL = "CTRL";
    public static final String ALT = "ALT";
    public static final String SHIFT = "SHIFT";
    public static final String TAG_CONTEXTS = "contexts";
    private ConditionalActionHandler _actionHandler;

    public GenericAction() {
    }

    public GenericAction(String strId, String strName, String icon, char cMnemonic, KeyStroke accel, String strShortDesc, String strLongDesc) {
        this.putValue("Name", strName);
        if (strId != null) {
            this.putValue("ActionCommandKey", strId);
        }
        if (icon != null) {
            this.setIcon(EditorUtilities.loadIcon(icon));
        }
        if (cMnemonic != '\u0000') {
            this.putValue("MnemonicKey", new Integer(cMnemonic));
        }
        if (accel != null) {
            this.putValue("AcceleratorKey", accel);
        }
        if (strShortDesc != null) {
            this.putValue("ShortDescription", strShortDesc);
        }
        if (strLongDesc != null) {
            this.putValue("LongDescription", strLongDesc);
        }
    }

    public String getId() {
        return (String)this.getValue("ActionCommandKey");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(() -> {
            if (this.isEnabled()) {
                this._actionHandler.actionPerformed(e);
            }
        });
    }

    @Override
    public boolean isEnabled() {
        if (this._actionHandler == null) {
            return false;
        }
        return this._actionHandler.isEnabled();
    }

    public boolean isSelected() {
        if (this._actionHandler instanceof ToggleConditionalActionHandler) {
            return ((ToggleConditionalActionHandler)this._actionHandler).isSelected();
        }
        return false;
    }

    public String getName() {
        if (this._actionHandler instanceof ConditionalNameActionHandler) {
            return ((ConditionalNameActionHandler)this._actionHandler).getDisplayName();
        }
        return (String)this.getValue("Name");
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public ConditionalActionHandler getConditionalActionHandler() {
        return this._actionHandler;
    }

    public void setConditionalActionHandler(ConditionalActionHandler actionHandler) {
        this._actionHandler = actionHandler;
    }

    protected KeyStroke parseAccelerator(String strAccelerator) {
        int iKeyCode = -1;
        int iModifier = 0;
        StringTokenizer tokenizer = new StringTokenizer(strAccelerator, " \t\n\r\f+");
        block12: while (tokenizer.hasMoreTokens()) {
            String tok;
            switch (tok = tokenizer.nextToken()) {
                case "CTRL": {
                    iModifier |= 0x80;
                    continue block12;
                }
                case "ALT": {
                    iModifier |= 0x200;
                    continue block12;
                }
                case "SHIFT": {
                    iModifier |= 0x40;
                    continue block12;
                }
            }
            if (tok.length() == 1) {
                iKeyCode = tok.charAt(0);
                continue;
            }
            try {
                iKeyCode = (Integer)KeyEvent.class.getField("VK_" + tok.toUpperCase()).get(null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return iKeyCode == -1 ? null : KeyStroke.getKeyStroke(iKeyCode, iModifier);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }
}

