/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import editor.search.MessageBox;
import editor.search.StudioUtilities;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingConstants;

public class MessageDisplay
implements SwingConstants {
    public static final String HOME_DIR = System.getProperty("user.dir");
    static final String STRING_DELIMITERS = " \t\n\r";
    static final Rectangle SCRATCH_RECT = new Rectangle();
    static final Rectangle SCRATCH_RECT2 = new Rectangle();
    private static String _testError;

    public static void Log(Throwable t) {
        System.err.println("\r\n" + t.getMessage() + "\r\n" + new Date(System.currentTimeMillis()) + "\r\n");
        t.printStackTrace();
        MessageDisplay.displayError("Error performing operation.");
    }

    public static void displayError(Throwable e) {
        MessageDisplay.displayMessageBox(e == null ? "Error performing operation." : e.getMessage(), 0, false);
    }

    public static void displayError(String strMsg) {
        MessageDisplay.displayMessageBox(strMsg, 0, false);
    }

    public static void displayErrorNoWrap(String strMsg) {
        MessageDisplay.displayMessageBox(strMsg, 0, false, false);
    }

    public static void displayWarning(String strMsg) {
        MessageDisplay.displayMessageBox(strMsg, 2, false);
    }

    public static void displayInformation(String strMsg) {
        MessageDisplay.displayMessageBox(strMsg, 1, false);
    }

    public static void displayMessageBox(String strMsg, int iType, boolean bNonModalMsg) {
        MessageDisplay.displayMessageBox(strMsg, iType, bNonModalMsg, true);
    }

    public static void displayMessageBox(String strMsg, final int iType, final boolean bNonModalMsg, boolean bWrapText) {
        final String strWrappedMsg = bWrapText ? StudioUtilities.wrapText(strMsg) : strMsg;
        Runnable logMsgBox = new Runnable(){

            @Override
            public void run() {
                if (!bNonModalMsg) {
                    MessageBox.showMessageDialog(strWrappedMsg, iType);
                } else {
                    MessageDisplay.showMessageNonModal(strWrappedMsg, iType);
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            logMsgBox.run();
        } else {
            try {
                EventQueue.invokeAndWait(logMsgBox);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static String getLastTestError() {
        return _testError;
    }

    public static void clearTestError() {
        _testError = null;
    }

    public static void showMessageNonModal(String strMsg) {
        MessageDisplay.showMessageNonModal(strMsg, 1);
    }

    public static void showMessageNonModal(String strMsg, int iType) {
        JOptionPane pane = new JOptionPane(StudioUtilities.wrapText(strMsg), iType);
        JDialog dialog = pane.createDialog(null, "");
        dialog.setModal(false);
        dialog.show();
        dialog.setModal(true);
    }

    public static int displayConfirmation(String strMsg, int iButtonsType) {
        return MessageDisplay.displayConfirmation(strMsg, iButtonsType, null);
    }

    public static int displayConfirmation(String strMsg, int iButtonsType, String[] astrButtonLabels) {
        return MessageDisplay.displayConfirmation(strMsg, iButtonsType, 3, astrButtonLabels, null);
    }

    public static int displayConfirmation(String strMsg, int iButtonsType, String[] astrButtonLabels, Point loc) {
        return MessageDisplay.displayConfirmation(strMsg, iButtonsType, 3, astrButtonLabels, loc);
    }

    public static int displayConfirmation(String strMsg, final int iButtonsType, final int iType, final String[] astrButtonLabels, final Point loc) {
        final String strWrappedMsg = StudioUtilities.wrapText(strMsg);
        final int[] aiResult = new int[1];
        Runnable confirmationBox = new Runnable(){

            @Override
            public void run() {
                aiResult[0] = MessageBox.showConfirmDialog((Frame)MessageDisplay.getFrame(), strWrappedMsg, iButtonsType, iType, loc, astrButtonLabels);
            }
        };
        if (EventQueue.isDispatchThread()) {
            confirmationBox.run();
        } else {
            try {
                EventQueue.invokeAndWait(confirmationBox);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return aiResult[0];
    }

    public static Point getLastMessageLocation() {
        return MessageBox.getLastMessageLocation();
    }

    public static JFrame getFrame() {
        if (StudioUtilities.getActiveWindow() instanceof JFrame) {
            return (JFrame)StudioUtilities.getActiveWindow();
        }
        return null;
    }

    public static void centerWindowInFrame(Window window, Frame frame) {
        StudioUtilities.centerWindowInFrame(window, frame);
    }
}

